/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.pdf.fop.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.asyrinx.brownie.core.io.StreamUtils;
import org.asyrinx.brownie.core.io.sf.StreamFactoryFacade;
import org.asyrinx.brownie.core.xml.dom.XmlBeanWriter;
import org.asyrinx.brownie.pdf.fop.FopInvoker;
import org.asyrinx.brownie.pdf.fop.PdfException;
import org.asyrinx.brownie.pdf.fop.PdfMaker;

public class PdfMakerImpl
implements PdfMaker {
    protected final FopInvoker fopInvoker;
    protected final XmlBeanWriter xmlBeanWriter;
    private OutputStream domOutput = null;
    protected final Log log = LogFactory.getLog(this.getClass());

    public PdfMakerImpl(FopInvoker fopInvoker, XmlBeanWriter xmlBeanWriter) {
        this.fopInvoker = fopInvoker;
        this.xmlBeanWriter = xmlBeanWriter;
    }

    public void execute(Object bean, String xslFqn, OutputStream dest, String rootName) throws PdfException {
        InputStream xsl;
        try {
            this.log.debug((Object)("loading xsl: " + xslFqn));
            xsl = StreamFactoryFacade.newFacade().newInput(xslFqn);
        }
        catch (IOException e) {
            this.log.error((Object)("failed to load xsl: " + xslFqn));
            throw new PdfException(e);
        }
        this.execute(bean, xsl, dest, rootName);
    }

    public void execute(Object bean, InputStream xsl, OutputStream dest, String rootName) throws PdfException {
        ByteArrayOutputStream domOut = new ByteArrayOutputStream();
        try {
            this.log.debug((Object)("building bean dom: " + bean));
            this.xmlBeanWriter.execute(bean, domOut, rootName);
        }
        catch (Exception e) {
            throw new PdfException("failed to build bean dom.", e);
        }
        ByteArrayInputStream domIn = new ByteArrayInputStream(domOut.toByteArray());
        if (this.domOutput != null) {
            try {
                StreamUtils.copy((InputStream)domIn, this.domOutput);
            }
            catch (IOException e1) {
                throw new PdfException("failed to output entity xml.");
            }
            domIn.reset();
        }
        this.execute(domIn, xsl, dest, rootName);
    }

    public void execute(InputStream beanDom, InputStream xsl, OutputStream dest, String rootName) throws PdfException {
        try {
            this.log.debug((Object)"invoking fop: ");
            this.fopInvoker.execute(beanDom, xsl, dest);
        }
        catch (FOPException e) {
            throw new PdfException(e);
        }
    }

    public OutputStream getDomOutput() {
        return this.domOutput;
    }

    public void setDomOutput(OutputStream domOutput) {
        this.domOutput = domOutput;
    }
}

