/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.swing.table;

import java.util.ArrayList;
import java.util.Collections;
import javax.swing.table.TableModel;
import org.apache.commons.lang.ObjectUtils;
import org.asyrinx.brownie.swing.table.util.SimpleSortableTableModel;
import org.asyrinx.brownie.swing.table.wrapper.TableModelWrapper;

class SimpleSortableTableModelImpl
extends TableModelWrapper
implements SimpleSortableTableModel {
    private int[] rowIndexMap = null;

    public SimpleSortableTableModelImpl(TableModel model) {
        super(model);
    }

    public void sort(int columnIndex, boolean reverse) {
        if (this.model.getRowCount() < 2) {
            return;
        }
        ArrayList<SortEntry> list = new ArrayList<SortEntry>();
        int row = 0;
        while (row < this.model.getRowCount()) {
            list.add(new SortEntry(ObjectUtils.toString((Object)this.model.getValueAt(row, columnIndex)), row));
            ++row;
        }
        Collections.sort(list);
        this.rowIndexMap = new int[list.size()];
        int i = 0;
        while (i < this.rowIndexMap.length) {
            int listIndex = reverse ? this.rowIndexMap.length - 1 - i : i;
            SortEntry entry = (SortEntry)list.get(listIndex);
            this.rowIndexMap[i] = entry.row;
            ++i;
        }
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.model.getValueAt(this.getOriginalRowIndex(rowIndex), columnIndex);
    }

    public int getOriginalRowIndex(int sortedRowIndex) {
        return this.rowIndexMap == null ? sortedRowIndex : this.rowIndexMap[sortedRowIndex];
    }

    class SortEntry
    implements Comparable {
        final String value;
        final int row;

        public SortEntry(String value, int row) {
            this.value = value != null ? value : "";
            this.row = row;
        }

        public int compareTo(Object o) {
            return this.value.compareTo(((SortEntry)o).value);
        }
    }
}

