/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.swing.table.key;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.asyrinx.brownie.swing.table.key.KeyColumn;
import org.asyrinx.brownie.swing.table.key.RowKey;
import org.asyrinx.brownie.swing.table.key.RowKeyContainer;
import org.asyrinx.brownie.swing.table.util.UpdatableTableModel;

public abstract class KeyColumnTableModel
extends UpdatableTableModel
implements RowKeyContainer {
    protected final TableModel tableModel;
    private final List keyList = new ArrayList();
    private final List keyColumns = new ArrayList();

    public KeyColumnTableModel(TableModel tableModel) {
        this.tableModel = tableModel;
    }

    public KeyColumnTableModel(TableModel tableModel, int[] keyColumns) {
        this.tableModel = tableModel;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initKeyColumns(int[] keyCols) {
        this.beginUpdate();
        try {
            this.keyColumns.clear();
            int i = 0;
            while (i < keyCols.length) {
                this.addKeyColumn(keyCols[i]);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.endUpdate();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.endUpdate();
    }

    public abstract void refreshKeys();

    protected KeyColumn findKeyColumn(int originalColumnIndex) {
        Iterator iter = this.keyColumns.iterator();
        while (iter.hasNext()) {
            KeyColumn keyColumn = (KeyColumn)iter.next();
            if (keyColumn.getOriginalColumnIndex() != originalColumnIndex) continue;
            return keyColumn;
        }
        return null;
    }

    protected void initEventListener() {
        this.tableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                if (e.getColumn() == -1) {
                    KeyColumnTableModel.this.refreshKeys();
                } else {
                    KeyColumn keyColumn = KeyColumnTableModel.this.findKeyColumn(e.getColumn());
                    if (keyColumn != null) {
                        KeyColumnTableModel.this.refreshKeys();
                    }
                }
                KeyColumnTableModel.this.fireTableChanged(new TableModelEvent(KeyColumnTableModel.this, e.getFirstRow(), e.getLastRow(), e.getColumn()));
            }
        });
    }

    public void addKeyColumn(int originalColumnIndex) {
        KeyColumn keyColumn = new KeyColumn(originalColumnIndex, this.tableModel, this, this.keyColumns.size());
        this.addKeyColumn(keyColumn);
    }

    protected void addKeyColumn(KeyColumn keyColumn) {
        this.keyColumns.add(keyColumn);
        this.fireTableStructureChanged();
    }

    protected KeyColumn getKeyColumn(int index) {
        return (KeyColumn)this.keyColumns.get(index);
    }

    public int getKeyColumnCount() {
        return this.keyColumns.size();
    }

    public RowKey getKey(int rowIndex) {
        return (RowKey)this.keyList.get(rowIndex);
    }

    protected RowKey findKey(Object[] values) {
        RowKey key = new RowKey(values);
        int index = this.keyList.indexOf(key);
        return index > -1 ? (RowKey)this.keyList.get(index) : null;
    }

    protected void clearKeyList() {
        this.keyList.clear();
    }

    protected void sortKeyList(Comparator comparator) {
        Collections.sort(this.keyList, comparator);
    }

    protected void addRowKey(RowKey rowKey) {
        this.keyList.add(rowKey);
    }

    public int getRowCount() {
        return this.keyList.size();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        throw new UnsupportedOperationException();
    }

    public int getColumnCount() {
        return this.tableModel.getColumnCount();
    }

    public String getColumnName(int column) {
        return this.tableModel.getColumnName(column);
    }

    public Class getColumnClass(int columnIndex) {
        return this.tableModel.getColumnClass(columnIndex);
    }
}

