/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.tapestry.components.subwindow;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.INamespace;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.ILink;

public abstract class SubWindowLink
extends BaseComponent {
    private String pageHref = null;
    public static final String DEFAULT_WINDOW_NAME = "subwindowlink_window";
    private static final URLCodec _urlCodec = new URLCodec();
    private IBinding _hrefBinding;
    private IBinding _windowNameBinding;
    private IBinding _featuresBinding;
    private String mappingSpanId = "property2field";

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        this.preparePageHref(cycle);
        super.renderComponent(writer, cycle);
    }

    private void preparePageHref(IRequestCycle cycle) {
        if (StringUtils.isEmpty((String)this.getTargetPage())) {
            return;
        }
        ILink l = this.getLink(cycle);
        this.pageHref = this.constructURL(l, this.getAnchor(), cycle);
    }

    public ILink getLink(IRequestCycle cycle) {
        INamespace namespace = this.getTargetNamespace();
        String targetPage = this.getTargetPage();
        String parameter = namespace == null ? targetPage : namespace.constructQualifiedName(targetPage);
        return this.getLink(cycle, "page", new String[]{parameter});
    }

    protected ILink getLink(IRequestCycle cycle, String serviceName, Object[] serviceParameters) {
        IEngineService service = cycle.getEngine().getService(serviceName);
        return service.getLink(cycle, (IComponent)this, serviceParameters);
    }

    protected String constructURL(ILink link, String anchor, IRequestCycle cycle) {
        return link.getURL(anchor, true);
    }

    public IBinding getHrefBinding() {
        return this._hrefBinding;
    }

    public void setHrefBinding(IBinding hrefBinding) {
        this._hrefBinding = hrefBinding;
    }

    public IBinding getWindowNameBinding() {
        return this._windowNameBinding;
    }

    public void setWindowNameBinding(IBinding windowNameBinding) {
        this._windowNameBinding = windowNameBinding;
    }

    public IBinding getFeaturesBinding() {
        return this._featuresBinding;
    }

    public void setFeaturesBinding(IBinding featuresBinding) {
        this._featuresBinding = featuresBinding;
    }

    public String getHref() {
        if (!StringUtils.isEmpty((String)this.pageHref)) {
            return this.pageHref;
        }
        if (!this.isHrefEncoding()) {
            return this.getHrefBinding().getString();
        }
        IBinding aHrefBinding = this.getHrefBinding();
        if (aHrefBinding != null) {
            String encoding = this.getPage().getEngine().getOutputEncoding();
            try {
                return _urlCodec.encode(aHrefBinding.getString(), encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new ApplicationRuntimeException(Tapestry.format((String)"illegal-encoding", (Object)encoding), (Throwable)e);
            }
        }
        return null;
    }

    public String getWindowName() {
        IBinding aWindowNameBinding = this.getWindowNameBinding();
        if (aWindowNameBinding != null) {
            return aWindowNameBinding.getString();
        }
        return DEFAULT_WINDOW_NAME;
    }

    public String getFeatures() {
        IBinding aFeaturesBinding = this.getFeaturesBinding();
        if (aFeaturesBinding != null) {
            return aFeaturesBinding.getString();
        }
        return "";
    }

    public String getPopupFunctionName() {
        return String.valueOf(this.getIdPath().replace('.', '_')) + "_click";
    }

    public abstract Map getFieldMapping();

    public String getMappingSpanId() {
        return this.mappingSpanId;
    }

    public void setMappingSpanId(String mappingSpanId) {
        this.mappingSpanId = mappingSpanId;
    }

    public abstract boolean isHrefEncoding();

    public abstract INamespace getTargetNamespace();

    public abstract String getTargetPage();

    public abstract String getAnchor();
}

