/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.tapestry.components.util;

import java.lang.reflect.InvocationTargetException;
import java.text.Format;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;

public abstract class InsertProperty
extends AbstractComponent {
    public abstract IBinding getFormatBinding();

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        if (cycle.isRewinding()) {
            return;
        }
        Object value = this.getValue();
        if (value == null) {
            return;
        }
        String insert = null;
        Format format = this.getFormat();
        if (format == null) {
            insert = value.toString();
        } else {
            try {
                insert = format.format(value);
            }
            catch (Exception ex) {
                throw new ApplicationRuntimeException(Tapestry.format((String)"Insert.unable-to-format", (Object)value), (Object)this, this.getFormatBinding().getLocation(), (Throwable)ex);
            }
        }
        String styleClass = this.getStyleClass();
        if (styleClass != null) {
            writer.begin("span");
            writer.attribute("class", styleClass);
            this.renderInformalParameters(writer, cycle);
        }
        if (this.getRaw()) {
            writer.printRaw(insert);
        } else {
            writer.print(insert);
        }
        if (styleClass != null) {
            writer.end();
        }
    }

    private Object getValue() {
        Object bean = this.getBean();
        String property = this.getProperty();
        if (bean == null) {
            if (this.isStrict()) {
                throw new ApplicationRuntimeException("bean was null");
            }
            return null;
        }
        try {
            return PropertyUtils.getProperty((Object)bean, (String)property);
        }
        catch (IllegalAccessException e) {
            throw new ApplicationRuntimeException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ApplicationRuntimeException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            if (this.isStrict()) {
                throw new ApplicationRuntimeException((Throwable)e);
            }
            return null;
        }
    }

    public abstract Object getBean();

    public abstract String getProperty();

    public abstract Format getFormat();

    public abstract String getStyleClass();

    public abstract boolean getRaw();

    public abstract boolean isStrict();
}

