package junkutil.set;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

import junkutil.common.StringUtil;

/**
 * ListW_IɈB
 * @author Hiroyuki Shiota
 */
public class LzList {
	private java.util.List base;

	/**
	 * RXgN^
	 */
	public LzList() {
		base = new ArrayList();
	}
	/**
	 * RXgN^
	 * @param list
	 */
	public LzList(List list) {
		base = list;
	}
	/**
	 * RXgN^
	 * @param list
	 */
	public LzList(Object[] args) {
		base = Arrays.asList(args);
	}
	/**
	 * RXgN^
	 * @param list
	 */
	public LzList(Set set) {
		base = Arrays.asList(set.toArray());
	}

	/**
	 * Xg擾B
	 * @return
	 */
	public List list() {
		return base;
	}
	
	/**
	 * or擾B
	 * @param arg
	 * @return
	 */
	public LzList or(List arg) {
		List list = new ArrayList(base);
		for (int i = 0; i < arg.size(); i++) {
			if (!base.contains(arg.get(i))) list.add(arg.get(i));
		}
		return new LzList(list);
	}
	
	/**
	 * and擾B
	 * @param arg
	 * @return
	 */
	public LzList and(List arg) {
		List list = new ArrayList();
		for (int i = 0; i < arg.size(); i++) {
			if (base.contains(arg.get(i))) list.add(arg.get(i));
		}
		return new LzList(list);
	}
	
	private Comparator compStrAsc = new Comparator() {
		public int compare(Object o1, Object o2) {
			return o1.toString().compareTo(o2.toString());
		}
	};
	private Comparator compStrDesc = new Comparator() {
		public int compare(Object o1, Object o2) {
			return -(o1.toString().compareTo(o2.toString()));
		}
	};
	
	/**
	 * Ń\[gB
	 * @return
	 */
	public LzList sortAsc() {
		return sort(compStrAsc);
	}
	
	/**
	 * ~Ń\[gB
	 * @return
	 */
	public LzList sortDesc() {
		return sort(compStrDesc);
	}
	
	/**
	 * w菇Ń\[gB
	 * @return
	 */
	public LzList sort(Comparator c) {
		List list = new ArrayList(base);
		Collections.sort(list, c);
		return new LzList(list);
	}
	
	/**
	 * i荞݂sBnull͏OB
	 * @param re
	 * @return
	 */
	public LzList grep(String re) {
		List list = new ArrayList();
		Pattern pattern = Pattern.compile(re);
		for (int i = 0; i < base.size(); i++) {
			Object obj = base.get(i);
			if (obj == null) continue;
			if (StringUtil.match(obj.toString(), pattern)) {
				list.add(obj);
			}
		}
		return new LzList(list);
	}
	
	/**
	 * ti荞݂sBnull͏OB
	 * @param re
	 * @return
	 */
	public LzList ungrep(String re) {
		List list = new ArrayList();
		Pattern pattern = Pattern.compile(re);
		for (int i = 0; i < base.size(); i++) {
			Object obj = base.get(i);
			if (obj == null) continue;
			if (!StringUtil.match(obj.toString(), pattern)) {
				list.add(obj);
			}
		}
		return new LzList(list);
	}
	
	/**
	 * XgB
	 * @param arg
	 * @return
	 */
	public LzList join(List arg) {
		List list = new ArrayList(base);
		for (Iterator i = arg.iterator(); i.hasNext();) {
			list.add(i.next());
		}
		return new LzList(list);
	}
	
	/**
	 * j[NȃXg擾B
	 * @param arg
	 * @return
	 */
	public LzList uniq() {
		Map map = new HashMap();
		for (int i = 0; i < base.size(); i++) {
			map.put(base.get(i), Object.class);
		}
		return new LzList(new ArrayList(map.keySet()));
	}
	
	/**
	 * ǂeXgB
	 * @param arg
	 * @return
	 */
	public boolean equals(List arg) {
		if (base.size() != arg.size()) return false;
		for (int i = 0; i < base.size(); i++) {
			Object obj1 = base.get(i);
			Object obj2 = arg.get(i);
			if (!obj1.equals(obj2)) return false;
		}
		return true;
	}

	/**
	 * 𑵂ƁAǂeXgB
	 * @param arg
	 * @return
	 */
	public boolean equalsOnSort(List arg) {
		if (base.size() != arg.size()) return false;
		LzList sortedBase = new LzList(base).sortAsc();
		List sortedArg = new LzList(arg).sortAsc().list();
		return equals(arg);
	}
	
	/**
	 * ǂeXgB
	 * @param arg
	 * @return
	 */
	public boolean equals(String arg) {
		return toString().equals(arg);
	}
	
	/**
	 * 񉻂B
	 * @Override
	 */
	public String toString() {
		return base.toString();
	}
}
