package junkutil.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junkutil.common.OptGets;
import junkutil.common.StringUtil;

/**
 * IvV͂eXgB
 * @author Hiroyuki Shiota
 */
public class OptGetsTest extends TestCase {
	/**
	 * RXgN^
	 * @param name
	 */
	public OptGetsTest(String name) {
		super(name);
	}

	/**
	 * @return
	 */
	public static Test suite() {
		TestSuite test = new TestSuite("OptGetsTest");
		test.addTest(new TestSuite(OptGetsTest.class));
		return test;
	}

	/**
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
	}

	/**
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
	}

	/**
	 * @throws Exception
	 */
	public void testOptGets() throws Exception {
		try {
			String [] testArgs = new String [] {
				"-D", "-a", "-c", "CCC", "111", "222", "333"
			};
			List testList = new ArrayList();
			testList.add("111");
			testList.add("222");
			testList.add("333");
			String [] testStrs = new String[3];
			testStrs[0] = "111";
			testStrs[1] = "222";
			testStrs[2] = "333";
			OptGets optGets = new OptGets("abc:D");
			Map opts = optGets.parse(testArgs);
			if (opts.get("a") != Boolean.TRUE) { assertTrue(false); return; }
			if (opts.get("b") != Boolean.FALSE) { assertTrue(false); return; }
			if (!opts.get("c").equals("CCC")) { assertTrue(false); return; }
			if (opts.get("D") != Boolean.TRUE) { assertTrue(false); return; }
			List argList = optGets.getArgList();
			if (!argList.toString().equals(testList.toString())) { assertTrue(false); return; }
			String [] argStrs = optGets.getArgs();
			if (!StringUtil.equals(argStrs, testStrs)) { assertTrue(false); return; }
		} catch (Exception e) {
			e.printStackTrace();
			assertTrue(false);
			return;
		}
		assertTrue(true);
	}
}
