unit untTopic2chDolib;

interface

uses
  Classes,
  untTopic2ch, untOnlineBoard;

type
  TTopic2chDolib = class(TTopic2ch)
  public
    Freezed : Boolean;
    function  GetTopicURL : string; override;
    constructor Create(b: TOnlineBoard; TopicId: string);
    destructor Destroy; override;
  end;

implementation

uses
  DzURL, SysUtils,
  untGlobal;

{ TTopic2chDolib }

constructor TTopic2chDolib.Create(b: TOnlineBoard; TopicId: string);
begin
  inherited Create(b, TopicId);
end;

destructor TTopic2chDolib.Destroy;
begin

  inherited;
end;

function TTopic2chDolib.GetTopicURL: string;
begin
  result := 'http://' + (OnlineBoard as TOnlineBoard).Server +
                        '/test/offlaw.cgi/' +
                        (OnlineBoard as TOnlineBoard).BoardName + '/' +
                        TopicId + '/?raw=.' +
                        IntToStr(DatSize) + '&sid=' +
                        UrlEncode(gConfig.SessionId);
end;

end.
