unit untLoginForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TLoginForm = class(TForm)
    UserIdEdit: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    PasswordEdit: TEdit;
    SavePasswordCheckBox: TCheckBox;
    Button1: TButton;
    Button2: TButton;
    AutoLoginCheckBox: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure SavePasswordCheckBoxClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  LoginForm: TLoginForm;

implementation

uses
  untGlobal;

{$R *.dfm}

procedure TLoginForm.FormCreate(Sender: TObject);
begin
  UserIdEdit.Text   := gConfig.UserId;
  PasswordEdit.Text := gConfig.Password;
  SavePasswordCheckBox.Checked := gConfig.SavePassword;
  AutoLoginCheckBox.Checked    := gConfig.AutoLogin;

  SavePasswordCheckBoxClick(self);
end;

procedure TLoginForm.Button1Click(Sender: TObject);
begin
  gConfig.UserId       := UserIdEdit.Text;
  gConfig.Password     := PasswordEdit.Text;
  gConfig.SavePassword := SavePasswordCheckBox.Checked;
  gConfig.AutoLogin    := AutoLoginCheckBox.Checked and SavePasswordCheckBox.Checked;

  if gDolibLogin.Login then Close;
end;

procedure TLoginForm.Button2Click(Sender: TObject);
begin
  Close;
end;

procedure TLoginForm.SavePasswordCheckBoxClick(Sender: TObject);
begin
  AutoLoginCheckBox.Enabled := SavePasswordCheckBox.Checked;
end;

end.
