unit untMainForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, Forms, Dialogs, ComCtrls, StdCtrls, ToolWin,
  Menus, Contnrs, Taskbar, ActnList, ExtCtrls, ImgList,
  IdBaseComponent, IdAntiFreezeBase, IdAntiFreeze, IdComponent,
  untBoard, untBoardList, untTopicBrowser, untWriteForm, untTool,
  untGlobal, untTopic, untBoardCategory;

type
  TBoardListBoxItem = class
  public
    Category: TBoardCategory;
    Board: TBoard;
    ViewString: string;
  end;

  TMainForm = class(TForm)
    AddressToolBar : TToolBar;
    GoToToolButton : TToolButton;
    ToolBarImageList: TImageList;
    TopicListViewImageList: TImageList;
    Splitter1: TSplitter;
    RightPanel: TPanel;
    Splitter2: TSplitter;
    BrowserPanel: TPanel;
    TopicToolBar: TToolBar;
    ViewLimitToolButton: TToolButton;
    DownloadTopicToolButton: TToolButton;
    StopToolButton: TToolButton;
    ToolButton8: TToolButton;
    ToolButton12: TToolButton;
    TopicWriteToolButton: TToolButton;
    FavoriteToolButton: TToolButton;
    ToolButton15: TToolButton;
    TrashToolButton: TToolButton;
    CloseTabToolButton: TToolButton;
    TopicListViewPopupMenu: TPopupMenu;
    OpenNewTabMenuItem: TMenuItem;
    BoardNameLabel: TLabel;
    TopicNameLabel: TLabel;
    TopicPagePopupMenu: TPopupMenu;
    CloseMenuItem: TMenuItem;
    CloseAllMenuItem: TMenuItem;
    CloseWithoutMenuItem: TMenuItem;
    CopyUrlMenuItem: TMenuItem;
    CopyTitleUrlMenuItem: TMenuItem;
    OpenByBrowserMenuItem: TMenuItem;
    N01: TMenuItem;
    N7: TMenuItem;
    AutoReloadMenuItem: TMenuItem;
    TopicTabControl: TTabControl;
    ToolPopupMenu: TPopupMenu;
    OptionMenuItem: TMenuItem;
    N5: TMenuItem;
    UpdateBoardListMenuItem: TMenuItem;
    N9: TMenuItem;
    ViewLimitPopupMenu: TPopupMenu;
    ViewLimit50MenuItem: TMenuItem;
    ViewLimit100MenuItem: TMenuItem;
    ViewLimit250MenuItem: TMenuItem;
    ViewLimit500MenuItem: TMenuItem;
    ViewLimit1000MenuItem: TMenuItem;
    ViewLimitNothingMenuItem: TMenuItem;
    TopicListView: TListView;
    CoolBar: TCoolBar;
    MainToolBar: TToolBar;
    SearchToolButton: TToolButton;
    PatrolToolButton: TToolButton;
    MakeTopicToolButton: TToolButton;
    StyleToolButton: TToolButton;
    StyleSub1ToolButton: TToolButton;
    ToolButton10: TToolButton;
    ToolButton11: TToolButton;
    UrlEdit: TEdit;
    BoardButtonToolBar: TToolBar;
    BoardButton: TToolButton;
    AddressBarPopupMenu: TPopupMenu;
    N1: TMenuItem;
    URL3: TMenuItem;
    ToolButton4: TToolButton;
    ToolButton3: TToolButton;
    StyleSub2ToolButton: TToolButton;
    StyleSub3ToolButton: TToolButton;
    MainStatusBar: TStatusBar;
    RepaintTabTimer: TTimer;
    RepaintListViewTimer: TTimer;
    DownloadAllTopicToolButton: TToolButton;
    BoardListBoxPopupMenu: TPopupMenu;
    RegisterBoardButtonMenuItem: TMenuItem;
    N3: TMenuItem;
    CopyBoardUrlMenuButton: TMenuItem;
    OpenBoardByBrowserMenuItem: TMenuItem;
    LeftPanel: TPanel;
    BoardListBox: TListBox;
    ComboBox1: TComboBox;
    ArticlePopupMenu: TPopupMenu;
    N2: TMenuItem;
    LoginMenuItem: TMenuItem;
    N4: TMenuItem;
    SetPriorityMenuItem: TMenuItem;
    InputMemoMenuItem: TMenuItem;
    CopyUrlTopicList: TMenuItem;
    CopyTitleUrlTopicList: TMenuItem;
    OpenByBrowserTopicList: TMenuItem;
    N11: TMenuItem;
    CreateOfflineFolder: TMenuItem;
    RemoveOfflineFolder: TMenuItem;
    TrashMenuItem: TMenuItem;
    ResAtMenuItem: TMenuItem;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    BoardButtonPopupMenu: TPopupMenu;
    BoardDeleteMenuItem: TMenuItem;
    ActionList1: TActionList;
    ReceiveActiveTabAction: TAction;
    CloseActiveTabAction: TAction;
    TabForwardAction: TAction;
    TabBeforeAction: TAction;
    ChangeLimitAllActiveTab: TAction;
    ChangeStyle1Action: TAction;
    ChangeStyle2Action: TAction;
    ChangeStyle3Action: TAction;
    FavoritePopupMenu: TPopupMenu;
    SetPriorityPlus3ItemMenu: TMenuItem;
    SetPriorityPlus2ItemMenu: TMenuItem;
    SetPriorityPlus1ItemMenu: TMenuItem;
    SetPriorityZeroItemMenu: TMenuItem;
    SetPriorityMinus1ItemMenu: TMenuItem;
    SetPriorityMinus2ItemMenu: TMenuItem;
    SetPriorityMinus3ItemMenu: TMenuItem;
    BoardButtonToolBarPopupMenu: TPopupMenu;
    EditBoardButtonMenuItem: TMenuItem;
    N6: TMenuItem;
    N13: TMenuItem;
    N14: TMenuItem;
    OpenAllCategoryAction: TAction;
    CloseAllCategoryAction: TAction;
    LogSweeperAction: TAction;
    GoTrayAction: TAction;
    TopicTabImageList: TImageList;
    TrayIcon: TTrayIcon;
    LogSaveModeToolButton: TToolButton;
    SaveTopicToolButton: TToolButton;
    TopPanel: TPanel;
    Animate1: TAnimate;
    AboneMenuItem: TMenuItem;
    procedure StyleChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure BoardListBoxDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure BoardListBoxData(Control: TWinControl; Index: Integer;
      var Data: String);
    procedure BoardListBoxClick(Sender: TObject);
    procedure TopicListViewMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure OpenNewTabMenuItemClick(Sender: TObject);
    procedure TopicTabControlChange(Sender: TObject);
    procedure TopicWriteToolButtonClick(Sender: TObject);
    procedure TopicTabControlDrawTab(Control: TCustomTabControl;
      TabIndex: Integer; const Rect: TRect; Active: Boolean);
    procedure CloseTabToolButtonClick(Sender: TObject);
    procedure TopicTabControlMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure FavoriteToolButtonClick(Sender: TObject);
    procedure PatrolToolButtonClick(Sender: TObject);
    procedure BoardNameLabelClick(Sender: TObject);
    procedure AutoReloadMenuItemClick(Sender: TObject);
    procedure SearchToolButtonClick(Sender: TObject);
    procedure StopToolButtonClick(Sender: TObject);
    procedure TopicListViewColumnClick(Sender: TObject;
      Column: TListColumn);
    procedure MakeTopicToolButtonClick(Sender: TObject);
    procedure TopicTabControlResize(Sender: TObject);
    procedure OptionMenuItemClick(Sender: TObject);
    procedure TopicListViewDrawSubItem(Control: TWinControl;
      var ACanvas: TCanvas; Index, SubItem: Integer; ARect: TRect;
      State: TOwnerDrawState; var DefaultDrawing: Boolean);
    procedure TopicListViewDrawItem(Control: TWinControl;
      var ACanvas: TCanvas; Index: Integer; ARect: TRect;
      State: TOwnerDrawState; var DefaultDrawing, FullRowSelect: Boolean);
    procedure TrashToolButtonClick(Sender: TObject);
    procedure ViewLimitChangeClick(Sender: TObject);
    procedure TopicListViewCustomDrawItem(Sender: TCustomListView;
      Item: TListItem; State: TCustomDrawState; var DefaultDraw: Boolean);
    procedure UpdateBoardListMenuItemClick(Sender: TObject);
    procedure UrlEditKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure CopyUrlMenuItemClick(Sender: TObject);
    procedure CopyTitleUrlMenuItemClick(Sender: TObject);
    procedure OpenByBrowserMenuItemClick(Sender: TObject);
    procedure RepaintTabTimerTimer(Sender: TObject);
    procedure RepaintListViewTimerTimer(Sender: TObject);
    procedure DownloadAllTopicToolButtonClick(Sender: TObject);
    procedure RegisterBoardButtonMenuItemClick(Sender: TObject);
    procedure CopyBoardUrlMenuButtonClick(Sender: TObject);
    procedure OpenBoardByBrowserMenuItemClick(Sender: TObject);
    procedure TopicTabControlMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure LoginMenuItemClick(Sender: TObject);
    procedure ResAtMenuItemClick(Sender: TObject);
    procedure BoardListBoxMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure BoardDeleteMenuItemClick(Sender: TObject);
    procedure BoardButtonToolBarMouseUp(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure CloseActiveTabActionExecute(Sender: TObject);
    procedure TabBeforeActionExecute(Sender: TObject);
    procedure TabForwardActionExecute(Sender: TObject);
    procedure ChangeLimitAllActiveTabExecute(Sender: TObject);
    procedure ChangeStyle2ActionExecute(Sender: TObject);
    procedure ChangeStyle1ActionExecute(Sender: TObject);
    procedure ChangeStyle3ActionExecute(Sender: TObject);
    procedure CreateOfflineFolderClick(Sender: TObject);
    procedure FavoritePopupMenuPopup(Sender: TObject);
    procedure FavoriteMenuItemClick(Sender: TObject);
    procedure RemoveOfflineFolderClick(Sender: TObject);
    procedure BoardListBoxMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure TopicTabControlDragOver(Sender, Source: TObject; X,
      Y: Integer; State: TDragState; var Accept: Boolean);
    procedure TopicTabControlDragDrop(Sender, Source: TObject; X,
      Y: Integer);
    procedure BoardListBoxDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure BoardListBoxDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure SetPriorityMenuItemClick(Sender: TObject);
    procedure SetSelectedTopicPriority(Priority: Integer);
    procedure TopicListViewPopupMenuPopup(Sender: TObject);
    procedure TopicPagePopupMenuPopup(Sender: TObject);
    procedure SetPriorityPlusItemMenuClick(Sender: TObject);
    procedure EditBoardButtonMenuItemClick(Sender: TObject);
    procedure OpenAllCategoryActionExecute(Sender: TObject);
    procedure CloseAllCategoryActionExecute(Sender: TObject);
    procedure InputMemoMenuItemClick(Sender: TObject);
    procedure LogSweeperActionExecute(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure GoTrayActionExecute(Sender: TObject);
    procedure TrayIconMouseClick(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure TopicListViewKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure BoardListBoxKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure CopyTitleUrlTopicListClick(Sender: TObject);
    procedure CopyUrlTopicListClick(Sender: TObject);

    procedure IETextSizeMenuItemClick(Sender: TObject);
    procedure Open2chGuideMenuItemClick(Sender: TObject);
    procedure Open2chMenuItemClick(Sender: TObject);
    procedure OpenByBrowserTopicListClick(Sender: TObject);
    procedure OpenKatju88SiteMenuItemClick(Sender: TObject);
    procedure OpenSupportBoardMenuItemClick(Sender: TObject);
    procedure SendMailMenuItemClick(Sender: TObject);
    procedure TrashMenuItemClick(Sender: TObject);
    procedure GoToToolButtonClick(Sender: TObject);
    procedure UrlEditChange(Sender: TObject);
    procedure AddressToolBarResize(Sender: TObject);
    procedure N1Click(Sender: TObject);
    procedure URL3Click(Sender: TObject);
    procedure BoardButtonMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure BoardButtonClick(Sender: TObject);
    procedure ReceiveActiveTabActionExecute(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure TopicListViewData(Sender: TObject; Item: TListItem);
    procedure LogSaveModeToolButtonClick(Sender: TObject);
    procedure SaveTopicToolButtonClick(Sender: TObject);
    procedure TopPanelClick(Sender: TObject);
    procedure AboneMenuItemClick(Sender: TObject);
  private
    FActive: boolean;
    FSelectButton: string;
    FSelectMessageNo: integer;
    FOldtab: TTopicBrowser;
    FWriteForm: TWriteForm;
    FSelectedBoard: TBoard;
    FBrowserList: TObjectList;
    FBoardListBoxItems: TObjectList;
    FBoardButtonList: TStringList;
    FBoardButtonMenuList: TObjectList;
    FTopicListSortOrder: boolean;
    FTopicListSortIndex: integer;
    FMouseControl: TControl;
    FImageList: TImageList;
    FListItemToClear: TObjectList;
    FTopicList: TList;
    FBoardList: TBoardList;
    FForceToOpenBoard: boolean;
    procedure CoolBarRestore;
    procedure DeleteTopic(Topic: TTopic);
    procedure OpenBoard(Board: TBoard);
    function OpenTab(topic: TTopic; newtab: Boolean): TTopicBrowser;
    procedure CloseTab(Index: integer);
    procedure ChangeTab();
    function  GetActiveTab: TTopicBrowser;
    procedure OpenUrl(Sender: TObject; Url: string);
    function  CreateTopicBrowser: TTopicBrowser;
    procedure RefreshBoardListBox;
    procedure TopicBrowser_NavigateUrl(Sender: TObject; URL: string);
    procedure TopicBrowser_ChangeDownloadState(Sender: TObject);
    procedure TopicBrowser_Complete(Sender: TObject);
    procedure Board_TopicListReceived(Sender: TObject);
    procedure Board_StatusChange(axSender: TObject;
                                 const axStatus: TIdStatus;
                                 const asStatusText: string);
    procedure Board_Error(Sender: TObject;
                          const ErrorCode: TFrameworkErrorType;
                          const ErrorString: string);
    procedure Board_Complete(Sender: TObject);
    procedure OpenBrowser(URL : string);
    procedure CreateBoardButton();
    procedure SaveBoardButton;
    function  GetTabIndexAtPoint(Point : TPoint) : Integer;
    function  GetTabAtPoint(Point : TPoint) : TTopicBrowser;
    procedure FormIdle(Sender: TObject; var Done: Boolean);
    procedure OpenSelectedTopic;
    procedure BoardListViewSetVisible(const Visible, IsNormalMode : boolean);
    procedure TopicListViewSetVisible(const Visible, IsNormalMode : boolean);
    procedure BrowserPanelSetVisible(const Visible, IsNormalMode : boolean);
    procedure Spliter2SetVisible(const Visible, IsNormalMode : boolean);
    procedure ChangeTopicListViewColumnPadding;
    procedure ReloadOpenedTopic;
    procedure TopicListRefresh;
  public
    { Public 錾 }
  end;
var
  MainForm: TMainForm;

implementation

uses
  RegExpr, IdHTTP, Commctrl,
  ShellAPI, Clipbrd, StrUtils, Math, mmsystem, ShDocVw_TLB,
  untConfig, untLogSweeper, untLogSweeperForm,
  untSearchForm, untUpdateBoardForm, untLoginForm,
  unt2chUrlParser, untTopicBrowserIE, untTopicBrowserDoe,
  untCreateOfflineFolder, untHintWindow,
  untEditBoardButttonForm, untImageListTool, untOptionForm, untOnlineBoard,
  untAllSubscribedTopics, untOfflineBoard, untBoard2ch, untLostBoard;

{$R *.dfm}

function GetTopicStateNumber(Topic: TTopic): Integer;
begin
  if Topic.State = dsNone  then
  begin
    if Topic.IsFavorite then
    begin
      Result := 1
    end else if Topic.IsFreezed then
    begin
      Result := 3
    end else if Topic.IsError then
    begin
      Result := 2
    end else if (Topic.DatSize > 0) and
                (Topic.MessageCount > Topic.GotMessageCount) then
    begin
      Result := 5
    end else if (Topic.DatSize > 0) and
                (Topic.GotMessageCount > 0) then
    begin
      Result := 4
    end else
    begin
      Result := -1;
    end;
  end else begin
    Result := 0
  end;
end;

function TopicListSortCompare(Item1, Item2: Pointer): Integer;
var
  compare: integer;
  topic1, Topic2: TTopic;
  noChange: boolean;

begin
  topic1 := Item1;
  topic2 := Item2;
  noChange := false;
  compare  := 0;

  case MainForm.FTopicListSortIndex of
    0:
      Compare := CompareValue(GetTopicStateNumber(Topic1),
                              GetTopicStateNumber(Topic2));
    1:
      Compare := CompareValue(Topic1.Priority,
                              Topic2.Priority);
    2:
      Compare := CompareValue(Topic1.Index,
                              Topic2.Index);
    3:
      Compare := AnsiCompareStr(Topic1.Title,
                                Topic2.Title);
    4:
      Compare := CompareValue(Topic1.MessageCount,
                              Topic2.MessageCount);
    5:
      Compare := CompareValue(Topic1.GotMessageCount,
                              Topic2.GotMessageCount);
    6:
      Compare := CompareValue(Topic1.NewMessageCount,
                              Topic2.NewMessageCount);
    7:
      Compare := AnsiCompareStr(Topic1.LastReadDate,
                                Topic2.LastReadDate);
    8:
      Compare := AnsiCompareStr(Topic1.LastWriteDate,
                                Topic2.LastWriteDate);
    9:
      Compare := AnsiCompareStr((Topic1.OnlineBoard as TBoard).DisplayName,
                                (Topic2.OnlineBoard as TBoard).DisplayName);
    else
      noChange := true;
  end;

  if MainForm.FTopicListSortOrder then
  begin
    compare := -compare;
  end;

  if noChange then
  begin
    compare := CompareValue(topic1.Index, topic2.Index);
  end;
  result := compare;
end;

procedure TMainForm.TopicListRefresh;
var
  i: integer;
  item: TListItem;

begin
  TopicListView.Items.BeginUpdate;
  TopicListView.Items.Clear;
  FListItemToClear.Clear;
  for i := 0 to FTopicList.Count - 1 do
  begin
    item := TopicListView.Items.Add;
    FListItemToClear.Add(item);
  end;
  TopicListView.Items.EndUpdate;
end;

procedure TMainForm.Board_Error(Sender: TObject;
                                const ErrorCode: TFrameworkErrorType;
                                const ErrorString: string);
begin
  MainStatusBar.SimpleText := ErrorString;
end;

procedure TMainForm.Board_StatusChange(axSender: TObject;
                                       const axStatus: TIdStatus;
                                       const asStatusText: string);
begin
  MainStatusBar.SimpleText := asStatusText;
end;

procedure TMainForm.Board_Complete(Sender: TObject);
begin
  if Sender is TOnlineBoard then
  begin
    MainStatusBar.SimpleText := (Sender as TOnlineBoard).StatusText;
  end;
  if Animate1.FileName <> '' then
  begin
    Animate1.Active := false;
  end;
end;

// gsbNM
procedure TMainForm.Board_TopicListReceived(Sender: TObject);
var
  i: integer;
  item: TListItem;

begin
  if Application.Terminated then
  begin
    exit;
  end;

  TopicListView.Items.BeginUpdate;

  FTopicList.Capacity := FSelectedBoard.TopicList.Count;
  for i := FSelectedBoard.ReceivedIndex to FSelectedBoard.TopicList.Count -1 do
  begin
    FTopicList.Add(FSelectedBoard.TopicList[i]);
    item := TopicListView.Items.Add;
    FListItemToClear.Add(item);
  end;
  TopicListView.Items.EndUpdate;
  // ܂ɍĕ`悵Ă݂
  TopicListView.DoubleBuffered := true;
  TopicListView.Repaint;
  TopicListView.DoubleBuffered := false;
end;

{ --------------------------------------------------------
  pr  : {[hJ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TMainForm.OpenBoard(Board: TBoard);
var
  subjectFile: string;
  fileStream: TFileStream;
  modifiedTime: TDateTime;
  doClear, hasChange: boolean;
  i, j: integer;
  category: TBoardCategory;

begin
  if not Assigned(Board) then
  begin
    exit;
  end;

  doClear := true;
  hasChange := true;

  if Assigned(FSelectedBoard) then
  begin
    if FSelectedBoard is TAllSubscribedTopics then
    begin
      (FSelectedBoard as TAllSubscribedTopics).Stop;
    end;

    if FSelectedBoard is TOfflineBoard then
    begin
      (FSelectedBoard as TOfflineBoard).Save;
    end else if FSelectedBoard is TOnlineBoard then
    begin
      (FSelectedBoard as TOnlineBoard).CancelDownload;    
    end;

    if FSelectedBoard = Board then
    begin
       if FSelectedBoard.IsDownloading then
       begin
          doClear := false;
       end;
       if Board is TBoard2ch and not FForceToOpenBoard then
       begin
          hasChange := (Board as TBoard2ch).HasTopicListChange;
          if not hasChange then
          begin
            doClear := false;
          end;
       end;
    end;

    if doClear then
    begin
      TopicListView.Items.Clear;
      FTopicList.Clear;
      TopicListView.DoubleBuffered := true;
      TopicListView.Repaint;
      TopicListView.DoubleBuffered := false;
      FListItemToClear.Clear;
      FSelectedBoard.FreeAllTopic;
      FBoardList.GC;
    end;

    FSelectedBoard.OnReceived := nil;
  end;

  FSelectedBoard := Board;
  FSelectedBoard.OnReceived := Board_TopicListReceived;
  FSelectedBoard.OnError    := Board_Error;
  FSelectedBoard.OnComplete := Board_Complete;
  if FSelectedBoard is TOnlineBoard then
  begin
    (FSelectedBoard as TOnlineBoard).OnStateChange := Board_StatusChange;
  end;

  // VXmp
  if gConfig.TopicListColorUse and (FSelectedBoard is TOnlineBoard) then
  begin
    if not gFolderAlias.GetFolderPath((FSelectedBoard as TOnlineBoard).Server,
                                      (FSelectedBoard as TOnlineBoard).BoardName,
                                      'subjects',
                                      subjectFile) then
    begin
      subjectFile := subjectFile + 'subjects';
    end;

    if FileExists(subjectFile) then
    begin
      fileStream := TFileStream.Create(subjectFile, fmOpenRead or fmShareDenyNone);
      modifiedTime := FileDateToDateTime(FileGetDate(FileStream.Handle));
      fileStream.Free;
      // datetime2unixtime
      // 32400 = 60 * 60 * 9 => JST=GMT+9  T[oɂĈႤ
      (FSelectedBoard as TOnlineBoard).ModTime := Trunc((modifiedTime - EncodeDate(1970, 1, 1)) * 86400) - 32400;
    end;
  end;

  if hasChange or FForceToOpenBoard then
  begin
    if Animate1.FileName <> '' then
    begin
      Animate1.Active := true;
    end;
    FForceToOpenBoard := false;
    FSelectedBoard.SendTopicList;
  end else
  begin
    TopicListView.Items.Clear;
    Application.ProcessMessages;
    TopicListRefresh;
  end;

  // ^Cgo[ύX
  self.Caption := 'Version ' + GetVersionStr +
                  ' [ ' + FSelectedBoard.DisplayName + ' ]';

  // {[hXg{bNX̑IύX
  for i := 0 to FBoardList.Categorys.Count - 1 do
  begin
    category := TBoardCategory(FBoardList.Categorys[i]);
    for j := 0 to category.Boards.Count - 1 do
    begin
      if category.Boards[j] = FSelectedBoard then
      begin
        if category.Opened = false then
        begin
          if gConfig.BoardListOneCategory then
          begin
            CloseAllCategoryActionExecute(nil);
          end;
          category.Opened := true;
          RefreshBoardListBox;
        end;
        break;
      end;
    end;
  end;
  for i := 0 to BoardListBox.Count - 1 do
  begin
    if (FBoardListBoxItems[i] as TBoardListBoxItem).Board = FSelectedBoard then
    begin
      BoardListBox.Selected[i] := true;
      break;
    end;
  end;

  if FSelectedBoard is TOnlineBoard then
  begin
    UrlEdit.Text := (FSelectedBoard as TOnlineBoard).BoardUrl;
  end;
end;

procedure TMainForm.TopicListViewData(Sender: TObject; Item: TListItem);
var
  topic: TTopic;
  gotMsg, newMsg: string;

begin
  if (Item.Index < 0) or
     (Item.Index > (FTopicList.Count - 1)) then
  begin
    exit;
  end;

  topic := TTopic(FTopicList[Item.Index]);

  if not Assigned(topic) then
  begin
    exit;
  end;

  gotMsg := IntToStr(topic.GotMessageCount);
  if topic.GotMessageCount <= 0 then
  begin
    gotMsg := '';
  end;

  newMsg := IntToStr(topic.NewMessageCount);
  if (topic.NewMessageCount <= 0) then
  begin
    newMsg := '';
  end;

  Item.Caption  := '';
  if topic.Priority < 0 then
  begin
    Item.SubItems.Add(IntToStr(topic.Priority))
  end else if topic.Priority > 0 then
  begin
    Item.SubItems.Add('+' + IntToStr(topic.Priority))
  end else
  begin
    Item.SubItems.Add('');
  end;
  Item.SubItems.Add(IntToStr(topic.Index));

  Item.SubItems.Add(topic.Title);
  Item.SubItems.Add(IntToStr(topic.MessageCount));
  Item.SubItems.Add(gotMsg);
  Item.SubItems.Add(newMsg);
  Item.SubItems.Add(topic.LastReadDate);
  Item.SubItems.Add(topic.LastWriteDate);

  if topic.OnlineBoard <> nil then
  begin
    Item.SubItems.Add((topic.OnlineBoard as TBoard).DisplayName)
  end else
  begin
    Item.SubItems.Add('');
  end;

  Item.SubItems.Add(topic.Memo);

  // ACR
  Item.ImageIndex := GetTopicStateNumber(topic);
end;

procedure TMainForm.BoardButtonToolBarMouseUp(Sender: TObject;
                                              Button: TMouseButton;
                                              Shift: TShiftState;
                                              X, Y: Integer);
begin
  if Button = mbLeft then
  begin
    BoardButtonClick(sender);
  end else if Button = mbRight then
  begin
    if Sender is TToolButton then
    begin
      FSelectButton := TToolButton(Sender).Caption;
      BoardButtonPopupMenu.Popup(Mouse.CursorPos.X, Mouse.CursorPos.Y);
    end else if Sender is TToolBar then
    begin
      BoardButtonToolBarPopupMenu.Popup(Mouse.CursorPos.X, Mouse.CursorPos.Y);
    end;
  end;

  if sender is TToolButton then
  begin
    TToolButton(sender).Down := false;
  end;
end;

procedure TMainForm.BoardButtonMouseDown(Sender: TObject;
                                         Button: TMouseButton;
                                         Shift: TShiftState;
                                         X, Y: Integer);
begin
  if sender is TToolButton then
  begin
    TToolButton(sender).Down := true;
  end;
end;

procedure TMainForm.BoardButtonClick(Sender: TObject);
var
  i, j     : integer;
  caption  : string;
  category : TBoardCategory;

begin
  if sender is TMenuItem then
  begin
    caption := TMenuItem(Sender).Caption
  end else if sender is TToolButton then
  begin
    caption := TToolButton(sender).Caption;
  end;

  for i := 0 to FBoardList.Categorys.Count - 1 do
  begin
    category := TBoardCategory(FBoardList.Categorys[i]);
    for j := 0 to category.Boards.Count - 1 do
    begin
      if TBoard(category.Boards[j]).DisplayName = caption then
      begin
        OpenBoard(TBoard(category.Boards[j]));
        exit;
      end;
    end;
  end;
end;

procedure TMainForm.CreateOfflineFolderClick(Sender: TObject);
var
  createForm: TCreateOfflineFolderForm;
  cancel: boolean;
  folderName, folderPath: string;
  board: TStringList;

begin
  createForm := TCreateOfflineFolderForm.Create(self);
  createForm.ShowModal;
  cancel     := createForm.Cancel;
  folderName := createForm.FolderName;
  createForm.Release;
  createForm.Free;

  if cancel then
  begin
    exit;
  end;

  folderPath := AppPath(folderName + '.idx');

  if AnsiCompareStr(folderName, '') = 0 then
  begin
    exit;
  end;

  if FileExists(folderPath) then
  begin
    ShowMessage('ɓ̑qɂ܂');
    exit;
  end;

  if LastDelimiter('\/:,;*"<>|', folderName) > 0 then
  begin
    ShowMessage('\/:,;*"<>| ͎̕g܂');
    exit;
  end;

  // {[ht@C̍쐬
  board := TStringList.Create;
  board.SaveToFile(folderpath);
  board.Free;
  FBoardList.MyFolder.AddBoard(folderPath, '}CtH_', folderName);

  RefreshBoardListBox;
end;

procedure TMainForm.RegisterBoardButtonMenuItemClick(Sender: TObject);
var
  index     : Integer;
  item      : TBoardListBoxItem;
  itemind   : integer;
  boardname : string;

begin
  index := BoardListBox.ItemIndex;
  if (index < 0) or (index >= FBoardListBoxItems.Count) then
  begin
    exit;
  end;

  item := TBoardListBoxItem(FBoardListBoxItems[index]);
  if item.Board <> nil then
  begin
    boardname := TBoard(item.Board).DisplayName
  end else
  begin
    boardname := '' + item.Category.CategoryName;
  end;

  // o^ĂȂΓo^
  itemind := FBoardButtonList.IndexOf(boardname);
  if itemind = -1 then
  begin
    FBoardButtonList.Add(boardname);
  end else
  begin
    FBoardButtonList.Delete(itemind);
  end;

  CreateBoardButton;
  SaveBoardButton;
end;

// {^̃JX^}CY
procedure TMainForm.BoardDeleteMenuItemClick(Sender: TObject);
var
  itemind : integer;
begin

  // o^Ă΍폜
  itemind := FBoardButtonList.IndexOf(FSelectButton);
  if itemind > -1 then
  begin
    FBoardButtonList.Delete(itemind);
  end;

  CreateBoardButton;
  SaveBoardButton;
end;

// {^\z
procedure TMainForm.CreateBoardButton;
var
  i, j: integer;
  button: TToolButton;
  newMenu: TPopupMenu;
  newMenuItem: TMenuItem;
  categoryMenu: TMenuItem;
  category: TBoardCategory;
begin

  FBoardButtonMenuList.Clear;

  // remove
  for i := 0 to BoardButtonToolBar.ButtonCount - 1 do
  begin
    button := BoardButtonToolBar.Buttons[0];
    BoardButtonToolBar.RemoveControl(button);
    button.Free;
  end;

  //
  for i := FBoardButtonList.Count - 1 downto 0 do
  begin
    button := TToolButton.Create(BoardButtonToolBar);
    button.AutoSize  := true;
    button.Parent    := BoardButtonToolBar;
    button.Caption   := FBoardButtonList[i];
    button.Style     := tbsButton;
    button.OnMouseUp := BoardButtonToolBarMouseUp;

    newMenu := TPopupMenu.Create(BoardButtonToolBar);
    newMenu.AutoHotkeys := maManual;
    button.DropdownMenu := newMenu;
    FBoardButtonMenuList.Add(newMenu);

    if Copy(FBoardButtonList[i], 1, 2) = '' then
    begin
      category := nil;
      for j := 0 to  FBoardList.Categorys.Count - 1 do
      begin
        category := TBoardCategory(FBoardList.Categorys[j]);
        if CopyAfter(FBoardButtonList[i], 3) = category.CategoryName then
          break;
        category := nil;
      end;

      if category <> nil then
        for J := 0 to category.Boards.Count - 1 do
        begin
          newMenuItem := TMenuItem.Create(newMenu);
          newMenuItem.Caption := TBoard(category.Boards[J]).DisplayName;
          newMenuItem.AutoHotkeys := maManual;
          newMenuItem.OnClick := BoardButtonClick;
          newMenu.Items.Add(newMenuItem);
          FBoardButtonMenuList.Add(newMenuItem);
        end;
    end else
    begin
      button.OnMouseDown := BoardButtonMouseDown;
    end;
  end;

  // Q˂
  button := TToolButton.Create(BoardButtonToolBar);
  button.AutoSize := true;
  button.Parent   := BoardButtonToolBar;
  button.Caption  := 'Q˂';

  newMenu := TPopupMenu.Create(BoardButtonToolBar);
  newMenu.AutoHotkeys := maManual;
  button.DropdownMenu := newMenu;
  FBoardButtonMenuList.Add(newMenu);

  for i := 0 to  FBoardList.Categorys.Count - 1 do
  begin
    category := TBoardCategory(FBoardList.Categorys[i]);
    categoryMenu := TMenuItem.Create(newMenu);
    categoryMenu.Caption := category.CategoryName;
    newmenu.Items.Add(categoryMenu);
    FBoardButtonMenuList.Add(categoryMenu);

    for j := 0 to category.Boards.Count - 1 do
    begin
      newMenuItem := TMenuItem.Create(categoryMenu);
      newMenuItem.Caption := TBoard(category.Boards[J]).DisplayName;
      newMenuItem.OnClick := BoardButtonClick;
      categoryMenu.Add(newMenuItem);
      FBoardButtonMenuList.Add(newMenuItem);
    end;
  end;
end;

{ --------------------------------------------------------
  pr  : ^uύXꂽ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TMainForm.ChangeTab;
var
  activeTab: TTopicBrowser;
  i: integer;
  board: TOnlineBoard;

begin
  activeTab := GetActiveTab();
  if activeTab = nil then
  begin
    exit;
  end;

  FOldtab := activeTab;

  if activeTab.Topic <> nil then
  begin
    board := (ActiveTab.Topic.OnlineBoard as TOnlineBoard);
    BoardNameLabel.Caption   := '[' + board.DisplayName + ']';
    TopicNameLabel.Left      := BoardNameLabel.Left + BoardNameLabel.Width + 5;
    activeTab.Caption        := activeTab.Topic.Title;
    TopicNameLabel.Caption   := activeTab.Topic.Title;
    MainStatusBar.SimpleText := activeTab.Topic.StatusText;

    if ActiveTab.Topic.IsFavorite then
    begin
      FavoriteToolButton.ImageIndex := 18;
    end else
    begin
      FavoriteToolButton.ImageIndex := 19;
    end;

    AutoReloadMenuItem.Checked := ActiveTab.AutoReload;
    UrlEdit.Text := ActiveTab.Topic.BrowserUrl;
  end else
  begin
    BoardNameLabel.Caption := '';
    TopicNameLabel.Caption := '';
    //MainStatusBar.SimpleText := '';
  end;

  activeTab.Visible := true;
  for i := 0 to FBrowserList.Count - 1 do
  begin
    if FBrowserList[i] <> ActiveTab then
    begin
      TTopicBrowser(FBrowserList[I]).Visible := false;
    end;
  end;

  // ^uĕ`
  RepaintTabTimer.Enabled := true;
end;

procedure TMainForm.FormCreate(Sender: TObject);
var
  items: TStringArray;
  i: integer;
  activeTab: TTopicBrowser;
  item: TBoardListBoxItem;

begin
  // ꉞĂ݂ǕʂɕςȂ悤
  TimeBeginPeriod(1);

  FBoardListBoxItems := TObjectList.Create;
  FListItemToClear := TObjectList.Create;
  FTopicList := TList.Create;
  FBrowserList := TObjectList.Create;
  FBoardButtonMenuList := TObjectList.Create;
  FBoardButtonList := TStringList.Create;

  Application.OnIdle := FormIdle;

  if FileExists(AppPath('anime.avi')) then
  begin
    Animate1.FileName := AppPath('anime.avi');
  end;

  // Style
  if gConfig.MainFormStyleType3 then
  begin
    StyleToolButton.ImageIndex := 3
  end else
  begin
    StyleToolButton.ImageIndex := 7;
  end;

  if gConfig.DoLogSave then
  begin
    LogSaveModeToolButton.Down := true;
    SaveTopicToolButton.Visible := false;
  end else
  begin
    LogSaveModeToolButton.Down := false;
    SaveTopicToolButton.Visible := true;
  end;

  StyleSub1ToolButton.Down := gConfig.MainFormStyleSub1;
  StyleSub2ToolButton.Down := gConfig.MainFormStyleSub2;
  StyleSub3ToolButton.Down := gConfig.MainFormStyleSub3;

  // BoardList
  BoardListBox.ItemHeight := BoardListBox.Canvas.TextHeight('') + 2;

  TopicTabControl.MultiLine := gConfig.MultiLineTab;

  TopicListView.Font.Size := gConfig.TopicListViewColumnFontSize;
  TopicListView.GridLines := gConfig.TopicListViewGridLines;
  // ݒ蔽f
  StyleChange(nil);

  // TopicListViewColumn
  items := Split(gConfig.TopicListViewColumnOrders, ',');
  if Length(items) >= 11 then
  begin
    for i := 0 to 10 do
    begin
      TopicListView.Columns.FindItemID(StrToIntNeo(items[i])).Index := i;
    end;
  end;

  items := Split(gConfig.TopicListViewColumnWidths, ',');
  if Length(items) >= 11 then
  begin
    for i := 0 to 10 do
    begin
      TopicListView.Column[i].Width := StrToIntNeo(items[i]);
    end;
  end;

  // {[hXgXV
  FBoardList := TBoardList.Create;
  FBoardList.Init;
  RefreshBoardListBox;

  // uEUЂƂJĂ
  activeTab := CreateTopicBrowser();
  activeTab.Visible := true;

  // ݃tH[
  FWriteForm := TWriteForm.Create(self);
  // [hp\bhݒ
  FWriteForm.ReloadTopic := ReceiveActiveTabActionExecute;

  // {^̍쐬
  if FileExists(AppPath('favboard.idx')) then
  begin
    FBoardButtonList.LoadFromFile(AppPath('favboard.idx'));
  end;
  CreateBoardButton();

  ChangeTopicListViewColumnPadding;

  // CɓJ
  item := TBoardListBoxItem(FBoardListBoxItems[1]);
  if item.Board <> nil then
  begin
    OpenBoard(item.Board)
  end;

  // R}hCURLnꂽJ
  if ParamCount > 0 then
  begin
    OpenUrl(self, ParamStr(1));
  end;

  // Form size
  CoolBarRestore;
  self.Height := gConfig.MainFormHeight;
  self.Width  := gConfig.MainFormWidth;
  self.Top    := gConfig.MainFormTop;
  self.Left   := gConfig.MainFormLeft;
  self.Show;
  self.WindowState := TWindowState(gConfig.MainFormWindowState);
  self.Repaint;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
var
  i: Integer;
  column: TListColumn;
  band: TCoolBand;

begin
  FWriteForm.Free;
  FBrowserList.Free;

  FBoardListBoxItems.Free;
  // Style
  gConfig.MainFormStyleType3 := (StyleToolButton.ImageIndex = 3);
  gConfig.MainFormStyleSub1  := StyleSub1ToolButton.Down;
  gConfig.MainFormStyleSub2  := StyleSub2ToolButton.Down;
  gConfig.MainFormStyleSub3  := StyleSub3ToolButton.Down;

  if LeftPanel.Visible then
  begin
    gConfig.BoardListBoxWidth := LeftPanel.Width;
  end;
  if (StyleToolButton.ImageIndex = 7) then
  begin
    if BrowserPanel.Visible then
    begin
      gConfig.TopicListViewHeight := TopicListView.Height;
    end;
  end else
  begin
    if BrowserPanel.Visible then
    begin
      gConfig.TopicListViewWidth := TopicListView.Width;
    end;
  end;

  // Form size
  if self.WindowState = wsMinimized then
  begin
    gConfig.MainFormWindowState := Integer(wsNormal)
  end else
  begin
    gConfig.MainFormWindowState := Integer(self.WindowState);
  end;

  if self.WindowState = wsNormal then
  begin
    gConfig.MainFormHeight := self.Height;
    gConfig.MainFormWidth  := self.Width;
    gConfig.MainFormTop    := self.Top;
    gConfig.MainFormLeft   := self.Left;
  end;

  // TopicListView column position
  gConfig.TopicListViewColumnOrders := '';
  gConfig.TopicListViewColumnWidths := '';
  for i := 0 to TopicListView.Columns.Count - 1 do
  begin
    column := TopicListView.Columns[i];
    gConfig.TopicListViewColumnOrders := gConfig.TopicListViewColumnOrders +
                                         IntToStr(column.Tag) + ',';
    gConfig.TopicListViewColumnWidths := gConfig.TopicListViewColumnWidths +
                                         IntToStr(column.Width) + ',';
  end;

  gConfig.CoolBarBandId    := '';
  gConfig.CoolBarBandWidth := '';
  gConfig.CoolBarBandBreak := '';
  for i := 0 to CoolBar.Bands.Count -1 do
  begin
    band := CoolBar.Bands[i];
    gConfig.CoolBarBandId    := gConfig.CoolBarBandId    + IntToStr(band.ID) + ', ' ;
    gConfig.CoolBarBandWidth := gConfig.CoolBarBandWidth + IntToStr(band.Width) + ', ';
    if band.Break = true then
    begin
      gConfig.CoolBarBandBreak := gConfig.CoolBarBandBreak + 'TRUE, '
    end else
    begin
      gConfig.CoolBarBandBreak := gConfig.CoolBarBandBreak + 'FALSE, ';
    end;
  end;

  FImageList.Free;
  FBoardButtonMenuList.Free;
  FBoardButtonList.Free;
  FTopicList.Free;
  FListItemToClear.Free;
  FBoardList.Free;

  TimeEndPeriod(1);
end;

// \X^CύX
procedure TMainForm.StyleChange(Sender: TObject);
var
  IsNormalMode : Boolean;
begin

  IsNormalMode := (StyleToolButton.ImageIndex = 7);

  // yCX^C̕ύX
  if Sender = StyleToolButton then 
  begin
    if IsNormalMode then 
    begin
      StyleToolButton.ImageIndex     := 3; 
      StyleToolButton.Hint           := 'cRʍ\ɕύX'; 
      StyleSub1ToolButton.ImageIndex := 4; 
      StyleSub2ToolButton.ImageIndex := 5; 
      StyleSub3ToolButton.ImageIndex := 6; 
      gConfig.MainFormStyleType3            := True;
    end else
    begin
      StyleToolButton.ImageIndex     := 7;
      StyleToolButton.Hint           := 'ʏʍ\ɕύX';
      StyleSub1ToolButton.ImageIndex := 8; 
      StyleSub2ToolButton.ImageIndex := 9; 
      StyleSub3ToolButton.ImageIndex := 10; 
      gConfig.MainFormStyleType3            := False; 
    end; 
    IsNormalMode := (StyleToolButton.ImageIndex = 7); 
  end; 


  if StyleSub2ToolButton.Down and StyleSub3ToolButton.Down then
  begin
    if(Sender = StyleSub2ToolButton) then
    begin
      StyleSub3ToolButton.Down := false
    end else
    begin
      StyleSub2ToolButton.Down := false;
    end;
  end;

  if StyleSub1ToolButton.Down then
  begin
    BoardListViewSetVisible(False, IsNormalMode);
  end else
  begin
    BoardListViewSetVisible(True, IsNormalMode);
  end;

  if not StyleSub2ToolButton.Down and not StyleSub3ToolButton.Down then
  begin
    TopicListViewSetVisible(True, IsNormalMode);
    Spliter2SetVisible(True, IsNormalMode);
    BrowserPanelSetVisible(True, IsNormalMode);
  end else
  if StyleSub2ToolButton.Down then
  begin
    TopicListViewSetVisible(True, IsNormalMode);
    Spliter2SetVisible(False, IsNormalMode);
    BrowserPanelSetVisible(False, IsNormalMode);
  end else // StyleSub3ToolButton.Down
  begin
    TopicListViewSetVisible(False, IsNormalMode);
    Spliter2SetVisible(False, IsNormalMode);
    BrowserPanelSetVisible(True, IsNormalMode); 
  end; 
end;

// ꗗ`
procedure TMainForm.BoardListBoxDrawItem(Control: TWinControl;
                                         Index: Integer;
                                         Rect: TRect;
                                         State: TOwnerDrawState);
var
  ColorRect: TRect;
  DefaultBrush: TColor;
  item: TBoardListBoxItem;

begin
  if (index < 0) or (index >= FBoardListBoxItems.Count) then
  begin
    exit;
  end;

  item := TBoardListBoxItem(FBoardListBoxItems[Index]);

  // FÂ
  if gConfig.BoardListNoColor = false then
  begin
    ColorRect.Left   := Rect.Left;
    ColorRect.Top    := Rect.Top;
    ColorRect.Bottom := Rect.Bottom;
    ColorRect.Right  := Rect.Left + 4;
    DefaultBrush := TListBox(Control).Canvas.Brush.Color;
    TListBox(Control).Canvas.Brush.Color := item.Category.Color;
    TListBox(Control).Canvas.Brush.Style := bsSolid;
    TListBox(Control).Canvas.FillRect(ColorRect);
    TListBox(Control).Canvas.Brush.Color := DefaultBrush;
  end;

  Rect.Left := Rect.Left + 4;
  TListBox(Control).Canvas.TextRect(Rect, Rect.Left + 1, Rect.Top + 1, item.ViewString);

  Rect.Left := Rect.Left - 4;
  if odFocused in State then
  begin
    TListBox(Control).Canvas.DrawFocusRect(Rect);
  end;
end;

// ^u`
procedure TMainForm.TopicTabControlDrawTab(Control: TCustomTabControl;
  TabIndex: Integer; const Rect: TRect; Active: Boolean);
var
  Browser  : TTopicBrowser;
  X        : Integer;
  DrawRect  : TRect;
begin

  if (TabIndex >= 0) and (TabIndex < TopicTabControl.Tabs.Count) then
  begin
    Browser := TTopicBrowser(FBrowserList[TabIndex]);

    // 
    Control.Canvas.FillRect(Rect);

    // ACR̕`
    if(Browser.ImageIndex > -1) and
      (Browser.ImageIndex < TopicTabControl.Images.Count) then
    begin
      TopicTabControl.Images.Draw(Control.Canvas,
                                  Rect.Left + 3,
                                  Rect.Top + 3,
                                  Browser.ImageIndex);

      X := Rect.Left + 20;
    end else
    begin
      X := Rect.Left + 5;
    end;

    if not Active then
    begin
      Control.Canvas.Font.Color := clBtnShadow
    end else
    begin
      Control.Canvas.Font.Color := clWindowText;
    end;
    DrawRect.Top    := Rect.Top + 2;
    DrawRect.Left   := X;
    DrawRect.Bottom := Rect.Bottom - 1;
    DrawRect.Right  := Rect.Right  - 1;
    Control.Canvas.TextRect(DrawRect, X, Rect.Top + 5, Browser.Caption);
  end;

end;

procedure TMainForm.BoardListBoxData(Control: TWinControl;
                                     Index: Integer;
                                     var Data: String);
var
  item: TBoardListBoxItem;

begin
  if (index >= 0) and (index < FBoardListBoxItems.Count) then
  begin
    item := TBoardListBoxItem(FBoardListBoxItems[Index]);
    Data := item.ViewString;
  end;
end;

// {[hXgClick
procedure TMainForm.BoardListBoxClick(Sender: TObject);
var
  index: Integer;
  item: TBoardListBoxItem;
  isOpened: Boolean;
  i: Integer;
  categoryName: string;

begin
  index := BoardListBox.ItemIndex;

  if (index < 0) or (index >= FBoardListBoxItems.Count) then
  begin
    exit;
  end;

  item := TBoardListBoxItem(FBoardListBoxItems[index]);

  if Assigned(item.Board) then
  begin
    OpenBoard(item.Board)
  end else
  begin
    isOpened := item.Category.Opened;
    if gConfig.BoardListOneCategory then
    begin
      categoryName := Item.Category.CategoryName;
      CloseAllCategoryActionExecute(Sender);
      for i := 0 to FBoardListBoxItems.Count - 1 do
        if TBoardListBoxItem(FBoardListBoxItems[i]).Category.CategoryName = CategoryName then
        begin
          item  := TBoardListBoxItem(FBoardListBoxItems[i]);
          index := i;
        end;
    end;
    item.Category.Opened := not IsOpened;
    BoardListBox.ItemIndex := index;
    RefreshBoardListBox;
  end;
end;

procedure TMainForm.TopicListViewCustomDrawItem(Sender: TCustomListView;
                                                Item: TListItem;
                                                State: TCustomDrawState;
                                                var DefaultDraw: Boolean);
var
  color: TColor;
  imgIndex: Integer;
  topic: TTopic;

begin
  DefaultDraw := true;

  if not gConfig.TopicListColorUse then
  begin
    exit;
  end;
  color := clBlack;

  if Item <> nil then
  begin
    topic := TTopic(FTopicList[Item.Index]);
    imgIndex := Item.ImageIndex;
    // Cɓ
    if imgIndex = 1 then
    begin
      if (topic.DatSize > 0) and (topic.NewMessageCount > 0) then
      begin
        imgIndex := 4;
      end;
    end;

    case imgIndex of
     -1:
        color := gConfig.TopicListNotGotColor;
      1: // Cɓ
        color := gConfig.TopicListFavoriteColor;
      4: // VȂ
        color := gConfig.TopicListNoNewMesColor;
      5: // V
        color := gConfig.TopicListNewMesColor;
    end;
    TopicListView.Canvas.Font.Color := color;
  end;
end;

// gsbNACeIꂽ
procedure TMainForm.TopicListViewMouseUp(Sender: TObject;
                                         Button: TMouseButton;
                                         Shift: TShiftState;
                                         X, Y: Integer);
begin
  if Button = mbLeft then
  begin
    OpenSelectedTopic;
  end;
end;

// ^uύX
procedure TMainForm.TopicTabControlChange(Sender: TObject);
begin
  ChangeTab();
end;

// ^u_uNbNꂽ
procedure TMainForm.TopicTabControlMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin

  if (Button = mbLeft) and (ssDouble in Shift) then
  begin
    ReloadOpenedTopic;
  end else if Button = mbLeft then
  begin
    TopicTabControl.BeginDrag(false, 20);
  end;
end;

procedure TMainForm.TopicTabControlMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Button = mbMiddle then
    CloseTabToolButtonClick(nil);
end;

// xNbN
procedure TMainForm.BoardNameLabelClick(Sender: TObject);
var
  ActiveTab : TTopicBrowser;
begin

  ActiveTab := GetActiveTab();
  if Assigned(ActiveTab) and Assigned(ActiveTab.Topic) then
  begin
    OpenBoard((ActiveTab.Topic.OnlineBoard as TBoard));
  end;
end;

// Xgr[\[g
procedure TMainForm.TopicListViewColumnClick(Sender: TObject;
                                             Column: TListColumn);
begin
  if Column.Index = FTopicListSortIndex then
  begin
    FTopicListSortOrder := not FTopicListSortOrder;
  end else
  begin
    FTopicListSortOrder := true;
    FTopicListSortIndex := Column.id;
  end;
  FTopicList.Sort(TopicListSortCompare);

  // Xbhqɂ̒g̃\[g
  if FSelectedBoard is TOfflineBoard then
  begin
    (FSelectedBoard as TOfflineBoard).Sort(TopicListSortCompare);
  end;
  TopicListView.DoubleBuffered := true;
  TopicListView.Repaint;
  TopicListView.DoubleBuffered := false;  
end;

// OpenURL
procedure TMainForm.UrlEditKeyDown(Sender: TObject;
                                   var Key: Word;
                                   Shift: TShiftState);
begin
  if Key = $0d then
  begin
    OpenUrl(Sender, UrlEdit.Text);
  end;
end;

//  j[Cxg 

// ݒEBhEJ
procedure TMainForm.OptionMenuItemClick(Sender: TObject);
var
  OptionForm  : TOptionForm;
  oldpadding  : integer;
  oldfontsize : integer;
begin

  oldpadding  := gConfig.TopicListViewColumnPadding;
  oldfontsize := gConfig.TopicListViewColumnFontSize;

  OptionForm := TOptionForm.Create(self);
  OptionForm.ShowModal;
  OptionForm.Free;

  if oldpadding <> gConfig.TopicListViewColumnPadding then
    ChangeTopicListViewColumnPadding;

  if oldfontsize <> gConfig.TopicListViewColumnFontSize then
    TopicListView.Font.Size := gConfig.TopicListViewColumnFontSize;

end;

// {[hXg̍XV
procedure TMainForm.UpdateBoardListMenuItemClick(Sender: TObject);
var
  updateBoardForm: TUpdateBoardListForm;

begin
  updateBoardForm := TUpdateBoardListForm.Create(self);
  updateBoardForm.BoardList := FBoardList;
  updateBoardForm.ShowModal;
  updateBoardForm.Free;

  FForceToOpenBoard := true;
  RefreshBoardListBox;
end;

// OC
procedure TMainForm.LoginMenuItemClick(Sender: TObject);
var
  LoginForm : TLoginForm;
begin

  LoginForm := TLoginForm.Create(self);
  LoginForm.ShowModal;
  LoginForm.Release;
  LoginForm.Free;
end;

// open topic with newtab
procedure TMainForm.OpenNewTabMenuItemClick(Sender: TObject);
var
  topic: TTopic;
  item: TListItem;
  isNewTab: Boolean;

begin

  item := TopicListView.Selected;
  if item <> nil then
  begin
    isNewTab := not gConfig.AlwaysNewTab;
    topic := FTopicList[item.Index];
    OpenTab(topic, IsNewTab);
  end;
end;

// I[g[h
procedure TMainForm.AutoReloadMenuItemClick(Sender: TObject);
var
  activeTab : TTopicBrowser;

begin
  AutoReloadMenuItem.Checked := not AutoReloadMenuItem.Checked;

  activeTab := GetTabAtPoint(TopicPagePopupMenu.PopupPoint);
  if activeTab <> nil then
  begin
    if activeTab.Topic <> nil then
    begin
      activeTab.AutoReload := AutoReloadMenuItem.Checked;
    end;
  end;
end;

procedure TMainForm.ViewLimitChangeClick(Sender: TObject);
var
  ActiveTab : TTopicBrowser;
begin

  ActiveTab := GetActiveTab();
  if ActiveTab = nil then
  begin
    exit;
  end;

  if Sender = ViewLimit50MenuItem then
  begin
    ActiveTab.ChangeViewLimit(50);
  end
  else if Sender = ViewLimit100MenuItem then
  begin
   ActiveTab.ChangeViewLimit(100);
  end
  else if Sender = ViewLimit250MenuItem then
  begin
    ActiveTab.ChangeViewLimit(250);
  end
  else if Sender = ViewLimit500MenuItem then
  begin
    ActiveTab.ChangeViewLimit(500);
  end
  else if Sender = ViewLimit1000MenuItem then
  begin
    ActiveTab.ChangeViewLimit(1000);
  end
  else
  begin
    ActiveTab.ChangeViewLimit(0);
  end;
  ChangeTab;
end;

//  c[j[Cxg 

// Jn
procedure TMainForm.PatrolToolButtonClick(Sender: TObject);
begin
  if FSelectedBoard <> FBoardList.MyFolder.FavoriteBoard then
  begin
    OpenBoard(FBoardList.MyFolder.FavoriteBoard);
  end;
  FBoardList.MyFolder.FavoriteBoard.OnComplete := TopicBrowser_ChangeDownloadState;
  FBoardList.MyFolder.FavoriteBoard.Patrol(self);
  RepaintListViewTimer.Enabled := true;
end;

// 
procedure TMainForm.SearchToolButtonClick(Sender: TObject);
var
  i: Integer;
  searchText: string;
  activeTab: TTopicBrowser;
  newTopicList: TList;

begin
  SearchForm.ShowModal;
  searchText := SearchForm.SearchEdit.Text;

  if SearchForm.SearchSelect = srFromTopic then
  begin
    // gsbN̓e猟
    activeTab := GetActiveTab();
    if activeTab <> nil then
    begin
      activeTab.SearchText(searchText);
    end;
  end
  else if SearchForm.SearchSelect = srFromTopicList then
  begin
    newTopicList := TList.Create;
    // gsbNXg猟
    for i := 0 to FTopicList.Count - 1 do
    begin
      if AnsiContainsText(TTopic(FTopicList[i]).Title, searchText) then
      begin
        newTopicList.Add(FTopicList[i]);
      end
    end;
    for i := 0 to FTopicList.Count - 1 do
    begin
      if not AnsiContainsText(TTopic(FTopicList[i]).Title, searchText) then
      begin
        // 
        //newTopicList.Add(FTopicList[i]);
      end;
    end;
    FTopicList.Clear;
    FTopicList.Assign(newTopicList);
    newTopicList.Free;
    TopicListView.Items.Count := FTopicList.Count;
    TopicListRefresh;
    FForceToOpenBoard := true;
  end
  else if SearchForm.SearchSelect = srFromBoardList then
  begin
    // {[hXg猟
    for i := 0 to BoardListBox.Count - 1 do
      if AnsiContainsText(BoardListBox.Items[i], SearchText) then
      begin
        BoardListBox.Selected[I] := true;
        //BoardListBox.ItemIndex := i;
        BoardListBoxClick(BoardListBox);
        break;
      end;
  end;
end;

// gsbN
procedure TMainForm.TopicWriteToolButtonClick(Sender: TObject);
var
  ActiveTab : TTopicBrowser;
begin

  ActiveTab := GetActiveTab();
  if ActiveTab <> nil then
  begin
    if ActiveTab.Topic <> nil then
    begin
      FWriteForm.SetTopic(ActiveTab.Topic);
    end;
  end;
end;

// ɃX
procedure TMainForm.ResAtMenuItemClick(Sender: TObject);
var
  activeTab: TTopicBrowser;

begin
  activeTab := GetActiveTab();
  if Assigned(activeTab) and Assigned(activeTab.Topic) then
  begin
    FWriteForm.SetTopic(activeTab.Topic, FSelectMessageNo);
  end;
end;

// ځ`
procedure TMainForm.AboneMenuItemClick(Sender: TObject);
var
  activeTab: TTopicBrowser;
  tp: TTopic;

begin
  activeTab := GetActiveTab();
  tp := activeTab.Topic;
  if Assigned(activeTab) and Assigned(tp) then
  begin
    tp.Abone(FSelectMessageNo);
    activeTab.CloseTopic;
    activeTab.OpenTopic(tp);
  end;
end;

// O̍폜
procedure TMainForm.TrashToolButtonClick(Sender: TObject);
var
  activeTab: TTopicBrowser;
  tp: TTopic;

begin
  activeTab := GetActiveTab();
  if Assigned(activeTab) then
  begin
    // CloseTopicActiveTab.TopicnilɂȂ̂ŕۑ
    tp := activeTab.Topic;
    DeleteTopic(activeTab.Topic);
    CloseTabToolButtonClick(self);
    tp.EraseIdx;
  end;
end;

procedure TMainForm.DeleteTopic(Topic: TTopic);
var
  i: integer;

begin
  if not Assigned(Topic) then
  begin
    exit;
  end;

  Topic.EraseLog;
  if FSelectedBoard is TOfflineBoard then
  begin
    (FSelectedBoard as TOfflineBoard).RemoveTopic(Topic);
    // \XV
    for i := 0 to FTopicList.Count - 1 do
    begin
      // DATgsbŃAXgɊ܂܂ĂIuWFNgƂ
      // ʂȂ̂TopicIdŔrȂΏȂ
      if TTopic(FTopicList[i]).TopicId = Topic.TopicId then
      begin
        FTopicList.Delete(i);
        break;
      end;
    end;
    TopicListRefresh;
  end;
  TopicListView.DoubleBuffered := true;
  TopicListView.Repaint;
  TopicListView.DoubleBuffered := false;
end;

// ^u
procedure TMainForm.CloseTabToolButtonClick(Sender: TObject);
var
  activeTab: TTopicBrowser;
  i, index: integer;
  found: boolean;
  pt: TPoint;

begin
  activeTab := GetTabAtPoint(TopicPagePopupMenu.PopupPoint);

  if Sender = CloseMenuItem then
  begin
    index := GetTabIndexAtPoint(TopicPagePopupMenu.PopupPoint);
    CloseTab(index);
  end else if Sender = CloseAllMenuItem then
  begin
    // Sĕ
    for i := 0 to TopicTabControl.Tabs.Count - 1 do
    begin
      CloseTab(0);
    end;
  end else if Sender = CloseWithoutMenuItem then
  begin
    // ANeBuȃ^uȊO
    found := false;
    for i := 0 to TopicTabControl.Tabs.Count - 1 do
      if not found then
      begin
        if FBrowserList[0] <> activeTab then
        begin
          CloseTab(0)
        end else
        begin
          found := true
        end;
      end else
      begin
        CloseTab(1);
      end;
  end else if Sender = nil then
  begin
    // {^NbN^u
    GetCursorPos(pt);
    index := GetTabIndexAtPoint(pt);
    CloseTab(index);
  end else
  begin
    // ANeBuȃ^u
    CloseTab(TopicTabControl.TabIndex);
  end;
end;

// SẴgsbN_E[h
procedure TMainForm.DownloadAllTopicToolButtonClick(Sender: TObject);
var
  activeTab: TTopicBrowser;
  i: Integer;

begin
  for i := 0 to FBrowserList.Count - 1 do
  begin
    activeTab := TTopicBrowser(FBrowserList[i]);
    activeTab.Reload;
  end;

  RepaintTabTimer.Enabled := true;
end;

// Cɓɒǉ
procedure TMainForm.FavoriteToolButtonClick(Sender: TObject);
var
  activeTab: TTopicBrowser;

begin
  activeTab := GetActiveTab();
  if not Assigned(activeTab) or not Assigned(activeTab.Topic) then
  begin
    exit;
  end;

  if not activeTab.Topic.IsFavorite then
  begin
    activeTab.Topic.IsFavorite := true;
    FBoardList.MyFolder.FavoriteBoard.AppendTopic(activeTab.Topic);
  end else
  begin
    activeTab.Topic.IsFavorite := false;
    FBoardList.MyFolder.FavoriteBoard.RemoveTopic(activeTab.Topic);
    if FSelectedBoard is TOfflineBoard then
    begin
      FTopicList.Remove(activeTab.Topic);
    end;
  end;
  activeTab.Topic.SaveIdx;
  TopicBrowser_ChangeDownloadState(self);

  if FSelectedBoard is TOfflineBoard then
  begin
    // \XV
    TopicListRefresh;
  end;
end;

// _E[h~
procedure TMainForm.StopToolButtonClick(Sender: TObject);
var
  activeTab: TTopicBrowser;

begin
  activeTab := GetActiveTab();
  if Assigned(activeTab) and Assigned(activeTab.Topic) then
  begin
    activeTab.Topic.CancelDownload;
  end;
end;

// gsbN̍쐬
procedure TMainForm.MakeTopicToolButtonClick(Sender: TObject);
begin

  if FSelectedBoard <> nil then
  begin
    if FSelectedBoard is TOnlineBoard then
    begin
      FWRiteForm.SetBoard((FSelectedBoard as TOnlineBoard));
    end;
  end;
end;

// URL̃Rs[
procedure TMainForm.CopyUrlMenuItemClick(Sender: TObject);
var
  ActiveTab : TTopicBrowser;
begin

  ActiveTab := GetTabAtPoint(TopicPagePopupMenu.PopupPoint);
  if ActiveTab <> nil then
    if ActiveTab.Topic <> nil then
      Clipboard.AsText := ActiveTab.Topic.BrowserUrl;

end;

// ^CgURL̃Rs[
procedure TMainForm.CopyTitleUrlMenuItemClick(Sender: TObject);
var
  ActiveTab : TTopicBrowser;
begin

  ActiveTab := GetTabAtPoint(TopicPagePopupMenu.PopupPoint);
  if ActiveTab <> nil then
    if ActiveTab.Topic <> nil then
      Clipboard.AsText := ActiveTab.Topic.Title + #13#10 +
                          ActiveTab.Topic.BrowserUrl;

end;

// uEUŊJ
procedure TMainForm.OpenByBrowserMenuItemClick(Sender: TObject);
var
  ActiveTab : TTopicBrowser;
begin

  ActiveTab := GetTabAtPoint(TopicPagePopupMenu.PopupPoint);
  if ActiveTab <> nil then
  begin
    if ActiveTab.Topic <> nil then
    begin
      OpenBrowser(ActiveTab.Topic.BrowserUrl);
    end;
  end;
end;

procedure TMainForm.BoardListBoxMouseUp(Sender: TObject;
                                        Button: TMouseButton;
                                        Shift: TShiftState;
                                        X, Y: Integer);
var
  index: integer;
  pos: TPoint;
  item: TBoardListBoxItem;
  boardName: string;
begin

  if Button = mbRight then
  begin
    pos.X := x;
    pos.Y := y;
    index := BoardListBox.ItemAtPos(pos, true);
    if index < 0 then
    begin
      index := BoardListBox.Count - 1;
    end;
    BoardListBox.ItemIndex := index;

    // {^
    item := TBoardListBoxItem(FBoardListBoxItems[index]);
    if item.Board <> nil then
    begin
      boardName := TBoard(item.Board).DisplayName
    end else
    begin
      boardName := '' + item.Category.CategoryName;
    end;

    // o^Ă΃`FbN
    if FBoardButtonList.IndexOf(boardName) = -1 then
    begin
      RegisterBoardButtonMenuItem.Checked := false
    end else
    begin
      RegisterBoardButtonMenuItem.Checked := true;
    end;

    // }CtH_ȂAXbhqɍ쐬j[\
    if boardName = '}CtH_' then
    begin
      CreateOfflineFolder.Visible := true
    end else
    begin
      CreateOfflineFolder.Visible := false;
    end;

    // XbhqɂȂ폜j[\
    RemoveOfflineFolder.Visible := false;
    if (item.Board <> nil) and
       (item.Board is TOfflineBoard) and
       (item.Board.DisplayName <> 'Cɓ') and
       not (item.Board is TAllSubscribedTopics) then
    begin
      RemoveOfflineFolder.Visible := true;
    end;

    // ۂ̔ȊÓuURLRs[vuuEUŊJv\
    CopyBoardUrlMenuButton.Visible     := True;
    OpenBoardByBrowserMenuItem.Visible := True;
    if not (item.Board is TOnlineBoard) then
    begin
      CopyBoardUrlMenuButton.Visible     := False;
      OpenBoardByBrowserMenuItem.Visible := False;
    end;

    BoardListBoxPopupMenu.Popup(Mouse.CursorPos.X, Mouse.CursorPos.Y);
  end else if button = mbLeft then
  begin
    BoardListBoxClick(BoardListBox);
  end;
end;

procedure TMainForm.CopyBoardUrlMenuButtonClick(Sender: TObject);
var
  Index: Integer;
  item: TBoardListBoxItem;

begin
  Index := BoardListBox.ItemIndex;
  if (index < 0) or (index >= FBoardListBoxItems.Count) then
  begin
    exit;
  end;
  item := TBoardListBoxItem(FBoardListBoxItems[Index]);
  if Assigned(item.Board) and (item.Board is TOnlineBoard) then
  begin
    Clipboard.AsText := (item.Board as TOnlineBoard).BoardUrl;
  end;
end;

procedure TMainForm.OpenBoardByBrowserMenuItemClick(Sender: TObject);
var
  index: Integer;
  item: TBoardListBoxItem;

begin
  index := BoardListBox.ItemIndex;
  if (index < 0) or (index >= FBoardListBoxItems.Count) then
  begin
    exit;
  end;

  item := TBoardListBoxItem(FBoardListBoxItems[index]);
  if Assigned(item.Board) and (item.Board is TOnlineBoard) then
  begin
    OpenBrowser((item.Board as TOnlineBoard).BoardUrl);
  end;
end;

{ --------------------------------------------------------
  ֐: CloseTab
  pr  : ^u
    : Tab - ^u
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TMainForm.CloseTab(Index: integer);
var
  tab: TTopicBrowser;
  select: integer;
  closedTabIndex : Integer;

begin
  if (index >= 0) and (index < FBrowserList.Count) then
  begin
    tab := TTopicBrowser(FBrowserList[index]);
    if TopicTabControl.Tabs.Count = 1 then
    begin
      tab.CloseTopic;
    end else
    begin
      closedTabIndex := TopicTabControl.TabIndex;

      tab.SaveScrollPosition;
      tab.Topic.SaveIdx();
      TopicTabControl.Tabs.Delete(index);
      TopicTabControl.RemoveControl(tab);
      FBrowserList.Remove(tab);

      if closedTabIndex = index then
      begin
        if index > 1 then
        begin
          select := index - 1
        end else
        begin
          select := 0;
        end;
        TopicTabControl.TabIndex := select;
      end;
    end;
    FOldtab := nil;

    ChangeTab();
  end;
end;

{ --------------------------------------------------------
  pr  : gsbN^uŊJ
  l  : Ȃ
  ------------------------------------------------------ }
function TMainForm.OpenTab(Topic: TTopic; newTab: Boolean): TTopicBrowser;
var
  openNewTab: Boolean;
  activeTab, browser: TTopicBrowser;
  i, foundIndex: Integer;

  procedure Change(const idx: integer);
  begin
    TopicTabControl.TabIndex := idx;
    Application.ProcessMessages;
  end;

begin
  // ɃXbh\ς݂Ȃ炻ANeBuɂ
	foundIndex := -1;
	activeTab := nil;
  for i := 0 to TopicTabControl.Tabs.Count - 1 do
  begin
    browser := TTopicBrowser(FBrowserList[i]);
    if browser.Topic = Topic then
    begin
		  activetab := browser;
      foundIndex := i;
			break;
    end;
  end;

  if foundIndex > -1 then
  begin
    // [hJn
    Change(foundIndex);
    activetab.Reload();
  end else
  begin
    if (TTopicBrowser(FBrowserList[0]).Topic <> nil) and newTab then
    begin
      openNewTab := true;
    end else
    begin
      openNewTab := false;

		  activeTab := GetActiveTab();
      if activeTab.AutoReload then
      begin
        openNewTab := true;
      end;
    end;

    if openNewTab then
    begin
      if Animate1.FileName <> '' then
      begin
        Animate1.Active := true;
      end;

      // VJ
  	  activeTab := CreateTopicBrowser();
      Change(FBrowserList.Count - 1);
      // ŕ\ȂƃXN[Ȃ
      activeTab.Visible := true;
      activeTab.OpenTopic(Topic);
    end else
    begin
      // ANeBuȃ^uŊJ
      if activeTab = nil then
      begin
        result := nil;
        exit;
      end;
      Change(TopicTabControl.TabIndex);
      if Animate1.FileName <> '' then
      begin
        Animate1.Active := true;
      end;
      activeTab.OpenTopic(Topic);
    end;
  end;
  result := activeTab;
end;


{ --------------------------------------------------------
  ֐: GetActiveTab
  pr  : ANeBuȃ^u擾
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
function TMainForm.GetActiveTab: TTopicBrowser;
var
  index : integer;
begin

  index := TopicTabControl.TabIndex;
  if (index >= 0) and (index < FBrowserList.Count) then
  begin
    result := TTopicBrowser(FBrowserList[index])
  end else
  begin
    result := nil;
  end;
end;

procedure TMainForm.TopicTabControlResize(Sender: TObject);
var
  i: Integer;

begin
  if FBrowserList <> nil then
  begin
    for i := 0 to FBrowserList.Count - 1 do
    begin
      with TTopicBrowser(FBrowserList[i]) do
      begin
        Left   := 3;
        Top    := TopicTabControl.TabHeight * TopicTabControl.RowCount + 5;
        Width  := TopicTabControl.Width - 6;
        Height := TopicTabControl.Height - Top - 3;
      end;
    end;
  end;
end;

procedure TMainForm.TopicListViewDrawSubItem(Control: TWinControl;
                                             var ACanvas: TCanvas;
                                             Index, SubItem: Integer;
                                             ARect: TRect;
                                             State: TOwnerDrawState;
                                             var DefaultDrawing: Boolean);
begin
  DefaultDrawing := true;
end;

procedure TMainForm.TopicListViewDrawItem(Control: TWinControl;
                                          var ACanvas: TCanvas;
                                          Index: Integer;
                                          ARect: TRect;
                                          State: TOwnerDrawState;
                                          var DefaultDrawing, FullRowSelect: Boolean);
begin
  DefaultDrawing := true;
end;

// URLJ
procedure TMainForm.OpenUrl(Sender: TObject; Url: string);
var
  parser: T2chUrlParser;
  topic: TTopic;
  board: TOnlineBoard;
  msgNo: integer;
  isNewTab : Boolean;
  regEx: TRegExpr;
  b: TTopicBrowser;

begin
  if AnsiStartsStr('menu://at/', URL) then
  begin
    msgNo := StrToIntNeo(CopyAfter(URL, 11));
    FSelectMessageNo := msgNo;
    ArticlePopupMenu.Popup(Mouse.CursorPos.X, Mouse.CursorPos.Y);
    exit;
  end;

  if (Pos('2ch.net/',        URL) = 0) and
     (Pos('machibbs.com/',   URL) = 0) and
     (Pos('machi.to/',       URL) = 0) and
     (Pos('bbspink.com/',    URL) = 0) and
     (Pos('livesoccer.net/', URL) = 0) then
  begin
    // uEUŊJ
    OpenBrowser(Url);
    exit;
  end;

  parser := T2chUrlParser.Create(Url);
  try
    if not parser.Is2chUrl then
    begin
      // uEUŊJ
      OpenBrowser(Url);
      exit;
    end;

    board := FBoardList.GetBoard(parser.Host, parser.BoardName);

    if parser.TopicId <> '' then
    begin
      topic := board.GetTopic(parser.TopicId);

      if topic.NoIndex = true then
      begin
        Board.SendTopicList;
      end;

      if Sender is TEdit then
      begin
        isNewTab := (GetAsyncKeyState(VK_SHIFT) < 0) xor gConfig.AlwaysNewTab;
        OpenTab(topic, IsNewTab);
      end else
      begin // if Sender is TTopicBrowser
        b := OpenTab(topic, True);
        if b is TTopicBrowserIE then
        begin
          regEx := TRegExpr.Create;
          try
            // Wv鑼X̃Xԍ擾
            regEx.Expression := '^http://.+\.2ch\.net/.+/(\d{1,3}).?(\d{1,3})?$';
            if regEx.Exec(Url) then
            begin
              msgno := StrToInt(regEx.Substitute('$1'));
              //b.JumpMessage(msgno);
            end;
          finally
            regEx.Free;
          end;
        end;
      end;
    end else
    begin
      OpenBoard(board);
    end;
  finally
    parser.Free;
  end;
end;

function TMainForm.CreateTopicBrowser: TTopicBrowser;
begin

  if gConfig.BrowserType = ubDoe then
  begin
    result := TTopicBrowserDoe.Create(self)
  end else
  begin
    result := TTopicBrowserIE.Create(self);
  end;

  result.OnChangeDownloadState := TopicBrowser_ChangeDownloadState;
  result.OnComplete := TopicBrowser_Complete;
  result.Visible := false;
  result.Parent  := TopicTabControl;
  result.OnNavigateUrl := TopicBrowser_NavigateUrl;
  FBrowserList.Add(result);
  TopicTabControl.Tabs.Add('');
end;

// {[hꗗ̍č\z
procedure TMainForm.RefreshBoardListBox;
var 
  c_Category: TBoardCategory;
  newItem: TBoardListBoxItem;
  menuItem: TMenuItem;
  categoryName: string;
  i, j,
  selectIndex, numOfShowItems, numOfChildBoards,
  newTopIndex, oldTopIndex: integer;

begin
  numOfShowItems   := BoardListBox.Height div BoardListBox.ItemHeight;
  selectIndex      := BoardListBox.ItemIndex;
  categoryName     := BoardListBox.Items[BoardListBox.ItemIndex];
  categoryName     := Copy(categoryName, 3, Length(categoryName) - 1);
  numOfChildBoards := 0;

  oldTopIndex := BoardListBox.TopIndex;
  FBoardListBoxItems.Clear;

  Application.ProcessMessages;

  for i := 0 to FBoardList.Categorys.Count - 1 do
  begin
    c_Category := TBoardCategory(FBoardList.Categorys[i]);

    newItem := TBoardListBoxItem.Create;
    if c_Category.Opened then
    begin
      newItem.ViewString := '' + c_Category.CategoryName
    end else
    begin
      newItem.ViewString := '' + c_Category.CategoryName;
    end;
    newItem.Category := c_Category;
    newItem.Board    := nil;
    FBoardListBoxItems.Add(newItem);

    if c_Category.Opened then
    begin
      for j := 0 to c_Category.Boards.Count - 1 do
      begin
        newItem := TBoardListBoxItem.Create;
        newItem.ViewString := '@' + TBoard(c_Category.Boards[j]).DisplayName;
        newItem.Category   := c_Category;
        newItem.Board      := TBoard(c_Category.Boards[j]);
        FBoardListBoxItems.Add(newItem);
        if categoryName = c_Category.CategoryName then
        begin
          Inc(numOfChildBoards);
        end;
      end;
    end;
  end;

  BoardListBox.Count := FBoardListBoxItems.Count;
  BoardListBox.ItemIndex := selectIndex;
  newTopIndex := oldTopIndex;

  // scroll to opened category
  if (numOfChildBoards > 0) then
  begin
    // if not enough space
    if numOfChildBoards > numOfShowItems then
    begin
      newTopIndex := selectIndex;
    end else if (((selectIndex - newTopIndex) + numOfChildBoards + 3) > numOfShowItems) then
    begin
      newTopIndex := (selectIndex + numOfChildBoards + 2) - numOfShowItems;
    end;
  end;

  BoardListBox.TopIndex := newTopIndex;

  FavoritePopupMenu.Items.Clear;
  for i := 1 to FBoardList.MyFolder.Boards.Count - 1 do
  begin
    if (TBoard(FBoardList.MyFolder.Boards[i]) is TAllSubscribedTopics) then
    begin
      continue;
    end;
    menuItem := TMenuItem.Create(FavoritePopupMenu);
    menuItem.Caption := TBoard(FBoardList.MyFolder.Boards[i]).DisplayName;
    menuItem.OnClick := FavoriteMenuItemClick;
    menuItem.Tag     := i;
    FavoritePopupMenu.Items.Add(menuItem);
  end;
end;

procedure TMainForm.TopicBrowser_NavigateUrl(Sender: TObject; URL: string);
begin
  OpenUrl(Sender, URL);
end;

procedure TMainForm.OpenBrowser(URL: string);
begin
  URL := AnsiReplaceText(URL, '[%23]', '#');

  if gConfig.UseDefaultBrowser or (gConfig.BrowserPath = '') then
  begin
    ShellExecute(Handle, 'OPEN', pchar('URL:' + URL),'', '', SW_SHOWNORMAL)
  end else
  begin
    ShellExecute(Handle, 'OPEN', PChar(gConfig.BrowserPath), pchar(URL), '', SW_SHOWNORMAL);
  end;
end;

procedure TMainForm.TopicBrowser_ChangeDownloadState(Sender: TObject);
begin
  // gsbNXgXV
  RepaintListViewTimer.Enabled := true;
  // ^uĕ`
  RepaintTabTimer.Enabled := true;
  ChangeTab();
end;

procedure TMainForm.TopicBrowser_Complete(Sender: TObject);
begin
  // gsbNXgXV
  RepaintListViewTimer.Enabled := true;
  // ^uĕ`
  RepaintTabTimer.Enabled := true;
  ChangeTab();
  if Animate1.FileName <> '' then
  begin
    Animate1.Active := false;
  end;
  {var
  b: TTopicBrowser;
  s: string;

  ܂ȂX邩ǂl
  b := TTopicBrowser(Sender);
  if b.Topic.IsFreezed and (b.Topic.MessageCount = 0) then
  begin
    // CloseTabŃgsbN̂
    s := b.Topic.StatusText;
    CloseTab(TopicTabControl.TabIndex);
    MainStatusBar.SimpleText := s;
  end;}
end;

procedure TMainForm.RepaintTabTimerTimer(Sender: TObject);
begin
  RepaintTabTimer.Enabled := false;

  TopicTabControl.DoubleBuffered := true;
  TopicTabControl.Repaint;
  TopicTabControl.DoubleBuffered := false;
end;

procedure TMainForm.RepaintListViewTimerTimer(Sender: TObject);
begin
  RepaintListViewTimer.Enabled := false;

  TopicListView.DoubleBuffered := true;
  TopicListView.Repaint;
  TopicListView.DoubleBuffered := false;
end;

procedure TMainForm.CoolBarRestore;
var
  i: integer;
  idItems, breakItems, widthItems: TStringArray;
  band: TCoolBand;

begin
  SetLength(idItems, 0);
  SetLength(breakItems, 0);
  SetLength(widthItems, 0);

  CoolBar.Bands.BeginUpdate;
  idItems    := Split(gConfig.CoolBarBandId, ',');
  breakItems := Split(gConfig.CoolBarBandBreak, ',');
  widthItems := Split(gConfig.CoolBarBandWidth, ',');
  if (Length(idItems)    >= 3) and
     (Length(breakItems) >= 3) and
     (Length(widthItems) >= 3) then
  begin
    for i := 2 downto 0 do
    begin
      band := TCoolBand(CoolBar.Bands.FindItemID(StrToIntNeo(idItems[i])));
      band.Index := i;
      band.Break := (Trim(UpperCase(breakItems[i])) <> 'FALSE');
      band.Width := StrToIntNeo(widthItems[i]);
    end;
  end;
  CoolBar.Bands.EndUpdate;
end;

procedure TMainForm.SaveBoardButton;
begin

  FBoardButtonList.SaveToFile(AppPath('favboard.idx'));

end;

procedure TMainForm.ReloadOpenedTopic;
var
  b: TTopicBrowser;

begin
  b := GetActiveTab;
  if Assigned(b.Topic) and b.Topic.IsOpened then
  begin
    OpenTab(b.Topic, false);
  end;
end;

// gsbN_E[h
procedure TMainForm.ReceiveActiveTabActionExecute(Sender: TObject);
begin
  ReloadOpenedTopic;
end;

procedure TMainForm.CloseActiveTabActionExecute(Sender: TObject);
begin
  CloseTabToolButtonClick(CloseTabToolButton);
end;

procedure TMainForm.TabBeforeActionExecute(Sender: TObject);
var
  index : integer;
begin
  index := TopicTabControl.TabIndex;
  if index > 0 then TopicTabControl.TabIndex := index - 1;
  ChangeTab();
end;

procedure TMainForm.TabForwardActionExecute(Sender: TObject);
var
  index : integer;
begin
  index := TopicTabControl.TabIndex;
  if index < TopicTabControl.Tabs.Count - 1 then TopicTabControl.TabIndex := index + 1;
  ChangeTab();
end;

procedure TMainForm.ChangeLimitAllActiveTabExecute(Sender: TObject);
var
  ActiveTab : TTopicBrowser;
begin

  ActiveTab := GetActiveTab();
  if ActiveTab = nil then exit;

  ActiveTab.ChangeViewLimit(0);
end;

procedure TMainForm.ChangeStyle1ActionExecute(Sender: TObject);
begin
  StyleSub1ToolButton.Down := not StyleSub1ToolButton.Down;
  StyleChange(StyleSub1ToolButton);
end;

procedure TMainForm.ChangeStyle2ActionExecute(Sender: TObject);
begin
  StyleSub2ToolButton.Down := not StyleSub2ToolButton.Down;
  StyleChange(StyleSub2ToolButton);
end;

procedure TMainForm.ChangeStyle3ActionExecute(Sender: TObject);
begin
  StyleSub3ToolButton.Down := not StyleSub3ToolButton.Down;
  StyleChange(StyleSub3ToolButton);
end;

procedure TMainForm.RemoveOfflineFolderClick(Sender: TObject);
var
  index: Integer;
  item: TBoardListBoxItem;
  board: TOfflineBoard;

begin
  index := BoardListBox.ItemIndex;
  if (index < 0) or (index >= FBoardListBoxItems.Count) then
  begin
    exit;
  end;

  item := TBoardListBoxItem(FBoardListBoxItems[index]);
  if Assigned(item.Board) and (item.Board is TOfflineBoard) then
  begin
    board := item.Board as TOfflineBoard;

    // TNƍ폜
    DeleteFile(AppPath(board.DisplayName + '.idx'));
    board.TopicList.Clear;

    FBoardList.MyFolder.Boards.Remove(board);
    RefreshBoardListBox;
    BoardListBoxClick(BoardListBox);
  end;
end;

procedure TMainForm.FavoritePopupMenuPopup(Sender: TObject);
var
  i, boardIndex: integer;
  activeTab: TTopicBrowser;

begin

  activeTab := GetActiveTab();
  for i := 0 to FavoritePopupMenu.Items.Count - 1 do
  begin
    FavoritePopupMenu.Items[i].Checked := false;
    if (activeTab <> nil) and (activeTab.Topic <> nil) then
    begin
      boardIndex := FavoritePopupMenu.Items[i].Tag;
      FavoritePopupMenu.Items[i].Checked :=
        TOfflineBoard(FBoardList.MyFolder.Boards[boardIndex]).IsHave(activeTab.Topic);
    end;
  end;
end;

procedure TMainForm.FavoriteMenuItemClick(Sender: TObject);
var
  activeTab: TTopicBrowser;
  board: TOfflineBoard;

begin
  activeTab := GetActiveTab();
  if Assigned(activeTab) and Assigned(activeTab.Topic) then
  begin
    board := TOfflineBoard(FBoardList.MyFolder.Boards[TMenuItem(Sender).Tag]);
    if board.IsHave(activeTab.Topic) then
    begin
      board.RemoveTopic(activeTab.Topic)
    end else
    begin
      board.AppendTopic(activeTab.Topic);
    end;
  end;
end;

procedure TMainForm.BoardListBoxMouseDown(Sender: TObject;
                                          Button: TMouseButton;
                                          Shift: TShiftState;
                                          X, Y: Integer);
var
  index: integer;
  pos: TPoint;
begin

  pos.X := x;
  pos.Y := y;
  index := BoardListBox.ItemAtPos(Pos, True);
  if index < 0 then
  begin
    index := BoardListBox.Count - 1;
  end;
  BoardListBox.Selected[index] := True;

  ReleaseCapture;
end;

procedure TMainForm.TopicTabControlDragOver(Sender, Source: TObject;
                                            X, Y: Integer;
                                            State: TDragState;
                                            var Accept: Boolean);
begin
  if not (Source is TTabControl) then
  begin
    Accept := False;
  end;
end;

procedure TMainForm.TopicTabControlDragDrop(Sender, Source: TObject;
                                            X, Y: Integer);
var 
  index: Integer;
  pt: TPoint;

begin
  if not (Sender is TTabControl) then
  begin
    Exit;
  end;

  GetCursorPos(pt);
  index := GetTabIndexAtPoint(pt);

  if (index < 0) or (index = TopicTabControl.TabIndex) then
  begin
    exit;
  end;
  FBrowserList.Move(TopicTabControl.TabIndex, index); 
  TopicTabControl.TabIndex := index;
  ChangeTab;
end;

procedure TMainForm.BoardListBoxDragOver(Sender, Source: TObject;
                                         X, Y: Integer;
                                         State: TDragState;
                                         var Accept: Boolean);
begin
  if not (Source is TTabControl) then
  begin
    Accept := False;
  end;
end;

procedure TMainForm.BoardListBoxDragDrop(Sender, Source: TObject;
                                         X, Y: Integer);
var 
  activeTab: TTopicBrowser;
  tabIndex: Integer;
  index: Integer;
  pos: TPoint;
  board: TBoard;
  offlineBoard: TOfflineBoard;
  topic: TTopic;

begin
  activeTab := GetActiveTab();
  if (activeTab = nil) or (activeTab.Topic = nil) then
  begin
    exit;
  end;

  tabIndex := (Source as TTabControl).TabIndex;
  pos.X := X;
  pos.Y := Y;
  index := (Sender as TListBox).ItemAtPos(pos, true);

  if (index < 1) or (index > FBoardList.MyFolder.Boards.Count) then
  begin
    exit;
  end;

  board := FBoardList.MyFolder.Boards[index - 1];
  if board is TOfflineBoard then
  begin
    offlineBoard := board as TOfflineBoard;
    topic := TTopicBrowser(FBrowserList[TabIndex]).Topic;
    if not offlineBoard.IsHave(topic) then
    begin
      offlineBoard.AppendTopic(topic);
      if FSelectedBoard = offlineBoard then
      begin
        OpenBoard(offlineBoard);
      end;
    end;
  end;
  TopicTabControl.EndDrag(false);
end;


{ Topic Priority Related }

procedure TMainForm.SetPriorityMenuItemClick(Sender: TObject); 
var 
  i: Integer;
  menuItem: TMenuItem;
  item: TListItem;
  topic: TTopic;

begin 
  item := TopicListView.Selected;
  if item <> nil then
  begin
    topic    := TTopic(FTopicList[item.Index]);
    menuItem := TMenuItem(Sender);
    // do check selected priority 
    for i := 0 to menuItem.Count - 1 do
    begin
      if topic.Priority = StrToInt(menuItem[i].Caption) then
      begin
        menuItem.Items[i].Checked := True;
      end;
    end;
  end; 
end; 

procedure TMainForm.SetPriorityPlusItemMenuClick(Sender: TObject);
var
  Priority : Integer; 
  MenuItem : TMenuItem; 
begin 
  MenuItem := TMenuItem(Sender); 
  Priority := StrToInt(MenuItem.Caption); 
  SetSelectedTopicPriority(Priority); 
end; 


procedure TMainForm.TopicListViewPopupMenuPopup(Sender: TObject);
var
  item : TListItem;
  i: Integer;

begin
  item := TopicListView.Selected;
  if item <> nil then
  begin
    for i := 0 to TopicListViewPopupMenu.Items.Count - 1 do
    begin
      TopicListViewPopupMenu.Items[i].Enabled := True;
    end;

    // if not yet retrieved
    if not TTopic(FTopicList[item.Index]).IsGotLog and
       (FSelectedBoard is TOnlineBoard) then
    begin
      TrashMenuItem.Enabled := False;
    end;
  end else
  begin
    for i := 0 to TopicListViewPopupMenu.Items.Count - 1 do
    begin
      TopicListViewPopupMenu.Items[i].Enabled := False;
    end;
  end;

  if gConfig.AlwaysNewTab then
  begin
    OpenNewTabMenuItem.Caption := '̃^uŊJ'
  end else
  begin
    OpenNewTabMenuItem.Caption := 'V^uŊJ';
  end;
end;

procedure TMainForm.SetSelectedTopicPriority(Priority : Integer);
var
  topic: TTopic;
  item: TListItem;

begin
  item := TopicListView.Selected;
  if item <> nil then
  begin
    topic := TTopic(FTopicList[item.Index]);
    if topic.Priority <> Priority then
    begin
      topic.Priority := Priority;
      topic.SaveIdx();
      topicListView.Repaint;
    end; 
  end;
end; 
{ /Topic Priority Related }

procedure TMainForm.TopicPagePopupMenuPopup(Sender: TObject);
var
  activeTab: TTopicBrowser;
  i: Integer;

begin
  activeTab := GetActiveTab();
  if (activeTab = nil) or (activeTab.Topic = nil) then
  begin
    for i := 0 to TopicPagePopupMenu.Items.Count - 1 do
    begin
      TopicPagePopupMenu.Items[i].Enabled := False;
    end;
  end else
  begin
    for i := 0 to TopicPagePopupMenu.Items.Count - 1 do
    begin
      TopicPagePopupMenu.Items[i].Enabled := True;
    end;
  end;
end;

// wʒũ^uCfbNX擾
function TMainForm.GetTabIndexAtPoint(Point: TPoint): Integer;
var
  info: TTCHitTestInfo;
begin
  info.pt := TopicTabControl.ScreenToClient(Point);
  info.flags := TCHT_ONITEM;
  result := TabCtrl_HitTest(TopicTabControl.Handle, @Info);
end;


// wʒũ^u擾
function TMainForm.GetTabAtPoint(Point: TPoint): TTopicBrowser;
var 
  index: Integer;

begin
  index := GetTabIndexAtPoint(Point);
  if (index >= 0) and (index < FBrowserList.Count) then
  begin
    result := TTopicBrowser(FBrowserList[index])
  end else
  begin
    result := nil;
  end;
end;

// {^ҏWtH[̕\
procedure TMainForm.EditBoardButtonMenuItemClick(Sender: TObject);
var
  Point : TPoint;
  EditBoardButtonForm : TEditBoardButtonForm;
begin
  // FBoardButtonList ܂BfsłB
  EditBoardButtonForm := TEditBoardButtonForm.Create(self);
  GetCursorPos(point); 
  EditBoardButtonForm.Left := Point.X - EditBoardButtonForm.Width div 2; 
  EditBoardButtonForm.Top  := Point.Y - EditBoardButtonForm.Height div 3; 
  if EditBoardButtonForm.Top < 0 then
  begin
    EditBoardButtonForm.Top := 0;
  end;
  EditBoardButtonForm.BoardButtonList := FBoardButtonList;
  EditBoardButtonForm.ShowModal;
  if not EditBoardButtonForm.Cancel then 
  begin 
    CreateBoardButton(); 
    SaveBoardButton(); 
  end; 
  EditBoardButtonForm.Free; 
end;

procedure TMainForm.OpenAllCategoryActionExecute(Sender: TObject);
begin
  FBoardList.OpenAll;
  RefreshBoardListBox;
end;

procedure TMainForm.CloseAllCategoryActionExecute(Sender: TObject);
begin
  FBoardList.CloseAll;
  RefreshBoardListBox;
end;

procedure TMainForm.InputMemoMenuItemClick(Sender: TObject);
var
  item: TListItem;
  topic: TTopic;
  memo: string;

begin
  item := TopicListView.Selected;
  if item <> nil then
  begin
    topic := TTopic(FTopicList[item.Index]);
    memo  := InputBox('', topic.Title, topic.Memo);
    if memo <> topic.Memo then
    begin
      Topic.Memo := memo;
      Topic.SaveIdx;
      TopicListView.Repaint;
    end; 
  end;
end;

procedure TMainForm.LogSweeperActionExecute(Sender: TObject);
var
  logSweeperForm: TLogSweeperForm;

begin
  logSweeperForm := TLogSweeperForm.Create(self);
  logSweeperForm.BoardList := FBoardList;
  logSweeperForm.ShowModal;
  logSweeperForm.Free;
end;

procedure TMainForm.FormIdle(Sender: TObject; var Done: Boolean);
var
  p: TPoint;
  control: TControl;
  activeTab : TTopicBrowser;
  i: Integer;

begin
  if not (gConfig.AutoFocus) or
     not FActive then
  begin
    exit;
  end;

  if not self.Active then
  begin
    exit;
  end;

  GetCursorPos(p);
  control := FindDragTarget(p, True);

  if FMouseControl <> control then
  begin
    FMouseControl := control;
    if FMouseControl = BoardListBox then
    begin
      BoardListBox.SetFocus
    end else if FMouseControl = TopicListView then
    begin
      RightPanel.SetFocus; // ̂̍sȂƃuEUListViewœȂ
      TopicListView.SetFocus;
    end else if FMouseControl is TWebBrowser then
    begin
      activeTab := GetActiveTab();
      if activeTab <> nil then
      begin
        for i := 0 to ActiveTab.ComponentCount - 1 do
        begin
          if (activeTab.Components[i] is TWebBrowser) and
             Assigned(TWebBrowser(ActiveTab.Components[i]).Document) then
          begin
            OleVariant(TWebBrowser(ActiveTab.Components[i]).Document).
                                                    ParentWindow.Focus;
          end;
        end;
      end;
    end;
  end;
end;

procedure TMainForm.FormDeactivate(Sender: TObject);
begin
  FActive := false;
end;

procedure TMainForm.FormActivate(Sender: TObject);
begin
  FActive := true;
end;

procedure TMainForm.GoTrayActionExecute(Sender: TObject);
begin
  // ^XNgCɑޔ
  TrayIcon.Visible := true;
  self.Visible := false;
end;

procedure TMainForm.TrayIconMouseClick(Sender: TObject;
                                       Button: TMouseButton;
                                       Shift: TShiftState;
                                       X, Y: Integer);
begin
  // ^XNgC߂
  TrayIcon.Visible := false;
  self.Visible := true;
end;

procedure TMainForm.OpenSelectedTopic;
var
  item: TListItem;
  isNewTab: Boolean;

begin
  item := TopicListView.Selected;
  if item <> nil then
  begin
    isNewTab := (GetAsyncKeyState(VK_SHIFT) < 0) xor gConfig.AlwaysNewTab;
    OpenTab(FTopicList[item.Index], isNewTab);
  end;
end;

procedure TMainForm.TopicListViewKeyDown(Sender: TObject;
                                         var Key: Word;
                                         Shift: TShiftState);
begin
  if Key = VK_RETURN then
  begin
    OpenSelectedTopic;
  end;
end;

procedure TMainForm.BoardListBoxKeyDown(Sender: TObject;
                                        var Key: Word;
                                        Shift: TShiftState);
begin
  case Key of
    VK_RETURN   : BoardListBoxClick(Sender);
    VK_MULTIPLY : OpenAllCategoryActionExecute(Sender);
    VK_SUBTRACT : CloseAllCategoryActionExecute(Sender);
  end;
end;

procedure TMainForm.BoardListViewSetVisible(const Visible, IsNormalMode: boolean);
begin 
  if Visible then 
  begin 
    LeftPanel.Visible := true; 
    LeftPanel.Width   := gConfig.BoardListBoxWidth; 
    RightPanel.Align  := alNone; 
    Splitter1.Visible := true; 
    Splitter1.Align   := alNone; 
    Splitter1.Width   := 3;
    Splitter1.Left    := LeftPanel.Width;
    Splitter1.Align   := alLeft; 
    RightPanel.Left   := Splitter1.Left + Splitter1.Width; 
    RightPanel.Align  := alClient; 
  end else 
  begin 
    gConfig.BoardListBoxWidth := LeftPanel.Width; 
    LeftPanel.Visible  := false; 
    Splitter1.Visible  := false; 
  end; 
end; 

procedure TMainForm.TopicListViewSetVisible(const Visible, IsNormalMode : boolean); 
begin
  if Visible then 
  begin 
    TopicListView.Visible := true; 
    if IsNormalMode then 
    begin
      TopicListView.Align  := alTop;
      TopicListView.Height := gConfig.TopicListViewHeight; 
    end else 
    begin 
      TopicListView.Align  := alLeft; 
      TopicListView.Width  := gConfig.TopicListViewWidth; 
    end; 
  end else 
  begin 
    // StyleSub2ToolButton ܂ StyleSub3ToolButton ꂽƂA 
    //  BrowserPanel \ĂƂ݂̂ɁA TopicListView ̍/ۑ 
    if (TopicListView.Visible <> Visible) and BrowserPanel.Visible then
    begin
      if IsNormalMode then
        gConfig.TopicListViewHeight := TopicListView.Height
      else
        gConfig.TopicListViewWidth  := TopicListView.Width;
    end;
    TopicListView.Visible := false;
    BrowserPanel.Align    := alClient;
  end;
end;

procedure TMainForm.BrowserPanelSetVisible(const Visible, IsNormalMode : boolean);
begin
  if Visible then
  begin
    BrowserPanel.Visible := true;
    BrowserPanel.Align   := alNone;
    if IsNormalMode then
    begin
      BrowserPanel.Top   := Splitter2.Top + Splitter2.Height;
    end else
    begin
      BrowserPanel.Left  := Splitter2.Left + Splitter2.Width;
    end;
    BrowserPanel.Align   := alClient;
  end else
  begin
    BrowserPanel.Visible := false;
    TopicListView.Align  := alClient;
  end;
end;

procedure TMainForm.Spliter2SetVisible(const Visible, IsNormalMode : boolean);
begin
  if Visible then
  begin
    Splitter2.Visible  := true;
    Splitter2.Align    := alNone;
    if IsNormalMode then
    begin
      Splitter2.Height := 3;
      Splitter2.Top    := TopicListView.Height;
      Splitter2.Align  := alTop;
    end else
    begin
      Splitter2.Width  := 3;
      Splitter2.Left   := TopicListView.Width;
      Splitter2.Align  := alLeft;
    end;
  end else
  begin
    Splitter2.Visible  := false;
  end;
end;

procedure TMainForm.CopyUrlTopicListClick(Sender: TObject);
var
  topic: TTopic;

begin
  if (TopicListView.ItemIndex <> -1) then
  begin
    topic := TTopic(FTopicList[TopicListView.ItemIndex]);
    Clipboard.AsText := topic.BrowserUrl;
  end;
end;

procedure TMainForm.CopyTitleUrlTopicListClick(Sender: TObject);
var
  topic: TTopic;

begin
  if (TopicListView.ItemIndex <> -1) then
  begin
    topic := TTopic(FTopicList[TopicListView.ItemIndex]);
    Clipboard.AsText := topic.Title + #13#10 + topic.BrowserUrl;
  end;
end;

procedure TMainForm.OpenByBrowserTopicListClick(Sender: TObject);
var
  topic : TTopic;

begin
  if (TopicListView.ItemIndex <> -1) then
  begin
    topic := TTopic(FTopicList[TopicListView.ItemIndex]);
    OpenBrowser(topic.BrowserUrl);
  end;
end;

procedure TMainForm.OpenKatju88SiteMenuItemClick(Sender: TObject);
begin
  OpenBrowser('http://katju88project.sourceforge.jp/');
end;

procedure TMainForm.OpenSupportBoardMenuItemClick(Sender: TObject);
begin
  OpenBrowser('http://katju88project.sourceforge.jp/forum/');
end;

procedure TMainForm.Open2chMenuItemClick(Sender: TObject);
begin
  OpenBrowser('http://www.2ch.net/');
end;

procedure TMainForm.Open2chGuideMenuItemClick(Sender: TObject);
begin
  OpenBrowser('http://www.2ch.net/guide/');
end;

procedure TMainForm.SendMailMenuItemClick(Sender: TObject);
begin
  OpenBrowser('http://sourceforge.jp/projects/katju88kid/');
end;

procedure TMainForm.TrashMenuItemClick(Sender: TObject);
var
  index: Integer;
  topic: TTopic;

begin
  index := TopicListView.ItemIndex;
  if index <> -1 then
  begin
    topic := TTopic(FTopicList[index]);
    if topic.IsOpened then
    begin
      TrashToolButtonClick(self);
    end else
    begin
      DeleteTopic(topic);
    end;
  end;
end;

procedure TMainForm.IETextSizeMenuItemClick(Sender: TObject);
var
  activeTab: TTopicBrowser;
  size: Integer;

begin
  activeTab := GetActiveTab;
  if Assigned(activeTab) and (activeTab is TTopicBrowserIE) then
  begin
    if TMenuItem(Sender).Name = 'IETextSizeGiantMenuItem' then
    begin
      size := 4
    end else if TMenuItem(Sender).Name = 'IETextSizeLargeMenuItem' then
    begin
      size := 3
    end else if TMenuItem(Sender).Name = 'IETextSizeMediumMenuItem' then
    begin
      size := 2
    end else if TMenuItem(Sender).Name = 'IETextSizeSmallMenuItem' then
    begin
      size := 1
    end else if TMenuItem(Sender).Name = 'IETextSizeTinyMenuItem' then
    begin
      size := 0
    end else
    begin
      size := 2;
    end;
    TMenuItem(Sender).Checked := True;
    TTopicBrowserIE(activeTab).SetTextSize(size);
  end;
end;

procedure TMainForm.GoToToolButtonClick(Sender: TObject);
begin
  if UrlEdit.Text <> '' then
  begin
    OpenUrl(Sender, UrlEdit.Text);
  end;
end;

procedure TMainForm.UrlEditChange(Sender: TObject);
begin
  if UrlEdit.Text <> '' then
  begin
    GoToToolButton.Hint := UrlEdit.Text + ' J'
  end else
  begin
    GoToToolButton.Hint := '';
  end;
end;

procedure TMainForm.AddressToolBarResize(Sender: TObject);
begin
  // ŃTCYĂȂ̂
  UrlEdit.Width := AddressToolBar.Width;
end;

procedure TMainForm.N1Click(Sender: TObject);
begin
  if UrlEdit.Text <> '' then
  begin
    OpenBrowser(UrlEdit.Text);
  end;
end;

procedure TMainForm.URL3Click(Sender: TObject);
begin
  if UrlEdit.Text <> '' then
  begin
    Clipboard.AsText := UrlEdit.Text;
  end;
end;

procedure TMainForm.ChangeTopicListViewColumnPadding;
var
  i, newImageHeight, defaultImageHeight: Integer;
  image, mask, tmpImage: TBitMap;

begin

  // C[WXg쐬
  defaultImageHeight := TopicListViewImageList.Height;
  newImageHeight     := defaultImageHeight + gConfig.TopicListViewColumnPadding;

  if Assigned(FImageList) then
  begin
    FImageList.Free;
  end;
  FImageList := TImageList.CreateSize(defaultImageHeight, newImageHeight);

  for i := 0 to TopicListViewImageList.Count - 1 do
  begin
    image    := TBitMap.Create;
    mask     := TBitMap.Create;
    tmpImage := TBitMap.Create;

    TopicListViewImageList.GetBitmap(i, tmpImage);

    image.Width     := defaultImageHeight;
    image.Height    := newImageHeight;
    mask.Width      := image.Width;
    mask.Height     := image.Height;
    tmpImage.Width  := image.Width;
    tmpImage.Height := image.Height;

    image.Canvas.Brush.Color := tmpImage.Canvas.Pixels[0,0];
    image.Canvas.FillRect(Rect(0,0,defaultImageHeight, newImageHeight));
    image.Canvas.Draw(0, gConfig.TopicListViewColumnPadding div 2, TmpImage);

    mask.Canvas.Draw(0, 0, Image);
    mask.Mask(mask.Canvas.Pixels[0,0]);

    FImageList.Add(image, mask);

    image.Free;
    mask.Free;
    tmpImage.Free;
  end;

  if TopicListView.SmallImages <> nil then
  begin
    TopicListView.SmallImages.Free;
  end;

  TopicListView.SmallImages := FImageList;
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
var
  logSweeper: TLogSweeper;

begin
  try
    CloseTabToolButtonClick(CloseAllMenuItem);
    if FSelectedBoard is TOfflineBoard then
    begin
      (FSelectedBoard as TOfflineBoard).Save;
    end;
    FBoardList.Save;

    if gConfig.DoLogClear then
    begin
      logSweeper := TLogSweeper.Create;
      try
        with logSweeper do
        begin
          BoardList := FBoardList;
          LogLimitSize := gConfig.LogLimitSize;
          FreeOnTerminate := false;
          Resume;
          WaitFor;
        end;
      finally
        logSweeper.Free;
      end;
    end;
  except on e: Exception do
    Showmessage(e.Message);
  end;
end;

procedure TMainForm.LogSaveModeToolButtonClick(Sender: TObject);
begin
  gConfig.DoLogSave := LogSaveModeToolButton.Down;
  SaveTopicToolButton.Visible := not LogSaveModeToolButton.Down;
end;

procedure TMainForm.SaveTopicToolButtonClick(Sender: TObject);
var
  activeTab: TTopicBrowser;

begin
  activeTab := GetActiveTab;
  if Assigned(activeTab) and Assigned(activeTab.Topic) then
  begin
    activeTab.Topic.SaveIdx;
    activeTab.Topic.SaveDat;
  end;
end;

procedure TMainForm.TopPanelClick(Sender: TObject);
begin
  Animate1.Active := not Animate1.Active;
end;


end.

