unit unt2chUrlParser;

{ 2ch url ̓jbg }

interface

uses
  Classes, SysUtils, StrUtils,
  untTool;

type

  T2chUrlParser = class
  private
    FIs2chUrl: boolean;
    FArticleNo: string;
    FHost:      string;
    FBoardName: string;
    FTopicId:   string;
  public
    property Is2chUrl: boolean read FIs2chUrl;
    property Host:      string read FHost;
    property BoardName: string read FBoardName;
    property TopicId:   string read FTopicId;
    constructor Create(URI: string);
  end;

implementation

{ T2chUrlParser }

{ --------------------------------------------------------
  ֐: Create
  pr  : RXgN^
    : URI - ͑ΏۂURI
  ߂l: Ȃ
  l  : OpenJaneR[hq؂܂B
  ------------------------------------------------------ }
constructor T2chUrlParser.Create(URI: string);

  function GetMulti(startPos, endPos: integer; strList: TStringList): string;
  var
    i: integer;
  begin
    result := '';
    for i := startPos to endPos do
    begin
      if 0 < length(result) then
        result := result + '/';
      result := result + strList.Strings[i];
    end;
  end;

var
  strList, tmp: TStringList;
  i: integer;
  host : string;
  bbs  : string;
  datnum : string;
  index  : string;

begin
  host := '';
  bbs := '';
  datnum := '';
  index := '';
  strList := TStringList.Create;
  strList.Delimiter := '/';
  strList.DelimitedText := URI;

  (* sample format *)
  (* http://server.2ch.net/bbs/ *)
  (* http://server.2ch.net/test/read.cgi/bbs/?opt  *)
  (* http://server.2ch.net/test/read.cgi/bbs/dat/opt  *)
  (* http://server.2ch.net/bbs/dat/nnn.dat  *)
  (* http://server.2ch.net/bbs/kako/nnn/dat.html  *)
  (* http://server.2ch.net/bbs/kako/nnn/nnnn/dat.html  *)
  (* http://server.2ch.net/test/read.cgi?bbs=bbs&key=dat  *)
  (* http://server.2ch.net/sub/bbs/kako/nnn/dat.html  *)
  (* http://server.2ch.net/sub/test/read.cgi?bbs=bbs&key=dat  *)

  for i := 4 to strList.Count -1 do
  begin
    if strList.Strings[i] = 'kako' then
    begin
      bbs := strList.Strings[i -1];
      host := GetMulti(2, i - 2, strList);
      datnum := ChangeFileExt(strList.Strings[strList.Count -1], '');
      break;
    end
    else if strList.Strings[i] = 'read.cgi' then
    begin
      host := GetMulti(2, i - 2, strList);
      if i + 1 <= strList.Count -1 then
      begin
        bbs := strList.Strings[i + 1];
        if (i + 2 <= strList.Count -1) and
           (not AnsiStartsStr('?', strList.Strings[i + 2])) then
        begin
          datnum := strList.Strings[i + 2];
          if (i + 3 <= strList.Count -1) then
            index := strList.Strings[i+3];
        end;
      end;
      break;
    end
    else if AnsiStartsStr('read.cgi?', strList.Strings[i]) or
            AnsiStartsStr('read.pl?', strList.Strings[i]) then
    begin
      host := GetMulti(2, i - 2, strList);
      tmp := TStringList.Create;
      tmp.Delimiter := '?';
      tmp.DelimitedText := strList.Strings[i];
      if 1 < tmp.Count then
      begin
        tmp.Delimiter := '&';
        tmp.DelimitedText := tmp.Strings[1];
        tmp.Delimiter := '=';
        bbs  := tmp.Values['bbs'];
        if length(bbs) <= 0 then
          bbs := tmp.Values['ampbbs'];
        datnum := tmp.Values['key'];
        if length(datnum) <= 0 then
          datnum := tmp.Values['ampkey'];
      end;
      tmp.Free;
    end;
  end;
  if (length(host) <= 0) and (5 <= strList.Count) then
  begin
    bbs := strList.Strings[strList.Count -2];
    host := GetMulti(2, strList.Count -3, strList);
  end;
  strList.Free;

  FHost      := host;
  FBoardname := bbs;
  FTopicId   := datnum;
  FArticleNo := index;

  if (FHost <> '') and (FBoardname <> '') then
    FIs2chUrl  := true
  else
    FIs2chUrl  := false;

end;

end.
