unit UTVSub;
(* Copyright (c) 2002 Twiddle <hetareprog@hotmail.com> *)
(* b胆jbgH *)

interface

uses
  Classes,
  Controls,
  Types,
  SysUtils,
  Forms,
  HogeTextView,
  UPtrStream,
  UDat2HTML,
  UXMLSub;

function TVMouseProc(Sender: THogeTextView; Shift: TShiftState;
                     X, Y: Integer): string;
var
  point: TPoint;
  view: THogeTextView;
  item: THogeTVItem;
  index: integer;
  newCursor: TCursor;
begin
  result := '';
  view := THogeTextView(Sender);
  point := view.ClientToPhysicalCharPos(X, Y);
  newCursor := crDefault;
  if 0 <= point.X then
  begin
    newCursor := crIBeam;
    item := view.Strings[point.Y];
    index := point.X +1;
    with THogeTextView(Sender) do
    begin
      if InSelection(point.X, point.Y) then
      begin
        if Cursor <> crDefault then
          Cursor := crDefault;
        exit;
      end;
    end;
    result := item.GetEmbed(index);
    if 0 < length(result) then
      newCursor := crHandPoint;
  end;
  with THogeTextView(Sender) do
    if Cursor <> newCursor then
      Cursor := newCursor;
end;

end.
