unit untAllSubscribedTopics;

interface

uses
  Classes,
  untOfflineBoard, untTopic;

type
  TAllSubscribedTopics = class(TOfflineBoard)
  private
    FThread: TThread;
  protected
    procedure SendTopicListComplete(Sender: TObject);
  public
    procedure AppendTopic(Topic: TTopic); override;
    procedure RemoveTopic(Topic: TTopic); override;
    constructor Create;
    procedure Stop;
    procedure SendTopicList; override;
    procedure Save; override;
    procedure FreeAllTopic; override;
  end;

implementation

uses
  untTool, untAllSubscribedTopicsLoadThread, untBoard, untOnlineBoard;

procedure TAllSubscribedTopics.FreeAllTopic;
var
  i: integer;
  tp: TTopic;
begin

  for i := 0 to TopicList.Count - 1 do
  begin
    tp := TopicList[i];
    (tp.OnlineBoard as TOnlineBoard).FreeTopic(tp);
  end;
  TopicList.Clear;
end;

constructor TAllSubscribedTopics.Create;
begin
  inherited Create(AppPath('g܂'));
end;

procedure TAllSubscribedTopics.SendTopicList;
begin
  TopicList.Clear;

  State := stDownloading;
  FThread := TAllSubscribedTopicsLoadThread.Create(true);
  with FThread as TAllSubscribedTopicsLoadThread do
  begin
    FreeOnTerminate := false;
    OnTerminate := SendTopicListComplete;
    Board := self;
    Resume;
    WaitFor;
    Free;
  end;
end;

procedure TAllSubscribedTopics.SendTopicListComplete(Sender: TObject);
begin
  if Assigned(OnReceived) then
  begin
    OnReceived(self);
  end;
  if Assigned(OnComplete) then
  begin
    OnComplete(self);
  end;
  State := stIdling;
end;

procedure TAllSubscribedTopics.Stop;
begin
  if State <> stIdling then
  begin
    FThread.Terminate;
  end;
end;

procedure TAllSubscribedTopics.AppendTopic(Topic: TTopic);
begin
  TopicList.Add(Topic);
end;

procedure TAllSubscribedTopics.RemoveTopic(Topic: TTopic);
var
  i: integer;

begin
  for i := 0 to TopicList.Count - 1 do
  begin
    // DATgsbŃAXgɊ܂܂ĂIuWFNgƂ
    // ʂȂ̂TopicIdŔrȂΏȂ
    if TTopic(TopicList[i]).TopicId = Topic.TopicId then
    begin
      TopicList.Delete(i);
      break;
    end;
  end;
end;

procedure TAllSubscribedTopics.Save;
begin
  // S̓t@CɕۑȂ
end;

end.
 