unit untBoard;

interface

uses
  Classes, 
  untTopic, untGlobal;

type
  TBoardState = (stIdling, stDownLoading, stArrivalChecking);

  TBoard = class
  private
    FState: TBoardState;
  protected
    function ReadIsDownloading: boolean;
    procedure WriteState(const s: TBoardState); virtual;
    property State: TBoardState read FState write WriteState;
  public
    BoardList: TObject;
    TopicList: TList;
    OnReceived: TNotifyEvent;
    OnError: TFrameworkError;
    OnComplete: TNotifyEvent;
    Category: TObject;
		DisplayName: string;
    ReceivedIndex: integer;
    constructor Create;
    destructor Destroy; override;
    procedure SendTopicList; virtual;
    procedure FreeAllTopic; virtual; abstract;
    property IsDownloading: boolean read ReadIsDownloading;
  end;

implementation

uses
  untBoardList;

procedure TBoard.WriteState(const s: TBoardState);

  procedure StateError;
  begin
    if Assigned(OnError) then
    begin
      OnError(self, etBoardState, 'ԃG[');
    end;
  end;

begin
  if (s = stDownloading) or (s = stArrivalChecking) then
  begin
    if FState = stIdling then
    begin
      FState := s;
    end else
    begin
      StateError;
    end;
  end else
  begin
    FState := s;
  end;
end;

function TBoard.ReadIsDownloading: boolean;
begin
  if State = stDownloading then
  begin
    result := true;
  end else
  begin
    result := false;
  end;
end;


procedure TBoard.SendTopicList;
begin
  State := stDownLoading;
  ReceivedIndex := 0;  
end;

constructor TBoard.Create;
begin
  inherited;

  TopicList := TList.Create;
end;

destructor TBoard.Destroy;
begin
  TopicList.Free;

  inherited;
end;

end.
