unit untBoard2ch;

interface

uses
  untOnlineBoard, IdComponent, untTopic, untTopicBrowser;

type
  TBoard2ch = class(TOnlineBoard)
  private
    FTopicBrowser: TTopicBrowser;
    FLastModified: string;
  protected
    procedure TopicComplete(Sender: TObject);
    procedure HttpReceived(Sender: TObject); override;
    procedure HttpComplete(Sender: TObject); override;
  public
    procedure SendTopicList; override;
    procedure DownloadTopic(Topic: TTopic; Sender: TObject); override;
    function HasTopicListChange: boolean;
  end;

implementation

uses
  untTopic2ch, untGlobal, untTopic2chKako, untBoard,
  untHttp, untConfig, untTopic2chDolib;

function TBoard2ch.HasTopicListChange: boolean;
begin
  if FLastModified = '' then
  begin
    result := true;
    exit;
  end;
  State := stArrivalChecking;
  FHttp := TAsyncHttp.Create;
  FHttp.UserAgent := gConfig.UserAgent;
  FHttp.AddHeader('X-2ch-UA', APP_2chUA);
  gConfig.InitReadProxy(FHttp);
  FHttp.URL := 'http://' + Server + '/' + BoardName + '/subject.txt';
  FHttp.OnStatus := HttpStatusChange;
  FHttp.Head;
  result := false;
  if FHttp.LastModified <> FLastModified then
  begin
    result := true;
  end;
  FHttp.Free;
  State := stIdling;
end;

procedure TBoard2ch.TopicComplete(Sender: TObject);
var
  ti: string;
  tp: TTopic;

begin
  if not Assigned(FTopicBrowser) then
  begin
    exit;
  end;
  
  tp := FTopicBrowser.Topic;
  // ʐMJn
  if (tp.ResponseCode = 416) or
     (tp.ErrorCode = etAbone) or
     (tp.ErrorCode = etParse) or
     (tp.ErrorCode = etBrokenGZip) then
  begin
    // W[sȂŏŃgC
    // ځ[񂩉̓G[gzipĂȂ烊gC
    tp.Retry;
  end;

  if tp is TTopic2chKako then
  begin
    if (gConfig.SessionId <> '') and not TTopic2chKako(tp).IsExist then
    begin
      ti := tp.TopicId;
      FreeTopic(tp);
      GC;
      tp := TTopic2chDolib.Create(self, ti);
      FTopicCache.Add(tp);      
      TopicList.Add(tp);
      tp.OnComplete := TopicComplete;
      inherited DownloadTopic(tp, FTopicBrowser);
    end;
  end else if tp is TTopic2ch then
  begin
    if TTopic2ch(tp).IsFreezed then
    begin
      // DAT
      ti := tp.TopicId;
      FreeTopic(tp);
      GC;
      tp := TTopic2chKako.Create(self, ti);
      FTopicCache.Add(tp);
      TopicList.Add(tp);
      tp.OnComplete := TopicComplete;
      inherited DownloadTopic(tp, FTopicBrowser);
    end;
  end;
  FTopicBrowser.Topic_Complete(self);
end;

procedure TBoard2ch.DownloadTopic(Topic: TTopic; Sender: TObject);
begin
  if Sender is TTopicBrowser then
  begin
    FTopicBrowser := TTopicBrowser(Sender);
    Topic.OnComplete := TopicComplete;
  end else
  begin
    FTopicBrowser := nil;
  end;
  inherited;
end;

procedure TBoard2ch.SendTopicList;
begin
  inherited;

  FHttp.UseGzip := true;

  FHttp.OnReceived := HttpReceived;
  FHttp.OnTerminate := HttpComplete;

  FHttp.URL := 'http://' + Server + '/' + BoardName + '/subject.txt';
  FHttp.Resume;
end;

procedure TBoard2ch.HttpComplete(Sender: TObject);
begin
  FLastModified := FHttp.LastModified;
  inherited;
end;

procedure TBoard2ch.HttpReceived(Sender: TObject);
begin
  inherited HttpReceivedProc('^(.+?)\.dat<>(.*)\s?\((.+?)\)$');
end;

end.
