unit untBoardJBBS;

interface

uses
  untOnlineBoard, IdComponent, untTopic;

type
  TBoardJBBS = class(TOnlineBoard)
  protected
    procedure HttpReceived(Sender: TObject); override;
    procedure HttpComplete(Sender: TObject); override;
  public
    procedure DownloadTopic(Topic: TTopic; sender: TObject); override;
    procedure SendTopicList; override;
  end;

implementation

uses
  untTopicJBBS, untBoard, untTopicBrowser;
  
procedure TBoardJBBS.HttpReceived(Sender: TObject);
begin
  inherited HttpReceivedProc('^(.+?)\.cgi,(.*)\((.+)\)$');
end;

procedure TBoardJBBS.DownloadTopic(Topic: TTopic; sender: TObject);
begin
  if Sender is TTopicBrowser then
  begin
    Topic.OnComplete := TTopicBrowser(Sender).Topic_Complete;
  end;
  inherited;
end;

procedure TBoardJBBS.HttpComplete(Sender: TObject);
begin
  inherited;
end;

procedure TBoardJBBS.SendTopicList;
begin
  inherited;

  FHttp.OnReceived := HttpReceived;
  FHttp.OnTerminate := HttpComplete;
  FHttp.URL := 'http://' + Server + '/' + BoardName + '/subject.txt';
  FHttp.Resume;
end;

end.
