unit untBoardList;

interface

uses
  Classes, IdComponent, Contnrs,
  untOnlineBoard, untHttp, untMyFolder, untLostBoard;

type

  TBoardList = class
  private
    FCategoryCache: TObjectList;
  protected
    FServer: string;
    procedure SetCategoryColor;
    function ReadMyFolder: TMyFolder;
    function ReadLostBoard: TLostBoard;    
  public
    Categorys: TList;
    constructor Create;
    destructor  Destroy; override;
    property MyFolder: TMyFolder read ReadMyFolder;
    property LostBoard: TLostBoard read ReadLostBoard;
    function GetBoard(const Server, BoardName: string): TOnlineBoard;
    function GetRealNameForTopicPath(AliasName: string): string;
    procedure GC;
    procedure OpenAll;
    procedure CloseAll;
    procedure Init;
    procedure Save;
    procedure UpdateBoard(const BoardListHtml: string);
  end;

implementation

uses
  SysUtils, Graphics, Windows, RegExpr,
  untTool,  untGlobal, untBoardCategory, untOfflineBoard, untBoard;

{ TBoardList }

//  \bh 


procedure TBoardList.OpenAll;
var
  i: integer;

begin
  for i := 0 to Categorys.Count - 1 do
  begin
    TBoardCategory(Categorys[i]).Opened := true;
  end;
end;

procedure TBoardList.CloseAll;
var
  i: integer;

begin
  for i := 0 to Categorys.Count - 1 do
  begin
    TBoardCategory(Categorys[i]).Opened := false;
  end;
end;

procedure TBoardList.GC;
var
  i, j: integer;
  c: TBoardCategory;

begin
  for i := 1 to FCategoryCache.Count - 1 do
  begin
    c := (FCategoryCache[i] as TBoardCategory);
    for j := 0 to c.Boards.Count - 1 do
    begin
      TOnlineBoard(c.Boards[j]).GC;
    end;
  end;
end;

function TBoardList.ReadMyFolder: TMyFolder;
begin
  result := (FCategoryCache[0] as TMyFolder);
end;

function TBoardList.ReadLostBoard: TLostBoard;
begin
  result := (FCategoryCache[1] as TLostBoard);
end;

procedure TBoardList.Init;
var
  boardFile: TStringList;
  boardItems: TStringArray;
  i, rs:  integer;
  c: TBoardCategory;
  myFolder: TMyFolder;
  lostBoard: TLostBoard;
  sr: TSearchRec;
  favBoard: TBoard;

begin
  SetLength(boardItems, 0);
  c := nil;

  // {[ht@Cǂݍ
  boardFile := TStringList.Create;
  if FileExists(AppPath('2channel.brd')) then
  begin
    boardFile.LoadFromFile(AppPath('2channel.brd'));
  end;

  for i := 0 to boardFile.Count - 1 do
  begin
    boardItems := Split(boardFile[i], #9, 4);
    if boardItems[0] <> '' then
    begin
      // JeStB[h
      c := TBoardCategory.Create(self);
      c.CategoryName := boardItems[0];
      FCategoryCache.Add(c);
      Categorys.Add(c);

      if boardItems[1] <> '0' then
      begin
        c.Opened := true;
      end;
    end else
    begin
      // tB[h
      c.AddBoard(boardItems[1], boardItems[2], boardItems[3]);
    end;
  end;
  boardFile.Free;

  // }CtH_擪
  myFolder := TMyFolder.Create(self);
  myFolder.CategoryName := '}CtH_';
  myFolder.Opened := true;
  Categorys.Insert(0, myFolder);
  FCategoryCache.Insert(0, myFolder);

	// Cɓǂݍ
  favBoard := myFolder.AddBoard(AppPath('favorite.idx'), '}CtH_', 'Cɓ');
  myFolder.FavoriteBoard := favBoard as TOfflineBoard;

	// Xbhqɂǂݍ
  rs := FindFirst(AppPath('*.idx'), faAnyFile, sr);
  try
    while rs = 0 do
    begin
      if (sr.Name <> 'favorite.idx') and
         (sr.Name <> 'favboard.idx') then
      begin
        myFolder.AddBoard(AppPath(sr.Name), '}CtH_', ChangeFileExt(sr.Name, ''));
      end;
      rs := FindNext(sr);
    end;
  finally
    SysUtils.FindClose(sr);
  end;
  myFolder.AddBoard('', '}CtH_', 'SX');

  lostBoard := TLostBoard.Create(self);
  lostBoard.CategoryName := 'q';
  lostBoard.Opened := true;
  FCategoryCache.Insert(1, lostBoard);
  // q͕\Ȃ
  //Categorys.Insert(1, LostBoard);

  SetCategoryColor;
end;

{ --------------------------------------------------------
  pr  : RXgN^
  l  : Ȃ
  ------------------------------------------------------ }
constructor TBoardList.Create;
begin
  inherited;

  Categorys := TList.Create;
  FCategoryCache := TObjectList.Create;
end;

{ --------------------------------------------------------
  pr  : fXgN^
  l  : Ȃ
  ------------------------------------------------------ }
destructor TBoardList.Destroy;
begin
  Categorys.Free;
  FCategoryCache.Clear;
  FCategoryCache.Free;

  inherited;
end;

function TBoardList.GetRealNameForTopicPath(AliasName: string): string;
begin
  result := AliasName;
end;

function TBoardList.GetBoard(const Server, BoardName: string): TOnlineBoard;
var
  i: integer;
  c: TBoardCategory;
  b: TOnlineBoard;

begin
  result := nil;
  for i := 1 to Categorys.Count - 1 do
  begin
    c := TBoardCategory(Categorys[i]);
    b := c.GetBoard(Server, BoardName);
    if Assigned(b) then
    begin
      result := b;
      break;
    end;
  end;
  if not Assigned(result) then
  begin
    result := LostBoard.AddBoard(Server, BoardName, 'q');
  end;
end;

// {[hXV
procedure TBoardList.UpdateBoard(const BoardListHtml: string);
var
  regEx, regExLink: TRegExpr;
  match, linkMatch: boolean;
  server, boardName, displayName, categoryName, buf: string;
  i, j, k: integer;
  offlineBoard: TOfflineBoard;
  onlineBoard: TOnlineBoard;
  c: TBoardCategory;
  categoryList: TObjectList;
  s: TStringList;

begin
  regEx     := TRegExpr.Create;
  regExLink := TRegExpr.Create;
  categoryList := TObjectList.Create;

  regEx.Expression := '<BR><BR><B>(.+?)</B>(.+?)\n\n';

  match := regEx.Exec(BoardListHtml);
  while match do
  begin
    categoryName := regEx.Substitute('$1');

    if (categoryName = 'ʊ') or
       (categoryName = 'c[') then
    begin
      match := Regex.ExecNext;
      continue;
    end;

    s := TStringList.Create;
    s.Add(categoryName);

    if categoryName = '܂aar' then
    begin
      regExLink.Expression := '<A HREF=http://([^ /]+?)/([^ /]+?)/ TARGET=_blank>(.+?)</A>'
    end else
    begin
      regExLink.Expression := '<A HREF=http://([^ ]+?)/([^ ]+?)/>([^<>]+?)</A>';
    end;

    buf := regEx.Substitute('$2');
    linkMatch := regExLink.Exec(buf);
    while linkMatch do
    begin
      server      := regExLink.Substitute('$1');
      boardName   := regExLink.Substitute('$2');
      displayName := regExLink.Substitute('$3');
      s.Add(server);
      s.Add(boardName);
      s.Add(displayName);
      linkMatch := RegexLink.ExecNext;
    end;
    categoryList.Add(s);
    match := regEx.ExecNext;
  end;
  regEx.Free;
  regExLink.Free;

  Categorys.Clear;
  for i := 0 to categoryList.Count - 1 do
  begin
    // łɂJeS[
    s := (categoryList[i] as TStringList);
    categoryName := s[0];
    c := nil;
    for j := 1 to FCategoryCache.Count - 1 do
    begin
      if TBoardCategory(FCategoryCache[j]).CategoryName = categoryName then
      begin
        c := TBoardCategory(FCategoryCache[j]);
        break;
      end;
    end;
    if c = nil then
    begin
      c := TBoardCategory.Create(self);
      c.CategoryName := categoryName;
      c.Opened := true;
      FCategoryCache.Add(c);
    end;
    Categorys.Add(c);

    j := 1;
    c.Boards.Clear;
    while j < s.Count - 1 do
    begin
      server      := s[j];
      boardName   := s[j + 1];
      displayName := s[j + 2];
      j := j + 3;

      onlineBoard := c.GetBoard(server, boardName);
      if Assigned(onlineBoard) then
      begin
        // ̎IύX
        if onlineBoard.Server <> server then
        begin
          // GCAX̒ǉ
          gFolderAlias.AddAlias(boardName, displayName, onlineBoard.Server);
          gFolderAlias.AddAlias(boardName, displayName, server);

          // qɂۑ
          for k := 0 to MyFolder.Boards.Count - 1 do
          begin
            if TBoard(MyFolder.Boards[k]) is TOfflineBoard then
            begin
              offlineBoard := TOfflineBoard(MyFolder.Boards[k]);
              offlineBoard.Save;
            end;
          end;
        end;
        onlineBoard.Server := server;
        onlineboard.DisplayName := displayName;
        c.Boards.Add(onlineBoard);
      end else
      begin
        // Ȃǉ
        c.AddBoard(server, boardName, displayName);
      end;
    end;
  end;
  categoryList.Clear;
  categoryList.Free;

  Categorys.Insert(0, MyFolder);
  // q͕\Ȃ
  //Categorys.Insert(1, LostBoard);

  SetCategoryColor;

  // ۑ
  Save;
  gFolderAlias.Save;
end;

// {[hXgۑ
procedure TBoardList.Save;
var
  boardFile: TStringList;
  i, j: integer;
  category: TBoardCategory;
  opened: string;
  board: TOnlineBoard;

begin
  boardFile := TStringList.Create;

  for i := 1 to Categorys.Count - 1 do
  begin
    category := TBoardCategory(Categorys[i]);

    if category.Opened then
    begin
      opened := '1'
    end else
    begin
      opened := '0';
    end;
    boardFile.Add(category.CategoryName + #9 + opened);

    for j := 0 to category.Boards.Count - 1 do
    begin
      board := TOnlineBoard(category.Boards[j]);
      boardFile.Add(#9 + board.Server +
                    #9 + board.BoardName +
                    #9 + board.DisplayName);
    end;
  end;

  boardFile.SaveToFile(AppPath('2channel.brd'));
  boardFile.Free;
end;

procedure TBoardList.SetCategoryColor;
var
  i: integer;
  category: TBoardCategory;
  colorCycle: integer;
  color: TColor;

begin
  ColorCycle := 0;

  for i := 0 to Categorys.Count - 1 do
  begin
    category := TBoardCategory(Categorys[i]);

    // F
    Inc(ColorCycle);
    if ColorCycle > 33 then
    begin
      ColorCycle := 1;
    end;
    
    case ColorCycle of
      1:  Color := Rgb( 255, 255, 255 );
      2:  Color := Rgb( 152,  90,  98 );
      3:  Color := Rgb( 221, 255, 221 );
      4:  Color := Rgb( 255, 215, 255 );
      5:  Color := Rgb(  81, 157, 176 );
      6:  Color := Rgb( 215, 215, 255 );
      7:  Color := Rgb(   0, 128, 128 );
      8:  Color := Rgb( 255,   0,   0 );
      9:  Color := Rgb( 186, 160,  71 );
      10: Color := Rgb( 255, 134, 134 );
      11: Color := Rgb( 194, 177, 186 );
      12: Color := Rgb( 139,  63, 120 );
      13: Color := Rgb( 169, 186,  50 );
      14: Color := Rgb( 160, 150, 222 );
      15: Color := Rgb( 211, 196, 141 );
      16: Color := Rgb( 255,   0, 255 );
      17: Color := Rgb( 255, 255,   0 );
      18: Color := Rgb( 143, 140, 145 );
      19: Color := Rgb( 255, 162, 255 );
      20: Color := Rgb(   0,   0, 255 );
      21: Color := Rgb( 208,  34, 196 );
      22: Color := Rgb( 179, 255, 179 );
      23: Color := Rgb(  55, 230, 217 );
      24: Color := Rgb( 149, 149, 255 );
      25: Color := Rgb(  91,  48, 194 );
      26: Color := Rgb( 200, 241, 255 );
      27: Color := Rgb(   0, 255,   0 );
      28: Color := Rgb( 40,  202, 255 );
      29: Color := Rgb( 255, 255, 210 );
      30: Color := Rgb( 255, 208, 208 );
      31: Color := Rgb(   0, 140, 187 );
      32: Color := Rgb( 234, 138, 172 );
      else Color := Rgb(   0,   0,   0 );
    end;
    category.Color := Color;
  end;
end;


end.
