unit untDolibLogin;

// O[oϐ܂B

interface

uses
  Dialogs,
  Dolib,
  untLoginForm;

type
  TDolibLogin = class
  public
    SessionId: string;
    UserAgent: string;
    function    Login(): boolean;
    constructor Create;
    destructor  Destroy; override;
  end;

implementation

uses
  untGlobal, untConfig;

{ TDolibLogin }

constructor TDolibLogin.Create;
begin
  inherited;
end;

destructor TDolibLogin.Destroy;
begin

  inherited;
end;

// OC
function TDolibLogin.Login: boolean;
var
  login: TDolib;
  errorMsg: string;
  errorCode: integer;

begin
  result := false;

  login := TDolib.Create;
  login.UserName := gConfig.UserId;
  login.Password := gConfig.Password;
  login.ClientUA := APP_2chUA;

  {
  if gConfig.ReadProxyUse then
  begin
    gConfig.ParseProxy(gConfig.ReadProxy, proxyhost, proxyport);
    Login.ProxyAddress := proxyhost;
    Login.ProxyPort    := proxyport;
  end;
  }

  if (not login.Connect) then
  begin
    ShowMessage(login.ErrorMsg);
  end else
  begin
    SessionId := login.SessionID;
    UserAgent := login.UserAgent;
    errorMsg  := login.ErrorMsg;
    errorCode := login.ErrorCode;
    if errorCode <> 0 then
    begin
      ShowMessage(login.ErrorMsg)
    end else
    begin
      result := true;
    end;
    login.Disconnect;
  end;
  login.Free;

  if SessionId <> '' then
  begin
    gConfig.SessionId := SessionId;
  end;
  if userAgent <> '' then
  begin
    gConfig.UserAgent := UserAgent;
  end;
end;

end.
