unit untOfflineBoard;

interface

uses
  Classes,
  untBoard, untTopic;

type
  TOfflineBoard = class(TBoard)
  private
    FIdxPath: string;
    FLoadedLog: Boolean;
  protected
    procedure LoadIdx;
    procedure SaveToLog;
  public
    constructor Create(const idxPath: string);
    procedure SendTopicList; override;
    procedure AppendTopic(Topic: TTopic); virtual;
    procedure RemoveTopic(Topic: TTopic); virtual;
    procedure Save; virtual;
    procedure Patrol(Sender: TObject);
    function  IsHave(Topic: TTopic) : boolean;
    procedure Sort(Compare: TListSortCompare);
    procedure FreeAllTopic; override;
  end;

implementation

uses
  RegExpr, SysUtils,
  untOnlineBoard, untBoardList, untBoardCategory;

procedure TOfflineBoard.FreeAllTopic;
begin
  // gsbN̉̓IC{[hs
end;

constructor TOfflineBoard.Create(const idxPath: string);
begin
  inherited Create;

  FIdxPath := idxPath;
end;

procedure TOfflineBoard.SendTopicList;
begin
  inherited;

  FLoadedLog := false;
  TopicList.Clear;
  LoadIdx;
  if Assigned(OnReceived) then
  begin
    OnReceived(self);
  end;
  if Assigned(OnComplete) then
  begin
    OnComplete(self);
  end;
  State := stIdling;  
end;

procedure TOfflineBoard.AppendTopic(Topic: TTopic);
begin
  TopicList.Insert(0, Topic);
  Topic.IsInBox := true;
  Topic.SaveIdx;
  SaveToLog;
end;

procedure TOfflineBoard.RemoveTopic(Topic: TTopic);
var
  i: integer;

begin
  for i := 0 to TopicList.Count - 1 do
  begin
    // DATgsbŃAXgɊ܂܂ĂIuWFNgƂ
    // ʂȂ̂TopicIdŔrȂΏȂ
    if TTopic(TopicList[i]).TopicId = Topic.TopicId then
    begin
      TopicList.Delete(i);
      break;
    end;
  end;
  SaveToLog;
end;

procedure TOfflineBoard.Patrol(Sender: TObject);
var
  i: Integer;
  topic: TTopic;

begin
  for i := 0 to TopicList.Count - 1 do
  begin
    topic := TTopic(TopicList[i]);
    if topic.NewMessageCount = 0 then
    begin
      topic.OnComplete := OnComplete;
      topic.FreeMessage;
      //*: Ń^u̐V}[N͂
      //Ȃ΂ȂȂBۗB
      topic.Download;
    end;
  end;
end;

procedure TOfflineBoard.LoadIdx;
var
  stlLog: TStringList;
  topic: TTopic;
  i: Integer;
  regex: TRegExpr;
  server, boardName, topicId: string;
  board: TOnlineBoard;

begin
  regex := TRegExpr.Create;
  try
    regex.Expression := '^(.+?)\\(.+?)\\(.+?)\.idx';

    if FLoadedLog = false then
    begin
      if FileExists(FIdxPath) then
      begin
        stlLog := TStringList.Create;
        stlLog.LoadFromFile(FIdxPath);

        // gsbN̓ǂݍ
        for i := 0 to stlLog.Count - 1 do
        begin
          if (stlLog[i] <> '') and (Regex.Exec(stlLog[i])) then
          begin
            server    := Regex.Substitute('$1');
            boardName := Regex.Substitute('$2');
            topicId   := Regex.Substitute('$3');

            board := (BoardList as TBoardList).GetBoard(server, boardName);
            topic := board.GetTopic(topicId);
            topic.IsInBox := true;
            topic.Index := i + 1;
            topic.OnlineBoard := board;
            TopicList.Add(topic);
          end;
        end;
        stlLog.Free;
      end;
      FLoadedLog := true;
    end;
  finally
    regex.Free;
  end;
end;

procedure TOfflineBoard.Save;
begin
  if TopicList.Count = 0 then
  begin
    exit;
  end;
  SaveToLog;
end;

procedure TOfflineBoard.SaveToLog;
var
  i: Integer;
  topic: TTopic;
  stlSave: TStringList;
  board: TOnlineBoard;

begin
  stlSave := TStringList.Create;
  try
    for i := 0 to TopicList.Count - 1 do
    begin
      topic := TTopic(TopicList[i]);
      board := topic.OnlineBoard as TOnlineBoard;
      stlSave.Add(board.Server + '\' + board.BoardName + '\' + topic.TopicId + '.idx');
    end;
    stlSave.SaveToFile(FIdxPath);
  finally
    stlSave.Free;
  end;
end;

function TOfflineBoard.IsHave(Topic: TTopic): boolean;
begin
  if TopicList.IndexOf(Topic) > -1 then
  begin
    result := true
  end else
  begin
    result := false;
  end;
end;

procedure TOfflineBoard.Sort(Compare: TListSortCompare);
begin
  TopicList.Sort(Compare);
end;

end.
