unit untTopic;

interface

uses
  SysUtils, Classes, Contnrs,
  SyncObjs, RegExpr, IdHttp, IdComponent,
  untStreamTool, untGlobal, untHttp;

type
  TTopicMessage = class
  private
    function GetForPopup: string;
  public
    Index: Integer;
    Body:      string;
    PostName:  string;
		PostEmail: string;
    RestStr:   string;
    IsNewMessage: Boolean;
    property ForPopup: string read GetForPopup;
  end;

  TTopicState = (dsNone, dsStarting, dsProcessing, dsDatLoaded,
                 dsError, dsFreezed, dsComplete);

  TTopic = class
  private
    FLogLoaded: boolean;
    FNoBrowser: boolean;
    FRetryed:   boolean;
    FMessageList: TList;
    FErrorCode: TFrameworkErrorType;
    FState: TTopicState;
  protected
    FURL: string;
    FHttp: TAsyncHttp;
    FPostHttp: TIdHttp;
    function GetTopicURL: string; virtual; abstract;
    function GetBrowserUrl: string; virtual; abstract;
    function ParseDat(const line: string; var aTitle: string): TTopicMessage;
    procedure RaiseError(const ErrorCode: TFrameworkErrorType); overload;
    procedure RaiseError(ErrorCode: TFrameworkErrorType;
                         ErrorString: string); overload;
    procedure HttpReceived(Sender: TObject); virtual;
    procedure HttpComplete(Sender: TObject); virtual;
    procedure HttpStatusChange(axSender: TObject;
                               const axStatus: TIdStatus;
                               const asStatusText: string);

    procedure SendTopic; virtual;
    procedure ChangeStatusText(const NewText: string);
    procedure WriteToDat(const newDat: string);
    procedure WriteState(const s: TTopicState);
  public
    CompleteEvent: TSimpleEvent;
    OnlineBoard: TObject;
    ArticleList: TStringList;
    IsGotLog:        boolean;
    IsFavorite:      boolean;
    IsInBox:         boolean;
    IsError:         Boolean;
    IsPosingArticle: Boolean;
    IsFreezed:       boolean;
    IsOpened:        boolean;
    GZip:            Boolean;
    NoIndex:         Boolean;
    TopicId:       string;
    Title:         string;
    WroteName:     string;
    WroteEmail:    string;
    LocalDir:      string;
    Memo:          string;
    WriteError:    string;
    StatusText:    string;
    LastModified:  string;
    LastReadDate:  string;
    LastWriteDate: string;
    ResponseCode:    Integer;
    MessageCount:    Integer;
    Index:           Integer;
    GotMessageCount: Integer;
    NewMessageCount: Integer;
    ScrollPosition:  Integer;
    Priority:        Integer;
    DatSize:         integer;
    FileSize:        integer;
    NewReceivedMessage: TTopicMessage;
    FileDate: TDateTime;
    OnComplete: TNotifyEvent;
    OnReceived: TNotifyEvent;
    OnError: TFrameworkError;
    OnStateChange: TNotifyEvent;
    property State: TTopicState read FState write WriteState;
    property ErrorCode: TFrameworkErrorType read FErrorCode;
    property DatUrl: string read GetTopicUrl;
    property MessageList: TList read FMessageList;
    property BrowserUrl: string read GetBrowserUrl;
    constructor Create(b: TObject; ti: string);
    destructor  Destroy; override;
    function Retry: Boolean;
    procedure Download;
    procedure CancelDownload;
    procedure Post(const PostName, PostEmail, Body: string); virtual;
    procedure LoadIdx;
    procedure LoadDat;
    procedure SaveIdx;
    procedure SaveDat;
    procedure EraseIdx;
    procedure EraseDat;
    procedure EraseLog;
    procedure CheckWriteFolder;
    procedure AddNewMessage(msg: TTopicMessage);
    procedure FreeMessage;
    procedure Abone(const msgNo: integer);
  end;

implementation

uses
  untOnlineBoard, untConfig, untTool, untBoard, untBoardList;

procedure TTopic.Abone(const msgNo: integer);
begin
  with TTopicMessage(MessageList[msgNo - 1]) do
  begin
    Body := '';
    PostName := 'ځ`';
    RestStr := PostName;
    PostEmail := 'katju88kid'
  end;
  SaveDat;
end;

procedure TTopic.CancelDownload;
begin
  if State <> dsNone then
  begin
    OnStateChange := nil;
    OnReceived := nil;
    OnComplete := nil;
    //FHttp.Terminate;
  end;
end;

procedure TTopic.WriteState(const s: TTopicState);
begin
  FState := s;
  case s of
    dsStarting:
    begin
      StatusText := '';
      IsFreezed := false;
      IsError := false;
    end;
    dsFreezed:
    begin
      IsFreezed := true;
      IsError := true;
    end;
    dsError:
    begin
      IsError := true;
    end;
  end;
end;

procedure TTopic.Download;
begin
  CompleteEvent.ResetEvent;
  State := dsStarting;

  CheckWriteFolder;
  NewMessageCount := 0;
  FNoBrowser := not Assigned(OnReceived);
  FRetryed := false;
  LoadDat;
  if Assigned(OnReceived) then
  begin
    OnReceived(self);
  end;
  SendTopic;
end;

procedure TTopic.SendTopic;
begin
  FHttp := TAsyncHttp.Create;
  FHttp.FreeOnTerminate := true;

  FHttp.UserAgent := gConfig.UserAgent;
  FHttp.AddHeader('X-2ch-UA', APP_2chUA);
  gConfig.InitReadProxy(FHttp);
  FHttp.OnStatus := HttpStatusChange;
  FHttp.LastModified := LastModified;
end;

procedure TTopic.RaiseError(const ErrorCode: TFrameworkErrorType);
begin
  FErrorCode := ErrorCode;
  case ErrorCode of
    etAbone:
    begin
      StatusText := '폜ځ[ŃOl܂悤ł';
      State := dsError;
    end;
    etParse:
    begin
      StatusText := '̓G[';
      State := dsError;
    end;
    etDatFreezed:
    begin
      StatusText := 'DAT܂';
      State := dsFreezed;
    end;
    etBrokenGZip:
    begin
      StatusText := 'gzipG[';
      State := dsError;
    end;
    etSocketError:
    begin
      StatusText := 'ڑɎs܂';
      State := dsError;
    end;
  end;
end;

procedure TTopic.RaiseError(ErrorCode: TFrameworkErrorType;
                            ErrorString: string);
begin
  if Assigned(OnError) then
  begin
    OnError(self, ErrorCode, ErrorString);
  end;
end;

function TTopic.Retry: Boolean;
begin
  if FRetryed then
  begin
    result := false;
    exit;
  end;

  StatusText := 'ēǂݍݒ';
  FreeMessage;
  EraseDat;
  Download;

  FRetryed := true;
  result := true;
end;

procedure TTopic.HttpReceived(Sender: TObject);
var
  aTitle: string;
  i: integer;
  msg: TTopicMessage;
  newDat: string;

begin
  FMessageList.Capacity := FMessageList.Count + ArticleList.Count;

  newDat := '';
  for i := 0 to ArticleList.Count - 1 do
  begin
    msg := ParseDat(ArticleList[i], aTitle);
    msg.IsNewMessage := true;
    AddNewMessage(msg);

    newDat := newDat + ArticleList[i] + #13#10;

    if (msg.Index = 1) and (aTitle <> '') then
    begin
      Title := aTitle;
    end;

    Inc(NewMessageCount);
  end;
  ArticleList.Clear;
  if gConfig.DoLogSave or IsInBox or IsGotLog then
  begin
    WriteToDat(newDat);
  end;
  if Assigned(OnReceived) then
  begin
    OnReceived(self);
  end;
end;

destructor TTopic.Destroy;
begin
  FreeMessage;
  FMessageList.Free;
  ArticleList.Free;
  CompleteEvent.Free;

  inherited;
end;

procedure TTopic.HttpComplete(Sender: TObject);
begin
  // L^
  LastModified    := FHttp.LastModified;
  GotMessageCount := GotMessageCount + NewMessageCount;
  MessageCount    := GotMessageCount;

  if NewMessageCount > 0 then
  begin
    LastReadDate := DateTimeToStr(Now());
  end;

  if not IsError then
  begin
    if NewMessageCount = 0 then
    begin
      StatusText := 'VȂ'
    end else
    begin
      StatusText := IntToStr(NewMessageCount) + '̃XM';
    end;
  end else
  begin
    if FRetryed then
    begin
      StatusText := 'ēǂݍ݂܂'
    end;
  end;

  if gConfig.DoLogSave or IsInBox or IsGotLog then
  begin
    SaveIdx;
  end;

  if Assigned(OnComplete) then
  begin
    OnComplete(self);
  end;
  State := dsNone;
  CompleteEvent.SetEvent;
end;

procedure TTopic.ChangeStatusText(const NewText: string);
begin
  StatusText := NewText;
  if Assigned(OnStateChange) then
  begin
    OnStateChange(self);
  end;
end;

procedure TTopic.HttpStatusChange(axSender: TObject;
                                  const axStatus: TIdStatus;
                                  const asStatusText: string);
begin

  case axStatus of
    hsConnecting:
    begin
      ChangeStatusText((OnlineBoard as TOnlineBoard).Server + 'ɐڑ');
    end;
    hsConnected:
    begin
      State := dsProcessing;
      ChangeStatusText((OnlineBoard as TOnlineBoard).Server + 'ɐڑ܂');
    end;
  end;
end;

procedure TTopic.SaveDat;
var
  i: integer;
  msg: TTopicMessage;
  newDat: string;

begin
  DeleteFile(LocalDir + TopicId + '.d');

  newDat := '';
  for i := 0 to MessageList.Count - 1 do
  begin
    msg := TTopicMessage(MessageList[i]);
    newDat := newDat + msg.PostName + '<>' +
                       msg.PostEmail + '<>' +
                       msg.RestStr + '<>' +
                       msg.Body + #13#10;
  end;
  WriteToDat(newDat);
end;

procedure TTopic.WriteToDat(const newDat: string);
var
  logpath: string;
  datFile: TextFile;

begin
  IsGotLog := true;

  // DATt@C̏o
  logpath := LocalDir + TopicId + '.d';
  AssignFile(datFile, logpath);
  if not FileExists(logpath) then
  begin
    ReWrite(datFile);
  end;
  Append(datFile);
  Write(datFile, newDat);
  Flush(datFile);
  CloseFile(datFile);
end;

procedure TTopic.LoadDat;
var
  i, j: Integer;
  msg: TTopicMessage;
  lines: TStringList;
  items: TStringArray;
  aTitle, logpath: string;

begin
  if FLogLoaded then
  begin
    exit;
  end;
  FLogLoaded := true;
  SetLength(items, 0);
  lines := TStringList.Create;
  logpath := LocalDir + TopicId + '.d';

  if FileExists(logpath) then
  begin
    // [Jǂݍ
    lines.LoadFromFile(logpath);
    for i := 0 to lines.Count - 1 do
    begin
      msg := ParseDat(lines[i], aTitle);
      AddNewMessage(msg);
      if (i = 0) and (aTitle <> '') then
      begin
        self.Title := aTitle;
      end;
    end;
  end else
  begin
    // Of[^AÂ``
    // ÔȂ炻炩ǂݍ
    logpath := LocalDir + TopicId + '.dat';
    if FileExists(logpath) then
    begin
      lines.LoadFromFile(logpath);
      for i := 0 to lines.Count - 1 do
      begin
        items := Split(lines[i], ',');
        for j := 0 to 3 do
        begin
          items[j] := StringReplace(items[j], 'M', ',', [rfReplaceAll]);
        end;

        msg := TTopicMessage.Create;
        msg.PostName  := items[0];
        msg.PostEmail := items[1];
        msg.RestStr   := items[2];
        msg.Body      := items[3];
        AddNewMessage(msg);
        WriteToDat(items[0] + '<>' +
                   items[1] + '<>' +
                   items[2] + '<>' +
                   items[3] + #13#10);
      end;
    end;
  end;
  lines.Free;
  State := dsDatLoaded;
  if MessageList.Count > 0 then
  begin
  	GotMessagecount := MessageList.Count;
  end;
end;

function TTopic.ParseDat(const line: string; var aTitle: string): TTopicMessage;
var
  items: TStringArray;
  msg: TTopicMessage;

begin
  msg := TTopicMessage.Create;
  items := Split(line, '<>');
  if Length(items) > 3 then
  begin
    msg.PostName  := items[0];
    msg.PostEmail := items[1];
    msg.RestStr   := items[2];
    msg.Body      := items[3];
  end;

  aTitle := '';
  if Length(items) > 4 then
  begin
    aTitle := items[4];
  end;

  result := msg
end;


procedure TTopic.Post(const PostName, PostEmail, Body: string);
var
  proxyhost: string;
  proxyport: integer;

begin
  FPostHttp := TIdHttp.Create(nil);
  FPostHttp.OnStatus := HttpStatusChange;
  FPostHttp.Request.UserAgent := gConfig.UserAgent;
  FPostHttp.Request.RawHeaders.Add('X-2ch-UA: ' + APP_2chUA);

  // proxy
  if gConfig.WriteProxyUse then
  begin
    gConfig.ParseProxy(gConfig.WriteProxy, proxyhost, proxyport);
    FPostHttp.ProxyParams.ProxyServer := proxyhost;
    FPostHttp.ProxyParams.ProxyPort   := proxyport;
  end;
end;

{ --------------------------------------------------------
  pr  : RXgN^
  l  : Ȃ
  ------------------------------------------------------ }
constructor TTopic.Create(b: TObject; ti: string);
begin
  ArticleList := TStringList.Create;

  OnlineBoard := b as TOnlineBoard;
  TopicId := ti;
  FLogLoaded := false;

  GotMessageCount := 0;
  NewMessageCount := 0;

  FMessageList := TList.Create;

  CompleteEvent := TSimpleEvent.Create;

  if not gFolderAlias.GetFolderPath((OnlineBoard as TOnlineBoard).Server,
                                    (OnlineBoard as TOnlineBoard).BoardName,
                                    TopicId + '.i',
                                    LocalDir) then
  begin
    gFolderAlias.GetFolderPath((OnlineBoard as TOnlineBoard).Server,
                               (OnlineBoard as TOnlineBoard).BoardName,
                               TopicId + '.idx',
                               LocalDir)
  end;
end;

procedure TTopic.LoadIdx;
var
  idxPath: string;
  idxLines: TStringList;
  idxItems: TStringArray;
  state: Integer;

begin
  SetLength(idxitems, 0);

  // IDX t@CΓǂݍ
  NoIndex := true;
  if DirectoryExists(LocalDir) then
  begin
    idxPath := localdir + TopicId + '.i';
    if not FileExists(idxPath) then
    begin
      idxPath := localDir + TopicId + '.idx';
      if not FileExists(idxPath) then
      begin
        exit;
      end;
    end;

    idxLines := TStringList.Create();
    idxLines.LoadFromFile(idxPath);
    if idxLines.Count > 0 then
    begin
      idxItems := Split(idxLines[0], #9);
      if Length(idxItems) >= 18 then
      begin
        NoIndex := false;

        state := StrToIntNeo(idxItems[1]);
        IsFreezed  := Boolean(state and 16);
        IsGotLog   := Boolean(state and 32);
        IsFavorite := Boolean(state and 64);

        Priority        :=  StrToInt(idxItems[2]);
        Title           :=           idxItems[3];
        // 4`6͌ݎgĂȂ
        MessageCount    :=  StrToInt(idxItems[7]);
        GotMessageCount :=  StrToInt(idxItems[8]);
        NewMessageCount :=  StrToInt(idxItems[9]);
        LastReadDate    :=           idxItems[10];
        LastWriteDate   :=           idxItems[11];
        // FBoardName := idxItems[12]; ͌ݎgĂȂ
        DatSize         :=  StrToInt(idxItems[13]);
        WroteName       :=           idxItems[14];
        WroteEmail      :=           idxItems[15];
        ScrollPosition  :=  StrToInt(idxItems[16]);
        Memo            :=           idxItems[17];
      end;

      // only 88 item
      if Length(idxItems) > 21 then
      begin
        LastModified := idxItems[21];
      end;

      // ver0.23 add
      if Length(idxItems) > 22 then
      begin
        state := StrToIntNeo(idxItems[22]);
        IsInBox  := Boolean(state and 16);
        Gzip     := Boolean(state and 32);
      end;
    end;
    idxLines.Free;
  end;
end;
{ --------------------------------------------------------
  pr  : Idxt@C̋L^
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopic.SaveIdx;
var
  line, idxPath: string;
  state, state2: Integer;

begin
  if IsFreezed and (MessageCount = 0) then
  begin
    exit;
  end;

  CheckWriteFolder;

  NoIndex := false;

  state := 0;
  if IsFreezed then
  begin
    state := state or 16;
  end;
  if IsGotLog then
  begin
    state := state or 32;
  end;
	if IsFavorite then
  begin
    state := state or 64;
  end;

  state2 := 0;
  if IsInBox then
  begin
    state2 := state2 or 16;
  end;
  if GZip then
  begin
    state2 := state2 or 32;
  end;

  line := '88' + #9 +
          IntToStr(state) + #9 +
					IntToStr(Priority) + #9 +
					Title + #9 +
          #9 +
					#9 +
				  #9 +
					IntToStr(MessageCount) + #9 +
					IntToStr(GotMessageCount) + #9 +
					IntToStr(NewMessageCount) + #9 +
					LastReadDate  + #9 +
					LastWriteDate + #9 +
					#9 +
					IntToStr(Datsize) + #9 +
					WroteName + #9 +
					WroteEmail + #9 +
					IntToStr(ScrollPosition) + #9 +
					Memo + #9 +
          #9 +
          #9 +
          #9 +
          LastModified + #9 +
          IntToStr(state2) + #9;

  // ۑ
  idxPath := LocalDir + TopicId + '.i';
  WriteFile(idxPath, line);
end;

procedure TTopic.FreeMessage;
var
  i: Integer;

begin
  for i := 0 to FMessageList.Count - 1 do
  begin
    TTopicMessage(FMessageList[i]).Free;
  end;
  FMessageList.Clear;

  FLogLoaded := false;
end;

procedure TTopic.EraseDat;
begin
  GotMessageCount := 0;
  NewMessageCount := 0;
  Datsize      := 0;
  LastModified := '';
  DeleteFile(LocalDir + TopicId + '.d');
end;

procedure TTopic.EraseIdx;
begin
  DeleteFile(LocalDir + TopicId + '.i');
end;

{ --------------------------------------------------------
  pr  : O̍폜
  l  : Ȃ
  ------------------------------------------------------ }
procedure TTopic.EraseLog;
var
  b: TOnlineBoard;

begin
  CancelDownload;
  
  // 폜
  EraseDat;
  EraseIdx;

  FreeMessage;

  Priority        := 0;
  LastReadDate    := '';
  LastWriteDate   := '';
  Memo            := '';
  IsGotLog        := false;

  StatusText := 'u' + Title + 'ṽO폜܂';

  if IsFavorite then
  begin
    // Cɓ肩͂
    IsFavorite := false;
    b := OnlineBoard as TOnlineBoard;
    (b.BoardList as TBoardList).MyFolder.FavoriteBoard.RemoveTopic(self);
  end;
end;

//  vCx[g֐ 
procedure TTopic.CheckWriteFolder;
begin
  // tH_Ȃ΍
  if DirectoryExists(LocalDir) = false then
  begin
    CreateFullDir(LocalDir);
  end;
end;

procedure TTopic.AddNewMessage(msg: TTopicMessage);
begin
  msg.Index := FMessageList.Count + 1;
  FMessageList.Add(msg);
end;

{ TTopicMessage }

// |bvAbvp̃bZ[W
function TTopicMessage.GetForPopup: string;
var
  pureText: string;
  regEx: TRegExpr;

begin
  pureText := IntToStr(Index) + ' ' +
              'OF' + PostName + ' ';
  if gConfig.DispMailAddress and (PostEmail <> '') then
  begin
    pureText := pureText + '[' + PostEmail + ']';
  end;
  pureText := pureText + 'eF' + RestStr  + #10 + Body;

  // HTML^O
	puretext := StringReplace(pureText, '<br>', #10, [rfReplaceAll]);
  regEx := TRegExpr.Create;
  regEx.Expression := '<.*?>';
  pureText := regEx.Replace(pureText, '');
  regEx.Free;

  // ꕶϊ
  pureText := StringReplace(pureText, '&gt;', '>', [rfReplaceAll]);
  pureText := StringReplace(pureText, '&lt;', '<', [rfReplaceAll]);

  result := pureText;
end;

end.
