unit untTopic2ch;

interface

uses
  IdComponent,
  untTopic, untOnlineBoard;

type
  TTopic2ch = class(TTopic)
  private
    FNoFirstLine: boolean;
  protected
    procedure SendTopic; override;
    procedure HttpReceived(Sender: TObject); override;
    procedure HttpComplete(Sender: TObject); override;
    function  GetTopicURL: string; override;
    function  GetBrowserURL: string; override;
  public
    procedure Post(const PostName, PostEmail, Body: string); override;
  end;

implementation

uses
  Classes, IdCookieManager, jconvert, DzURL, SysUtils, RegExpr,
  untHttp, untGlobal, untConfig,  untTool;

function TTopic2ch.GetTopicURL: string;
begin
  result := 'http://' + (OnlineBoard as TOnlineBoard).Server + '/' +
                        (OnlineBoard as TOnlineBoard).BoardName + '/dat/' + TopicId + '.dat';
end;

function TTopic2ch.GetBrowserUrl: string;
begin
  result := 'http://' + (OnlineBoard as TOnlineBoard).Server + '/test/read.cgi/'  +
                        (OnlineBoard as TOnlineBoard).BoardName  + '/' + TopicId + '/';
end;

procedure TTopic2ch.SendTopic;
begin
  inherited;
  
  FNoFirstLine := true;

  if DatSize > 0 then
  begin
    FHttp.StartRange := DatSize - 1
  end else
  begin
    FHttp.StartRange := 0;
  end;

  FHttp.UseGzip := true;

  FHttp.OnReceived := HttpReceived;
  FHttp.OnTerminate := HttpComplete;

  FHttp.URL := GetTopicURL;
  FHttp.Resume;
end;

procedure TTopic2ch.Post(const PostName, PostEmail, Body: string);
var
  postData: TStringList;
  intTime: integer;
  response, errorMsg, writeData, compData: string;

begin
  inherited;

  with FPostHttp do
  begin
    Request.Referer := 'http://' +
                          (OnlineBoard as TOnlineBoard).Server + '/' +
                          (OnlineBoard as TOnlineBoard).BoardName  + '/index2.html';
    CookieManager   := TIdCookieManager.Create(nil);
    HTTPOptions := [];
    Request.CustomHeaders.Add('Cookie: NAME=' + UrlEncode(PostName) +
                              '&Cookie: MAIL=' + UrlEncode(PostEmail) +';');
    ConnectTimeout := CONNECT_TIMEOUT;
  end;

  writeData := 'submit='  + UrlEncode('') + '&' +
               'FROM='    + UrlEncode(PostName) + '&' +
               'mail='    + UrlEncode(PostEmail) + '&' +
               'MESSAGE=' + UrlEncode(Body) + '&' +
               'bbs='     + (OnlineBoard as TOnlineBoard).BoardName + '&' +
               'key='     + TopicId;

  if gConfig.Sessionid <> '' then
  begin
    writeData := writeData + '&sid=' + UrlEncode(gConfig.Sessionid);
  end;

  intTime := Round((Now() - EncodeDate(1970, 1, 1)) * 86400 - 32400);
  compdata := writeData + '&' + 'time=' + IntToStr(intTime);
  postData := TStringList.Create;
  postData.Add(compData);

  response := FPostHttp.Post('http://' + (OnlineBoard as TOnlineBoard).Server +
                               '/test/bbs.cgi',
                             postData);
  if Pos('݂܂', response) = 0 then
  begin
    postData.Free;
    postData := TStringList.Create;

    intTime := Round((FPostHttp.Response.Date - EncodeDate(1970, 1, 1)) * 86400) - 32400 - 100;
    compData := writeData + '&' + 'time=' + IntToStr(intTime);
    postData.Add(compData);

    response := FPostHttp.Post('http://' + (OnlineBoard as TOnlineBoard).Server +
                                 '/test/bbs.cgi',
                               postData);

    if Pos('݂܂', response) = 0 then
    begin
      // G[
      ErrorMsg := CopyMiddle(response, '<b>', '</b>');
      if ErrorMsg = '' then
      begin
        ErrorMsg := CopyMiddle(response, '<!-- 2ch_X:error -->', '<br>');
      end;
      if ErrorMsg = '' then
      begin
        ErrorMsg := 'G[܂';
      end;
    end;
  end;

  postData.Free;
  FPostHttp.CookieManager.Free;
  FPostHttp.CookieManager := nil;

  if ErrorMsg <> '' then
  begin
    RaiseError(etPostArticle, ErrorMsg)
  end else
  begin
    if Assigned(OnComplete) then
    begin
      OnComplete(self);
    end;
  end;
  FPostHttp.Free;  
end;

procedure TTopic2ch.HttpReceived(Sender: TObject);
var
  line: string;
  regExp: TRegExpr;
  i: Integer;

begin
  regExp := TRegExpr.Create;
  try
    ArticleList.BeginUpdate;
    regExp.Expression := '^(.*?)<>(.*?)<>(.*?)<>(.*?)<>(.*?)';
    for i := 0 to FHttp.ReceivedLines.Count - 1 do
    begin
      line := FHttp.ReceivedLines[i];

      // Ol܂`FbN
      if FNoFirstLine then
      begin
        FNoFirstLine := false;
        if DatSize > 0 then
        begin
          if line = '' then
          begin
            continue;
          end else
          begin
            RaiseError(etAbone);
            exit;
          end;
        end
      end;

      // sǉ
      if RegExp.Exec(line) then
      begin
        ArticleList.Add(line);
      end else
      begin
        RaiseError(etParse);
        ArticleList.Add('<FONT COLOR="Gray">[Ă܂]</FONT><>' +
                        '<FONT COLOR="Gray">[Ă܂]</FONT><>' +
                        '<FONT COLOR="Gray">[Ă܂]</FONT><>' +
                        '<FONT COLOR="Gray">[Ă܂]</FONT><>');
      end;
    end;
    ArticleList.EndUpdate;
    FHttp.ReceivedLines.Clear;
  finally
    Regexp.Free;
  end;
  inherited;
end;

procedure TTopic2ch.HttpComplete(Sender: TObject);
var
  contentSize: integer;

begin
  State := dsComplete;
  
  ResponseCode := FHttp.ResponseCode;
  if (ResponseCode <> 304) and (ResponseCode > 0) then
  begin
    if (ResponseCode < 200) or (ResponseCode > 299) then
    begin
      RaiseError(etDatFreezed);
    end;
  end;

  if FHttp.ErrorCode = heBrokenGZip then
  begin
    RaiseError(etBrokenGZip);
  end else if FHttp.ErrorCode = heSocketError then
  begin
    RaiseError(etSocketError);
  end;

  contentSize := FHttp.ContentLength;
  if contentSize > 0 then
  begin
    if DatSize = 0 then
    begin
      DatSize := contentSize;
    end else
    begin
      DatSize := DatSize + contentSize - 1;
    end;
  end;

  inherited;
end;


end.
