unit untTopic2chKako;

interface

uses
  untTopic2ch, untOnlineBoard;

type

  TTopic2chKako = class(TTopic2ch)
  protected
    function GetTopicURL: string; override;
  public
    IsExist: Boolean;
    constructor Create(b: TOnlineBoard; TopicId: string);
    procedure HttpComplete(Sender: TObject); override;
  end;

implementation

procedure TTopic2chKako.HttpComplete(Sender: TObject);
begin
  inherited;

  if FHttp.ResponseCode <> 302 then
  begin
    IsExist := true;
  end;
end;

constructor TTopic2chKako.Create(b: TOnlineBoard; TopicId: string);
begin
  inherited Create(b, TopicId);

  IsExist := false;
end;

function TTopic2chKako.GetTopicURL: string;
begin
  if Length(TopicId) > 9 then
  begin
    result := 'http://' + (OnlineBoard as TOnlineBoard).Server + '/' +
                          (OnlineBoard as TOnlineBoard).BoardName + '/kako/' +
                          Copy(TopicId, 1, 4) + '/' +
                          Copy(TopicId, 1, 5) + '/' + TopicId + '.dat.gz'
  end else
  begin
    result := 'http://' + (OnlineBoard as TOnlineBoard).Server + '/' +
                          (OnlineBoard as TOnlineBoard).BoardName + '/kako/' +
                          Copy(TopicId, 1, 3) + '/' + TopicId + '.dat.gz';
  end;
end;

end.
