unit untTopicJBBS;

interface

uses
  IdComponent, IdHttp, 
  untTopic, untOnlineBoard;

type
  TTopicJBBS = class(TTopic)
  private
    FReceivedIndex: integer;
    FArticleIndex: integer;
    FBufferLines: string;
  protected
    procedure SendTopic; override;
    procedure HttpReceived(Sender: TObject); override;
    procedure HttpComplete(Sender: TObject); override;
    procedure HTTPRedirect(Sender: TObject;
                           var dest: String;
                           var NumRedirect: Integer;
                           var Handled: Boolean;
                           var VMethod: TIdHTTPMethod);
    function  GetTopicURL: string; override;
    function  GetBrowserURL: string; override;
  public
    procedure Post(const PostName, PostEmail, Body: string); override;
    constructor Create(b: TOnlineBoard; TopicId: string);
  end;

implementation

uses
  Classes, IdCookieManager, jconvert, DzURL, SysUtils, RegExpr,
  untHttp, untGlobal, untConfig, untTool, untBoardList;

function TTopicJBBS.GetTopicUrl: string;
begin
  result := 'http://' + (OnlineBoard as TOnlineBoard).Server +
                        '/bbs/read.cgi?BBS=' +
                        (OnlineBoard as TOnlineBoard).BoardName +
                        '&KEY=' + TopicId;
end;

function TTopicJBBS.GetBrowserUrl: string;
begin
  result := 'http://' + (OnlineBoard as TOnlineBoard).Server +
                        '/bbs/read.cgi?BBS=' + (OnlineBoard as TOnlineBoard).BoardName +
                        '&KEY=' + TopicId
end;

constructor TTopicJBBS.Create(b: TOnlineBoard; TopicId: string);
begin
  inherited Create(b, TopicId);

  FURL := 'http://' + b.Server + '/bbs/read.pl?BBS=' +
                      b.BoardName + '&KEY=' + TopicId;
end;

procedure TTopicJBBS.Post(const PostName, PostEmail, Body: string);
var
  postData: TStringList;
  intTime: integer;
  response, ErrorMsg: string;

begin
  FPostHttp.Request.Referer := 'http://' +
                                  (OnlineBoard as TOnlineBoard).Server + '/' +
                                  (OnlineBoard as TOnlineBoard).BoardName + '/index2.html';
  FPostHttp.HTTPOptions := [];
  FPostHttp.Request.CustomHeaders.Add('Cookie: NAME=' + UrlEncode(PostName) +
                                      '&Cookie: MAIL=' + UrlEncode(PostEmail) +';');
  FPostHttp.OnRedirect := HTTPRedirect;
  FPostHttp.ConnectTimeout := CONNECT_TIMEOUT;

  intTime := Round((Now() - EncodeDate(1970, 1, 1)) * 86400);
  postData := TStringList.Create;
  postData.Add('submit='  + UrlEncode('') + '&' +
               'NAME='    + UrlEncode(PostName) + '&' +
               'MAIL='    + UrlEncode(PostEmail) + '&' +
               'MESSAGE=' + UrlEncode(Body)+ '&' +
               'BBS='     + (OnlineBoard as TOnlineBoard).BoardName + '&' +
               'KEY='     + TopicId + '&' +
               'TIME='    + IntToStr(intTime));

  response := FPostHttp.Post('http://' +
                              (OnlineBoard as TOnlineBoard).Server +
                              '/bbs/write.cgi', postData);

  postData.Free;

  if ErrorMsg <> '' then
  begin
    RaiseError(etPostArticle, ErrorMsg)
  end else
  begin
    if Assigned(OnComplete) then
    begin
      OnComplete(self);
    end;
  end;
  FPostHttp.Free;  
end;

procedure TTopicJBBS.HTTPRedirect(Sender: TObject;
                                  var dest: String;
                                  var NumRedirect: Integer;
                                  var Handled: Boolean;
                                  var VMethod: TIdHTTPMethod);
begin
  Handled := false;
end;

procedure TTopicJBBS.HttpReceived(Sender: TObject);
var
  line, msgName, msgEmail, msgRestStr, msgBody: string;
  regExp: TRegExpr;
  i, msgNo: integer;
  regOK: boolean;

begin
  regExp := TRegExpr.Create;
 
  msgNo := 0;
  for i := FReceivedIndex to FHttp.ReceivedLines.Count - 1 do
  begin
    line         := ConvertJCode(FHttp.ReceivedLines[i], SJIS_OUT);
    FBufferLines := FBufferLines + line;

    regOK := false;
    RegExp.Expression := '<dt>(.+?) .+<b>(.*?)</[bB]></font>(.+?)<br><dd>(.*?)<br><br>$';
    if regExp.Exec(FBufferLines) then
    begin
      regOK      := true;
      msgNo      := StrToIntNeo(regExp.Substitute('$1'));
      msgEmail   := '';
      msgName    := regExp.Substitute('$2');
      msgRestStr := regExp.Substitute('$3');
      msgBody    := regExp.Substitute('$4');
    end else
    begin
      regExp.Expression := '<dt>(.+?) .+<a href="mailto:(.*?)"><b>(.*?)</[bB]></a> (.+?)<br><dd>(.*?)<br><br>$';
      if regExp.Exec(FBufferLines) then
      begin
        regOK      := true;
        msgNo      := StrToIntNeo(regExp.Substitute('$1'));
        msgEmail   := regExp.Substitute('$2');
        msgName    := regExp.Substitute('$3');
        msgRestStr := regExp.Substitute('$4');
        msgBody    := regExp.Substitute('$5');
      end;
    end;

    if regOK then
    begin
      FBufferLines := '';
      while msgNo > FArticleIndex + 1 do
      begin
        ArticleList.Add('ځ[<>' + '' + '<>' +
                        'ځ[' + '<>' + 'ځ[');
        Inc(FArticleIndex);
      end;
      // sǉ
      ArticleList.Add(msgName + '<>' + msgEmail + '<>' +
                      msgRestStr + '<>' + msgBody);
      Inc(FArticleIndex);
    end;
  end;
  if FHttp.ReceivedLines.Count > FReceivedIndex then
  begin
    FReceivedIndex := FHttp.ReceivedLines.Count;
  end;
  regExp.Free;

  inherited;
end;

procedure TTopicJBBS.HttpComplete(Sender: TObject);
var
  contentSize: integer;

begin
  State := dsComplete;
  
  DatSize := FReceivedIndex;
  contentSize := FHttp.ContentLength;
  if contentSize > 0 then
  begin
    if DatSize = 0 then
    begin
      DatSize := contentSize;
    end else
    begin
      DatSize := DatSize + contentSize - 1;
    end;
  end;
  inherited;
end;

procedure TTopicJBBS.SendTopic;
begin
  inherited;

  FHttp.OnReceived := HttpReceived;
  FHttp.OnTerminate := HttpComplete;

  if DatSize > 0 then
  begin
    FReceivedIndex := DatSize;
    FHttp.StartRange := DatSize;
  end;
  FHttp.URL := FURL;
  FHttp.Resume;
end;

end.
