unit untAllSubscribedTopicsLoadThread;

interface

uses
  Classes, SysUtils, StrUtils,
  RegExpr,
  untBoard, untOnlineBoard, untGlobal, untAllSubscribedTopics, untBoardList;

type

  TAllSubscribedTopicsLoadThread = class(TThread)
  private
    FOnlineBoard: TOnlineBoard;
    FTopicId: string;
    FSize: integer;
    FDate: TDateTime;
    FIndex: integer;
    FServer: string;
    FBoardName: string;
    procedure LoadLog(const path: string);
    procedure AddTopic;
    procedure GetBoard;
  public
    Board: TAllSubscribedTopics;
    procedure Execute; override;
  end;

implementation

uses
  untConfig, untTopic;

{ TAllSubscribedTopicsLoadThread }

procedure TAllSubscribedTopicsLoadThread.Execute;
var
  path: string;

begin
  FIndex := 0;
  
  path := DIR_LOG;
  if AnsiEndsText('\', DIR_LOG) then
  begin
    path := Copy(path, 0, Length(path) - 1);
  end;
  LoadLog(path);

  ReturnValue := 0;
end;


//  vCx[g֐ 

{ --------------------------------------------------------
  ֐: LoadLog
  pr  : O̓ǂݍ
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TAllSubscribedTopicsLoadThread.LoadLog(const path: string);
var
  regEx: TRegExpr;
  searchRec: TSearchRec;
  foundPath: string;

  procedure SetFileSizeDate(const f: string);
  var
    r: TSearchRec;
  begin
    FindFirst(f, faAnyFile, r);
    FSize := r.Size;
    FDate := r.Time;
  end;

begin
  regEx := TRegExpr.Create;
  regEx.Expression := '^' + DIR_LOG + '\' + '(.+?)\\(.+?)\\(.+?)\.i';

  if FindFirst(path +  '\*.*', faAnyFile, searchRec) = 0 then
  begin
    repeat
      if (searchRec.Name <> '.') and (searchRec.Name <> '..') then
      begin
        foundPath := path + '\' + searchRec.Name;

        if (searchRec.Attr and faDirectory) <> 0 then
        begin
          LoadLog(foundPath);
        end;

        if AnsiEndsText('.i', searchRec.Name) then
        begin
          // gsbN̓ǂݍ
          if regEx.Exec(foundPath) then
          begin
            FServer    := Regex.Substitute('$1');
            FBoardname := Regex.Substitute('$2');
            FTopicid   := Regex.Substitute('$3');
            FServer := StringReplace(FServer, '_', '/', [rfReplaceAll]);

            Inc(FIndex);
            SetFileSizeDate(path + '\' + FTopicid + '.d');
            if Terminated then
            begin
              break;
            end else
            begin
              Synchronize(GetBoard);
              Synchronize(AddTopic);
            end;
          end;
        end;
      end;
    until FindNext(searchRec) <> 0;
    FindClose(searchRec);
  end;
  Regex.Free;
end;

procedure TAllSubscribedTopicsLoadThread.GetBoard;
begin
  FOnlineBoard := (Board.BoardList as TBoardList).GetBoard(FServer, FBoardname);
end;

procedure TAllSubscribedTopicsLoadThread.AddTopic;
var
  topic: TTopic;

begin
  topic := FOnlineBoard.GetTopic(FTopicId);
  topic.FileSize := FSize;
  topic.FileDate := FDate;
  topic.Index := FIndex;
  self.Board.AppendTopic(topic);
end;

end.

