/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_FAVICON_H__
#define __KZ_FAVICON_H__

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define KZ_TYPE_FAVICON		   (kz_favicon_get_type ())
#define KZ_FAVICON(obj)		   (G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_FAVICON, KzFavicon))
#define KZ_FAVICON_CLASS(klass)	   (G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_FAVICON, KzFaviconClass))
#define KZ_IS_FAVICON(obj)	   (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_FAVICON))
#define KZ_IS_FAVICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_FAVICON))
#define KZ_FAVICON_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_FAVICON, KzFaviconClass))

typedef struct _KzFavicon   	KzFavicon;
typedef struct _KzFaviconClass	KzFaviconClass;

struct _KzFavicon
{
	GObject parent;
};

struct _KzFaviconClass
{
	GObjectClass parent_class;

	/* signals */
	void (*ready)         (KzFavicon *kzfav);
};

GType      kz_favicon_get_type      (void) G_GNUC_CONST;

KzFavicon *kz_favicon_get_instance  (void);

KzFavicon *kz_favicon_new           (void);
GtkWidget *kz_favicon_get_widget    (KzFavicon *kzfav, 
				     const gchar *uri,
				     GtkIconSize size);
GdkPixbuf *kz_favicon_get_pixbuf    (KzFavicon *kzfav,
				     const gchar *uri,
				     GtkIconSize size);

void       kz_favicon_get_icon_from_uri (KzFavicon *kzfav, 
					 const gchar *uri,
					 const gchar *document_uri);

G_END_DECLS

#endif /* __KZ_FAVICON_H__ */
