/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GOOGLE_ACTION_H__
#define __GOOGLE_ACTION_H__

/*
 *  This action is temporary solution to create a google item.
 *  We'll replace this with KzBookmark and KzBookmarkAction.
 *  (Smart bookmark)
 */

#include <gtk/gtk.h>
#include "egg-history-action.h"
#include "kz-window.h"

#define TYPE_GOOGLE_ACTION            (google_action_get_type())
#define GOOGLE_ACTION(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_GOOGLE_ACTION, GoogleAction))
#define GOOGLE_ACTION_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_GOOGLE_ACTION, GoogleActionClass))
#define IS_GOOGLE_ACTION(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_GOOGLE_ACTION))
#define IS_GOOGLE_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((obj), TYPE_GOOGLE_ACTION))
#define GOOGLE_ACTION_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_GOOGLE_ACTION, GoogleActionClass))

typedef struct _GoogleAction      GoogleAction;
typedef struct _GoogleActionClass GoogleActionClass;

struct _GoogleAction
{
	EggHistoryAction parent;
	KzWindow *kz;
};

struct _GoogleActionClass
{
	EggHistoryActionClass parent_class;
};

GType         google_action_get_type (void);
GoogleAction *google_action_new      (KzWindow *kz);


#endif /* __GOOGLE_ACTION_H__ */
