/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.laxGenerator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jp.co.cybec.laxGenerator.DataSourceMethod;
import jp.co.cybec.laxGenerator.DataSourceService;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class DataSourceFileAnalyst {
    private final String fileName;
    private HashMap dataSourceMap;

    public DataSourceFileAnalyst(String dataSourceFile) {
        this.fileName = dataSourceFile;
    }

    protected void parse() throws JDOMException, IOException {
        this.dataSourceMap = new HashMap();
        Document document = this.createDocument(this.fileName);
        if (document == null) {
            return;
        }
        this.setDataSourceFromDataSourceFile(document);
    }

    private Document createDocument(String fileName) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        File file = new File(fileName);
        if (!file.isFile()) {
            return null;
        }
        builder.setValidation(true);
        Document document = builder.build(file);
        return document;
    }

    protected HashMap getDataSourceMap() {
        return this.dataSourceMap;
    }

    private void setDataSourceFromDataSourceFile(Document document) {
        Element dataSourceElement = document.getRootElement();
        this.setDataSourceMap(dataSourceElement);
    }

    private void setDataSourceMap(Element dataSourceElements) {
        List elementOfServiceList = dataSourceElements.getChildren();
        for (Element dataSourceElement : elementOfServiceList) {
            String id = dataSourceElement.getAttributeValue("id");
            DataSourceService service = new DataSourceService(id);
            Element itemsElement = dataSourceElement.getChild("itemNames");
            List itemNameList = this.getItemNameList(itemsElement);
            service.setItemNameList(itemNameList);
            Element methodsElement = dataSourceElement.getChild("methods");
            this.setMethods(methodsElement, service);
            this.dataSourceMap.put(id, service);
        }
    }

    private List getItemNameList(Element element) {
        if (element == null) {
            return null;
        }
        List elements = element.getChildren();
        ArrayList<String> nameElementList = new ArrayList<String>();
        for (Element nameElement : elements) {
            nameElementList.add(nameElement.getValue());
        }
        return nameElementList;
    }

    private void setMethods(Element methodsElement, DataSourceService service) {
        Element saveMethod = null;
        Element updateMethod = null;
        Element deleteMethod = null;
        ArrayList<Element> findMethodList = new ArrayList<Element>();
        ArrayList<Element> methodList = new ArrayList<Element>();
        List methodsElementList = methodsElement.getChildren();
        for (Element method : methodsElementList) {
            String methodKind = method.getName();
            if (methodKind.equals("saveMethod")) {
                saveMethod = method;
                continue;
            }
            if (methodKind.equals("updateMethod")) {
                updateMethod = method;
                continue;
            }
            if (methodKind.equals("deleteMethod")) {
                deleteMethod = method;
                continue;
            }
            if (methodKind.equals("findMethod")) {
                findMethodList.add(method);
                continue;
            }
            if (!methodKind.equals("method")) continue;
            methodList.add(method);
        }
        service.setSaveMethod(this.setMethod(saveMethod));
        service.setUpdateMethod(this.setMethod(updateMethod));
        service.setDeleteMethod(this.setMethod(deleteMethod));
        service.setFindMethodList(this.setMethod(findMethodList));
        service.setMethodList(this.setMethod(methodList));
    }

    private List setMethod(List methodElementList) {
        ArrayList<DataSourceMethod> methodList = new ArrayList<DataSourceMethod>();
        for (Element element : methodElementList) {
            String methodName = element.getAttributeValue("name");
            String returnType = element.getAttributeValue("returnType");
            DataSourceMethod dataSourceMethod = new DataSourceMethod(methodName);
            dataSourceMethod.setReturnType(returnType);
            List list = element.getChildren();
            for (Element paramData : list) {
                dataSourceMethod.setParams(paramData.getValue());
            }
            methodList.add(dataSourceMethod);
        }
        return methodList;
    }

    private DataSourceMethod setMethod(Element methodElement) {
        if (methodElement == null) {
            return null;
        }
        String methodName = methodElement.getAttributeValue("name");
        String returnType = methodElement.getAttributeValue("returnType");
        DataSourceMethod dataSourceMethod = new DataSourceMethod(methodName);
        dataSourceMethod.setReturnType(returnType);
        List list = methodElement.getChildren();
        for (Element paramData : list) {
            dataSourceMethod.setParams(paramData.getValue());
        }
        return dataSourceMethod;
    }
}

