/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.laxGenerator.attributes.base;

import java.util.List;
import java.util.Map;
import jp.co.cybec.laxGenerator.attributes.base.BaseTag;
import jp.co.cybec.laxGenerator.attributes.js.ComponentJsTag;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkButtonTag
extends BaseTag {
    private ComponentJsTag jsTag = null;

    public LinkButtonTag(String idString) {
        this.id = idString;
        this.jsTag = new ComponentJsTag();
    }

    @Override
    protected String getTagName() {
        return "<a  ";
    }

    @Override
    protected String getTagsAttribute() {
        String html = this.getUrl();
        html = String.valueOf(html) + this.getScript() + ">";
        html = String.valueOf(html) + this.getValue();
        html = String.valueOf(html) + "</a>\n";
        return html;
    }

    public String getId() {
        return this.id;
    }

    private String getScript() {
        StringBuilder script = new StringBuilder("");
        if (this.event != null && !this.event.equals("")) {
            script.append(" ").append(this.event).append("=\"").append(this.id).append("();\"");
        }
        return script.toString();
    }

    @Override
    public String toFunction() {
        String scriptDefine = "function " + this.id + "() {\n" + "} \n";
        scriptDefine = String.valueOf(scriptDefine) + this.jsTag.toFunction();
        return scriptDefine;
    }

    @Override
    protected String getPositionEndTag() {
        String divEnd = "";
        divEnd = "</div>\n";
        return divEnd;
    }

    @Override
    protected String getPositionTag() {
        String div = "";
        div = "<div style=\"position:absolute;" + super.getX() + super.getY() + "\">\n";
        return div;
    }

    @Override
    public void setAttributes(Element element) {
        this.url = element.getAttributeValue("url");
        this.value = element.getAttributeValue("text");
        this.x = element.getAttributeValue("x");
        this.y = element.getAttributeValue("y");
        this.componentWidth = element.getAttributeValue("componentWidth");
        this.componentHeight = element.getAttributeValue("componentHeight");
        this.event = element.getAttributeValue("event");
        this.jsTag.setAttributes(element);
    }

    public String getUrl() {
        if (this.url == null || this.url != null && this.url.equals("")) {
            return "";
        }
        return " href=\"" + this.url + "\" ";
    }

    public String getValue() {
        if (this.value == null || this.value != null && this.value.equals("")) {
            return "";
        }
        return this.value;
    }

    @Override
    public void setDataSource(Map map) {
        this.jsTag.setDataSource(map);
    }

    @Override
    public String getJsId() {
        return this.jsTag.getJsId();
    }

    @Override
    public List<String> getDefineFileList() {
        return this.jsTag.getDefineFileList();
    }
}

