package jp.co.cybec.laxide.editParts;

import java.beans.PropertyChangeEvent;

import jp.co.cybec.laxide.layout.AbstractLayoutPoints;
import jp.co.cybec.laxide.layout.LetsAjaxLayoutPointFactory;
import jp.co.cybec.laxide.layout.LetsAjaxPlaneLayoutPoints;
import jp.co.cybec.laxide.model.base.LetsAjaxPlainLayoutModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RequestConstants;
import org.eclipse.jface.viewers.TextCellEditor;

public class LetsAjaxPlainLayoutEditPart extends EditPartWithListener {

	private LetsAjaxDirectEditManager directManager = null;

	public void propertyChange(PropertyChangeEvent evt) {

	}

	protected IFigure createFigure() {
		LetsAjaxLayoutPointFactory factory = LetsAjaxLayoutPointFactory
				.getInstance();
		AbstractLayoutPoints points = factory
				.getLayoutPoints(LetsAjaxPlaneLayoutPoints.class);
		
		return points.getLayoutPolyLine();
	}

	protected void createEditPolicies() {
	}

	protected void refreshVisuals() {
		Rectangle constraint = ((LetsAjaxPlainLayoutModel) getModel())
				.getConstraint();

		((GraphicalEditPart) getParent()).setLayoutConstraint(this,
				getFigure(), constraint);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.editparts.AbstractEditPart#performRequest(org.eclipse.gef.Request)
	 */
	public void performRequest(Request req) {
		if (req.getType().equals(RequestConstants.REQ_DIRECT_EDIT)) {
			performDirectEdit();
			return;
		}
		super.performRequest(req);
	}

	/**
	 * 
	 */
	private void performDirectEdit() {
		if (directManager == null) {
			directManager = new LetsAjaxDirectEditManager(this,
					TextCellEditor.class, new LetsAjaxCellEditorLocator(
							getFigure()));
		}
		directManager.show();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.co.cybec.laxide.editParts.EditPartWithListener#activate()
	 */
	public void activate() {
		// Cxg󂯕tȂ悤ɃXiւ̓o^͍sȂ
	}

}
