package jp.co.cybec.laxide.editParts;

import java.beans.PropertyChangeEvent;

import jp.co.cybec.laxide.editpolicies.LetsAjaxComponentEditPolicy;
import jp.co.cybec.laxide.editpolicies.LetsAjaxDirectEditPolicy;
import jp.co.cybec.laxide.model.base.LetsAjaxTextAreaModel;

import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RequestConstants;
import org.eclipse.jface.viewers.TextCellEditor;

/**
 * eLXgGA`悷NX. t@CFLetsAjaxTextAreaEditPart.java
 * 
 * @author nakamura 쐬F13:49:08
 * 
 */
public class LetsAjaxTextAreaEditPart extends EditPartWithListener {

	private LetsAjaxDirectEditManager directManager = null;

	/**
	 * ύXꂽɌĂ΂郁\bh
	 * 
	 * @see jp.co.cybec.laxide.editParts.EditPartWithListener#propertyChange(java.beans.PropertyChangeEvent)
	 */
	public void propertyChange(PropertyChangeEvent evt) {

		if (evt.getPropertyName().equals(LetsAjaxTextAreaModel.P_CONSTRAINT)) {
			Label label = (Label) getFigure();
			LetsAjaxTextAreaModel model = (LetsAjaxTextAreaModel) getModel();

			model.setCols(Integer.toString(label.getSize().width / 8));
			model.setRows(Integer.toString(label.getSize().height / 10));
			label.setSize(Integer.parseInt(model.getCols()), Integer
					.parseInt(model.getRows()));
			refreshVisuals();
		} else if (evt.getPropertyName().equals(LetsAjaxTextAreaModel.P_COLS)) {
			Label label = (Label) getFigure();
			LetsAjaxTextAreaModel model = (LetsAjaxTextAreaModel) getModel();
			label.setSize(Integer.parseInt((String) evt.getNewValue()), Integer
					.parseInt(model.getRows()));
		} else if (evt.getPropertyName().equals(LetsAjaxTextAreaModel.P_ROWS)) {
			Label label = (Label) getFigure();
			LetsAjaxTextAreaModel model = (LetsAjaxTextAreaModel) getModel();
			label.setSize(Integer.parseInt(model.getCols()), Integer
					.parseInt((String) evt.getNewValue()));
		} else if (evt.getPropertyName().equals(LetsAjaxTextAreaModel.P_VALUE)) {
			Label label = (Label) getFigure();
			label.setText((String) evt.getNewValue());
		}
	}

	/**
	 * eLXgGA̐
	 * 
	 * @see org.eclipse.gef.editparts.AbstractGraphicalEditPart#createFigure()
	 */
	protected IFigure createFigure() {
		LetsAjaxTextAreaModel model = (LetsAjaxTextAreaModel) getModel();

		Label label = new Label();
		label.setBorder(new CompoundBorder(new LineBorder(),
				new MarginBorder(3)));
		label.setOpaque(true);
		label.setText(model.getValue());
		label.setSize(Integer.parseInt(model.getCols()), Integer.parseInt(model
				.getRows()));
		return label;
	}

	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.COMPONENT_ROLE,
				new LetsAjaxComponentEditPolicy());
		installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE,
				new LetsAjaxDirectEditPolicy());
	}

	protected void refreshVisuals() {
		Rectangle constraint = ((LetsAjaxTextAreaModel) getModel())
				.getConstraint();

		((GraphicalEditPart) getParent()).setLayoutConstraint(this,
				getFigure(), constraint);
	}

	public void performRequest(Request req) {
		if (req.getType().equals(RequestConstants.REQ_DIRECT_EDIT)) {
			performDirectEdit();
			return;
		}
		super.performRequest(req);
	}

	private void performDirectEdit() {
		if (directManager == null) {
			directManager = new LetsAjaxDirectEditManager(this,
					TextCellEditor.class, new LetsAjaxCellEditorLocator(
							getFigure()));
		}
		directManager.show();
	}

}
