package jp.co.cybec.laxide.editParts.extension;

import java.beans.PropertyChangeEvent;
import java.io.InputStream;

import jp.co.cybec.laxide.LetsAjaxEditor;
import jp.co.cybec.laxide.editParts.EditPartWithListener;
import jp.co.cybec.laxide.editParts.LetsAjaxCellEditorLocator;
import jp.co.cybec.laxide.editParts.LetsAjaxDirectEditManager;
import jp.co.cybec.laxide.editpolicies.LetsAjaxComponentEditPolicy;
import jp.co.cybec.laxide.editpolicies.LetsAjaxDirectEditPolicy;
import jp.co.cybec.laxide.model.extension.LetsAjaxDataTableModel;

import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RequestConstants;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Image;

/**
 * f[^e[u`悷NX t@CFLetsAjaxDataTableEditPart.java
 * 
 * @author nakamura 쐬F14:06:55
 * 
 */
public class LetsAjaxDataTableEditPart extends EditPartWithListener {

	private LetsAjaxDirectEditManager directManager = null;

	/**
	 * ɕύXƂʒm郁\bh
	 * 
	 * @see jp.co.cybec.laxide.editParts.EditPartWithListener#propertyChange(java.beans.PropertyChangeEvent)
	 */
	public void propertyChange(PropertyChangeEvent evt) {
		// ύX̌^f̈ʒu̕ύX̂ǂ
		if (evt.getPropertyName().equals(LetsAjaxDataTableModel.P_CONSTRAINT)) {
			refreshVisuals(); // r[XV
		} else if (evt.getPropertyName().equals(LetsAjaxDataTableModel.P_NAME)) {
			// f̕ύXr[ɕ\
			Label label = (Label) getFigure();
			label.setText((String) evt.getNewValue());
		}
	}

	/**
	 * f[^e[u𐶐B
	 * 
	 * @see org.eclipse.gef.editparts.AbstractGraphicalEditPart#createFigure()
	 */
	protected IFigure createFigure() {
		LetsAjaxDataTableModel model = (LetsAjaxDataTableModel) getModel();
		InputStream input = LetsAjaxEditor.class
				.getResourceAsStream("dataTable.gif");

		Image img = new Image(null, input);
		ImageFigure figure = new ImageFigure();
		figure.setBorder(new CompoundBorder(new LineBorder(), new MarginBorder(
				3)));
		figure.setSize(60, 50);
		figure.setImage(img);

		Label mainLabel = new Label();
		// Ogƃ}[W̐ݒ
		mainLabel.setBorder(new CompoundBorder(new LineBorder(),
				new MarginBorder(4)));
		mainLabel.setSize(100, 80);
		mainLabel.setText(model.getName());
		mainLabel.setOpaque(true);
		mainLabel.setLayoutManager(new BorderLayout());
		mainLabel.add(figure, BorderLayout.TOP);

		return mainLabel;
	}

	protected void createEditPolicies() {
		// GfBbg|V[쐬ăCXg[
		installEditPolicy(EditPolicy.COMPONENT_ROLE,
				new LetsAjaxComponentEditPolicy());
		installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE,
				new LetsAjaxDirectEditPolicy());
	}

	protected void refreshVisuals() {
		// ̎擾
		Rectangle constraint = ((LetsAjaxDataTableModel) getModel())
				.getConstraint();

		// RectangleIuWFNg𐧖Ƃăr[ɐݒ肷
		// setLayoutConstraint\bh͐eEditPartĂяo
		((GraphicalEditPart) getParent()).setLayoutConstraint(this,
				getFigure(), constraint);
	}

	public void performRequest(Request req) {
		// RequestfEvpeB̒ڕҏWv̂ǂ
		if (req.getType().equals(RequestConstants.REQ_DIRECT_EDIT)) {
			performDirectEdit();
			return;
		}
		super.performRequest(req);
	}

	private void performDirectEdit() {
		if (directManager == null) {
			directManager = new LetsAjaxDirectEditManager(this,
					TextCellEditor.class, new LetsAjaxCellEditorLocator(
							getFigure()));
		}
		directManager.show(); // ZEGfB^̕\
	}
}
