package jp.co.cybec.laxide.editParts.js;

import java.beans.PropertyChangeEvent;

import jp.co.cybec.laxide.editParts.EditPartWithListener;
import jp.co.cybec.laxide.editParts.LetsAjaxCellEditorLocator;
import jp.co.cybec.laxide.editParts.LetsAjaxDirectEditManager;
import jp.co.cybec.laxide.editpolicies.LetsAjaxComponentEditPolicy;
import jp.co.cybec.laxide.editpolicies.LetsAjaxDirectEditPolicy;
import jp.co.cybec.laxide.model.base.LetsAjaxChartModel;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RequestConstants;
import org.eclipse.jface.viewers.TextCellEditor;

/**
 * `[g`悷NX t@CFLetsAjaxChartEditPart.java
 * 
 * @author nakamura 쐬F14:16:24
 * 
 */
public class LetsAjaxChartEditPart extends EditPartWithListener {

	private LetsAjaxDirectEditManager directManager = null;

	/**
	 * ɕύXƂʒm郁\bh
	 * 
	 * @see jp.co.cybec.laxide.editParts.EditPartWithListener#propertyChange(java.beans.PropertyChangeEvent)
	 */
	public void propertyChange(PropertyChangeEvent evt) {
		LetsAjaxChartModel model = (LetsAjaxChartModel) getModel();
		Label label = (Label) getFigure();

		// ύX̌^f̈ʒu̕ύX̂ǂ
		if (evt.getPropertyName().equals(LetsAjaxChartModel.P_CONSTRAINT)) {
			int textWidth = label.getTextBounds().width;
			label.getSize().width = textWidth;

			model.getConstraint().width = label.getSize().width;
			model.getConstraint().height = label.getSize().height;

			refreshVisuals(); // r[XV
		} else if (evt.getPropertyName()
				.equals(LetsAjaxChartModel.P_CHART_TYPE)) {
			// f̃eLXgύXꂽ̂Ńr[ɕ\eLXgXV
			int chartTypeIndex = ((Integer) evt.getNewValue()).intValue();
			label.setText(model.getChartTypeString(chartTypeIndex));

		} else if (evt.getPropertyName().equals(LetsAjaxChartModel.P_HIGHT)) {
			label.setSize(Integer.parseInt(model.getWidth()), Integer
					.parseInt((String) evt.getNewValue()));

		} else if (evt.getPropertyName().equals(LetsAjaxChartModel.P_WIDTH)) {
			label.setSize(Integer.parseInt((String) evt.getNewValue()), Integer
					.parseInt(model.getHeight()));
		}
	}

	/**
	 * `[g`悷NX
	 * 
	 * @see org.eclipse.gef.editparts.AbstractGraphicalEditPart#createFigure()
	 */
	protected IFigure createFigure() {
		LetsAjaxChartModel model = (LetsAjaxChartModel) getModel();

		Label label = new Label();
		label.setText(model.getChartTypeString(model.getChartType()));

		// wiFs
		label.setOpaque(true);
		label.setSize(60, 50);
		label.setBorder(new LineBorder());
		label.setBackgroundColor(ColorConstants.orange);
		return label;
	}

	protected void createEditPolicies() {
		// GfBbg|V[쐬ăCXg[
		installEditPolicy(EditPolicy.COMPONENT_ROLE,
				new LetsAjaxComponentEditPolicy());
		installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE,
				new LetsAjaxDirectEditPolicy());
	}

	protected void refreshVisuals() {
		// ̎擾
		Rectangle constraint = ((LetsAjaxChartModel) getModel())
				.getConstraint();

		// RectangleIuWFNg𐧖Ƃăr[ɐݒ肷
		// setLayoutConstraint\bh͐eEditPartĂяo
		((GraphicalEditPart) getParent()).setLayoutConstraint(this,
				getFigure(), constraint);
	}

	public void performRequest(Request req) {
		// RequestfEvpeB̒ڕҏWv̂ǂ
		if (req.getType().equals(RequestConstants.REQ_DIRECT_EDIT)) {

			performDirectEdit();
			return;
		}
		super.performRequest(req);
	}

	private void performDirectEdit() {
		if (directManager == null) {
			directManager = new LetsAjaxDirectEditManager(this,
					TextCellEditor.class, new LetsAjaxCellEditorLocator(
							getFigure()));
		}
		directManager.show(); // ZEGfB^̕\
	}
}
