package jp.co.cybec.laxide.editParts.js;

import java.beans.PropertyChangeEvent;

import jp.co.cybec.laxide.editParts.EditPartWithListener;
import jp.co.cybec.laxide.editParts.LetsAjaxCellEditorLocator;
import jp.co.cybec.laxide.editParts.LetsAjaxDirectEditManager;
import jp.co.cybec.laxide.editpolicies.LetsAjaxComponentEditPolicy;
import jp.co.cybec.laxide.editpolicies.LetsAjaxDirectEditPolicy;
import jp.co.cybec.laxide.model.js.LetsAjaxJSControlModel;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RequestConstants;
import org.eclipse.jface.viewers.TextCellEditor;

/**
 * WIJavaScript𐶐NX t@CFLetsAjaxJSControlEditPart.java
 * 
 * @author nakamura 쐬F14:26:20
 * 
 */
public class LetsAjaxJSControlEditPart extends EditPartWithListener {
	private LetsAjaxDirectEditManager directManager = null;

	/**
	 * ɕύXƂʒm郁\bh
	 * 
	 * @see jp.co.cybec.laxide.editParts.EditPartWithListener#propertyChange(java.beans.PropertyChangeEvent)
	 */
	public void propertyChange(PropertyChangeEvent evt) {
		// ύX̌^f̈ʒu̕ύX̂ǂ
		if (evt.getPropertyName().equals(LetsAjaxJSControlModel.P_CONSTRAINT)) {
			refreshVisuals(); // r[XV
		} else if (evt.getPropertyName()
				.equals(LetsAjaxJSControlModel.P_JSNAME)) {
			Label label = (Label) getFigure();
			label.setText((String) evt.getNewValue());
		}
	}

	/**
	 * JavaScript𐶐
	 * 
	 * @see org.eclipse.gef.editparts.AbstractGraphicalEditPart#createFigure()
	 */
	protected IFigure createFigure() {
		LetsAjaxJSControlModel model = (LetsAjaxJSControlModel) getModel();

		Label label = new Label();
		label.setText(model.getComponentId());

		// Ogƃ}[W̐ݒ
		LineBorder border = new LineBorder();
		label.setBorder(new CompoundBorder(border, new MarginBorder(3)));

		label.setBackgroundColor(ColorConstants.orange);
		// wiFs
		label.setOpaque(true);
		label.setSize(60, 50);
		return label;
	}

	protected void refreshVisuals() {
		// ̎擾
		Rectangle constraint = ((LetsAjaxJSControlModel) getModel())
				.getConstraint();

		// RectangleIuWFNg𐧖Ƃăr[ɐݒ肷
		// setLayoutConstraint\bh͐eEditPartĂяo
		((GraphicalEditPart) getParent()).setLayoutConstraint(this,
				getFigure(), constraint);
	}

	protected void createEditPolicies() {
		// GfBbg|V[쐬ăCXg[
		installEditPolicy(EditPolicy.COMPONENT_ROLE,
				new LetsAjaxComponentEditPolicy());
		installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE,
				new LetsAjaxDirectEditPolicy());
	}

	public void performRequest(Request req) {
		// RequestfEvpeB̒ڕҏWv̂ǂ
		if (req.getType().equals(RequestConstants.REQ_DIRECT_EDIT)) {
			performDirectEdit();
			return;
		}
		super.performRequest(req);
	}

	private void performDirectEdit() {
		if (directManager == null) {
			directManager = new LetsAjaxDirectEditManager(this,
					TextCellEditor.class, new LetsAjaxCellEditorLocator(
							getFigure()));
		}
		directManager.show(); // ZEGfB^̕\
	}

}
