package jp.co.cybec.laxide.editParts.js;

import java.beans.PropertyChangeEvent;

import jp.co.cybec.laxide.editParts.EditPartWithListener;
import jp.co.cybec.laxide.editParts.LetsAjaxCellEditorLocator;
import jp.co.cybec.laxide.editParts.LetsAjaxDirectEditManager;
import jp.co.cybec.laxide.editpolicies.LetsAjaxComponentEditPolicy;
import jp.co.cybec.laxide.editpolicies.LetsAjaxDirectEditPolicy;
import jp.co.cybec.laxide.model.js.YuiColorAnimateJSModel;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RequestConstants;
import org.eclipse.jface.viewers.TextCellEditor;

/**
 * YahooUĨJ[Aj[VJavaScript𐶐B t@CFYuiColorAnimateJSEditPart.java
 * 
 * @author nakamura 쐬F14:38:31
 * 
 */
public class YuiColorAnimateJSEditPart extends EditPartWithListener {
	private LetsAjaxDirectEditManager directManager = null;

	/**
	 * ɕύXƂʒm郁\bh
	 * 
	 * @see jp.co.cybec.laxide.editParts.EditPartWithListener#propertyChange(java.beans.PropertyChangeEvent)
	 */
	public void propertyChange(PropertyChangeEvent evt) {
		// ύX̌^f̈ʒu̕ύX̂ǂ
		if (evt.getPropertyName().equals(YuiColorAnimateJSModel.P_CONSTRAINT)) {
			refreshVisuals(); // r[XV
		} else if (evt.getPropertyName().equals(
				YuiColorAnimateJSModel.P_TARGET_ID)) {
			// f̃eLXgύXꂽ̂Ńr[ɕ\eLXgXV
			Label label = (Label) getFigure();
			((Label) label.getChildren().get(1)).setText((String) evt
					.getNewValue());
		}
	}

	/**
	 * JavaScript𐶐
	 * 
	 * @see org.eclipse.gef.editparts.AbstractGraphicalEditPart#createFigure()
	 */
	protected IFigure createFigure() {
		YuiColorAnimateJSModel model = (YuiColorAnimateJSModel) getModel();

		Label typeLabel = new Label();
		typeLabel.setText(model.getType());
		typeLabel.setOpaque(true);
		typeLabel.setSize(80, 30);
		typeLabel.setBorder(new CompoundBorder(new LineBorder(),
				new MarginBorder(3)));

		Label label = new Label();
		label.setText(model.getTargetId());
		label.setOpaque(true);
		label.setSize(80, 30);
		label.setBorder(new CompoundBorder(new LineBorder(),
				new MarginBorder(3)));

		// Ogƃ}[W̐ݒ
		Label parentLabel = new Label();
		parentLabel.setBorder(new CompoundBorder(new LineBorder(),
				new MarginBorder(3)));
		parentLabel.setLayoutManager(new ToolbarLayout());
		parentLabel.setBackgroundColor(ColorConstants.orange);
		// wiFs
		parentLabel.setOpaque(true);
		parentLabel.setSize(80, 80);
		parentLabel.add(typeLabel);
		parentLabel.add(label);

		return parentLabel;
	}

	protected void refreshVisuals() {
		// ̎擾
		Rectangle constraint = ((YuiColorAnimateJSModel) getModel())
				.getConstraint();

		// RectangleIuWFNg𐧖Ƃăr[ɐݒ肷
		// setLayoutConstraint\bh͐eEditPartĂяo
		((GraphicalEditPart) getParent()).setLayoutConstraint(this,
				getFigure(), constraint);
	}

	protected void createEditPolicies() {
		// GfBbg|V[쐬ăCXg[
		installEditPolicy(EditPolicy.COMPONENT_ROLE,
				new LetsAjaxComponentEditPolicy());
		installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE,
				new LetsAjaxDirectEditPolicy());
	}

	public void performRequest(Request req) {
		// RequestfEvpeB̒ڕҏWv̂ǂ
		if (req.getType().equals(RequestConstants.REQ_DIRECT_EDIT)) {
			performDirectEdit();
			return;
		}
		super.performRequest(req);
	}

	private void performDirectEdit() {
		if (directManager == null) {
			directManager = new LetsAjaxDirectEditManager(this,
					TextCellEditor.class, new LetsAjaxCellEditorLocator(
							getFigure()));
		}
		directManager.show(); // ZEGfB^̕\
	}

}
