package jp.co.cybec.laxide.model.base;

import jp.co.cybec.laxide.util.LetsAjaxUtil;

import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.jdom.Element;

/**
 * R{{bNX̃fNX
 * 
 * @author tokumaru
 */
public class LetsAjaxComboBoxModel extends BaseModel {
	private String name = "name";

	public static final String P_NAME = "_name";

	private String defaultValue = "defaultValue";

	public static final String P_DEFAULTVALUE = "_defaultValue";

	private int isMultiple;

	private String multipleValues[] = { "true", "false" };

	public static final String P_ISMULTIPLE = "_isMultiple";

	private String size = "1";

	public static final String P_SIZE = "_size";

	private String componentWidth = "80";

	private String componentHeight = "20";

	public static final String P_EVENT = "_event";

	public static final String P_DATASOURCE_ID = "_dataSourceId";

	private String dataSourceId = "dataSourceId";

	private int eventId = 1;

	private String events[] = { "", "onClick", "onDblClick ", "onMouseDown",
			"onKeyDown", "onKeyPress", "onKeyUp", "onMouseDown", "onMouseUp",
			"onMouseOver", "onMouseOut", "onMouseMove", "onChange", "onSelect" };

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.BaseModel#getBodyComponentXml()
	 */
	@Override
	public String getBodyComponentXml() {
		String html = "";
		html = html + getNameForXml();
		html = html + getDefaultValueForXml();
		html = html + getIsMultipleForXml();
		html = html + getSizeForXml();
		html = html + this.getComponetWidthForXml();
		html = html + this.getComponetHeightForXml();
		html = html + this.getCssClassNameForXml();
		html = html + this.getEventForXml();
		html = html + this.getDataSourceIdForXml();
		return html;
	}

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#setAttribute(org.jdom.Element)
	 */
	@Override
	public void setAttribute(Element element) {
		super.setAttribute(element);
		super.setType(LetsAjaxLayoutConstant.LETSAJAX_BODY_COMBO_BOX);
		setName(element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_NAME));
		setSize(element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_SIZE));
		String multiple = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_IS_MULTIPLE);
		if (multiple != null && multiple.equals("true")) {
			setIsMultiple(1);
		} else {
			setIsMultiple(0);
		}

		setDefaultValue(element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_DEFAULTVALUE));
		String event = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_EVENT);
		String dataSourceId = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_DATASOURCEID);
		String cssClass = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_CLASSNAME);
		
		setCssClassName(cssClass);

		setDataSourceId(dataSourceId);
		setEventId(1);
		for (int i = 0; i < events.length; i++) {
			if (event != null && event.equals(events[i])) {
				setEventId(i + 1);
				break;
			}
		}
	}

	/**
	 * R{{bNXݒ肵܂
	 * 
	 * @param value
	 */
	public void setName(String value) {
		this.name = LetsAjaxUtil.checkNull(value);
		firePropertyChange(P_NAME, null, this.name);
	}

	/**
	 * R{{bNX擾܂
	 * 
	 * @return R{{bNX
	 */
	public String getName() {
		return this.name;
	}

	/**
	 * .laxt@Cɐݒ肷邽߂̃R{{bNXԂ܂
	 * 
	 * @return .laxt@Cɐݒ肷邽߂̃R{{bNX
	 */
	private String getNameForXml() {
		if (this.name == null || (this.name != null && this.name.equals(""))) {
			return "";
		}
		return " name=\"" + this.name + "\" ";
	}

	/**
	 * ftHglݒ肵܂
	 * 
	 * @param value ftHgl
	 */
	public void setDefaultValue(String value) {
		this.defaultValue = value;
		firePropertyChange(P_DEFAULTVALUE, null, value);
	}

	/**
	 * ftHglݒ肵܂
	 * 
	 * @return ftHgl
	 */
	public String getDefaultValue() {
		return this.defaultValue;
	}

	/**
	 * .laxt@Cɐݒ肷邽߂̃ftHglԂ܂
	 * 
	 * @return .laxt@Cɐݒ肷邽߂̃ftHgl
	 */
	private String getDefaultValueForXml() {
		if (this.defaultValue == null
				|| (this.defaultValue != null && this.defaultValue.equals(""))) {
			return "";
		}
		return " defaultValue=\"" + this.defaultValue + "\" ";
	}

	/**
	 * i̕Ԃ܂
	 * 
	 * @return i̕
	 */
	public String getComponentWidth() {
		return this.componentWidth;
	}

	/**
	 * i̕ݒ肵܂
	 * 
	 * @param width i̕
	 */
	public void setComponentWidth(String width) {
		this.componentWidth = width;
	}

	/**
	 * .laxt@Cɐݒ肷邽߂̕i̕Ԃ܂
	 * 
	 * @return .laxt@Cɐݒ肷邽߂̕i̕
	 */
	private String getComponetWidthForXml() {
		if (componentWidth == null
				|| (componentWidth != null && componentWidth.equals(""))) {
			return " componentWidth=\""
					+ Integer.toString(this.defaultValue.length() * 5) + "\"";
		}
		return " componentWidth=\"" + this.componentWidth + "\" ";
	}

	/**
	 * i̍Ԃ܂
	 * 
	 * @return i̍
	 */
	public String getComponetHeight() {
		return this.componentHeight;
	}

	/**
	 * i̍ݒ肵܂
	 * 
	 * @param componentHeight i̍
	 */
	public void setComponentHeight(String componentHeight) {
		this.componentHeight = componentHeight;
	}

	/**
	 * .laxt@Cɐݒ肷邽߂̕i̍Ԃ܂
	 * 
	 * @return .laxt@Cɐݒ肷邽߂̕i̍
	 */
	private String getComponetHeightForXml() {
		if (componentHeight == null
				|| (componentHeight != null && componentHeight.equals(""))) {
			return " componentHeight=\"20\"";
		}
		return " componentHeight=\"" + this.componentHeight + "\" ";
	}

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getPropertyDescriptors()
	 */
	public IPropertyDescriptor[] getPropertyDescriptors() {
		IPropertyDescriptor[] descriptors = new IPropertyDescriptor[] {
				new TextPropertyDescriptor(P_ID, "ID"),
				new TextPropertyDescriptor(P_NAME, ""),
				new TextPropertyDescriptor(P_SIZE, "TCY"),
				new ComboBoxPropertyDescriptor(P_ISMULTIPLE, "I",
						multipleValues),
				new TextPropertyDescriptor(P_DEFAULTVALUE, "l"),
				new TextPropertyDescriptor(P_CLASS_NAME, "CSSNX"),
				new ComboBoxPropertyDescriptor(P_EVENT, "Cxg", events),
				new TextPropertyDescriptor(P_DATASOURCE_ID, "DATASOURCEID") };
		return descriptors;
	}

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getPropertyValue(java.lang.Object)
	 */
	public Object getPropertyValue(Object id) {
		if (id.equals(super.P_ID)) {
			return super.id;
		} else if (id.equals(P_NAME)) {
			return this.name;
		} else if (id.equals(P_DEFAULTVALUE)) {
			return this.defaultValue;
		} else if (id.equals(P_SIZE)) {
			return this.size;
		} else if (id.equals(P_ISMULTIPLE)) {
			return new Integer(this.isMultiple - 1);
		} else if (id.equals(P_EVENT)) {
			return new Integer(this.eventId - 1);
		} else if (id.equals(P_DATASOURCE_ID)) {
			return dataSourceId;
		} else if (id.equals(P_CLASS_NAME)) {
			return getCssClassName();
		}
		
		return null;
	}

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#isPropertySet(java.lang.Object)
	 */
	public boolean isPropertySet(Object id) {
		if (id.equals(P_NAME) || id.equals(P_DEFAULTVALUE)
				|| id.equals(P_SIZE) || id.equals(P_ISMULTIPLE)
				|| id.equals(P_EVENT) || id.equals(P_DATASOURCE_ID) || id.equals(P_CLASS_NAME)) {
			return true;
		} else {
			return false;
		}
	}

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#setPropertyValue(java.lang.Object, java.lang.Object)
	 */
	public void setPropertyValue(Object id, Object value) {
		if (id.equals(P_NAME)) {
			setName((String) value);
		} else if (id.equals(P_DEFAULTVALUE)) {
			setDefaultValue((String) value);
		} else if (id.equals(P_SIZE)) {
			setSize(LetsAjaxUtil.getDigitValue(this.size, (String) value));
		} else if (id.equals(P_ISMULTIPLE)) {
			setIsMultiple(((Integer) value).intValue() + 1);
		} else if (id.equals(P_EVENT)) {
			setEventId(((Integer) value).intValue() + 1);
		} else if (id.equals(P_DATASOURCE_ID)) {
			setDataSourceId((String) value);
		} else if (id.equals(P_CLASS_NAME)) {
			setCssClassName((String) value);
		}
	}

	/**
	 * I\ǂ(multiple)Ԃ܂<br>
	 * 1:I<br>
	 * 2:Is
	 * 
	 * @return isMultiple
	 */
	public int getIsMultiple() {
		return isMultiple;
	}

	/**
	 * I\ǂ(multiple)ݒ肵܂<br>
	 * 1:I<br>
	 * 2:Is
	 * 
	 * @param isMultiple I\ǂ
	 */
	public void setIsMultiple(Integer multiple) {
		this.isMultiple = multiple;
		firePropertyChange(P_ISMULTIPLE, null, this.isMultiple);
	}

	/**
	 * .laxt@Cɐݒ肷邽߂multipleԂ܂
	 * 
	 * @return .laxt@Cɐݒ肷邽߂multiple
	 */
	private String getIsMultipleForXml() {
		String multipleFlag = "false";
		if (this.isMultiple == 1) {
			multipleFlag = "true";
		}
		return " " + LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_IS_MULTIPLE
				+ "=\"" + multipleFlag + "\" ";
	}

	/**
	 * TCYԂ܂
	 * 
	 * @return size TCY
	 */
	public String getSize() {
		return size;
	}

	/**
	 * TCYݒ肵܂
	 * 
	 * @param size TCY
	 */
	public void setSize(String size) {
		this.size = size;
		firePropertyChange(P_SIZE, null, size);
	}

	/**
	 * .laxt@Cɐݒ肷邽߂̃TCYԂ܂
	 * 
	 * @return .laxt@Cɐݒ肷邽߂̃TCY
	 */
	private String getSizeForXml() {
		if (this.size == null || (this.size != null && this.size.equals(""))) {
			return "";
		}
		return " size=\"" + this.size + "\" ";
	}

	/**
	 * f[^\[XIDԂ܂
	 * 
	 * @return dataSourceId f[^\[XID
	 */
	public String getDataSourceId() {
		return dataSourceId;
	}

	/**
	 * f[^\[XIDԂ܂
	 * 
	 * @param dataSourceId
	 *            dataSourceId ݒB
	 */
	public void setDataSourceId(String dataSourceId) {
		this.dataSourceId = LetsAjaxUtil.checkNull(dataSourceId);
		firePropertyChange(P_DATASOURCE_ID, null, this.dataSourceId);
	}

	/**
	 * .laxt@Cɐݒ肷邽߂̃f[^\[XIDԂ܂
	 * 
	 * @return .laxt@Cɐݒ肷邽߂̃f[^\[XID
	 */
	private String getDataSourceIdForXml() {
		if (this.dataSourceId == null
				|| (this.dataSourceId != null && this.dataSourceId.equals(""))) {
			return "";
		}
		return " dataSourceId=\"" + this.dataSourceId + "\"";
	}

	/**
	 * CxgIDԂ܂
	 * 
	 * @return event CxgID
	 */
	public int getEventId() {
		return eventId;
	}

	/**
	 * CxgIDݒ肵܂
	 * 
	 * @param event CxgID
	 */
	public void setEventId(Integer eventId) {
		this.eventId = LetsAjaxUtil.checkNull(eventId);
		firePropertyChange(P_EVENT, null, this.eventId);
	}

	/**
	 * .laxt@Cɐݒ肷邽߂̃CxgIDԂ܂
	 * 
	 * @return CxgID
	 */
	private String getEventForXml() {
		return " event=\"" + events[eventId - 1] + "\"";
	}
}
