package jp.co.cybec.laxide.model.base;

import jp.co.cybec.laxide.util.LetsAjaxUtil;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.jdom.Element;

/**
 * eLXgtB[h̃fNX
 * 
 * @author tokumaru
 */
public class LetsAjaxTextFieldModel extends BaseModel {

	public static final String P_VALUE = "_value";

	public static final String P_NAME = "_name";

	public static final String P_SIZE = "_size";

	public static final String P_LENGTH = "_length";

	public static final String P_EVENT = "_event";

	public static final String P_DATASOURCE_ID = "_dataSourceId";

	private String name = "TextFeild";

	private String value = "TextField1";

	private String size = "100";

	private String length = "10";

	private String dataSourceId = "dataSourceId";

	private int eventId = 1;

	private String events[] = { "","onClick", "onDblClick ", "onMouseDown",
			"onKeyDown", "onKeyPress", "onKeyUp", "onMouseDown", "onMouseUp",
			"onMouseOver", "onMouseOut", "onMouseMove", "onChange", "onSelect" };

	// 
	/**
	 * manelԂ܂
	 * 
	 * @return manel
	 */
	public String getName() {
		return this.name;
	}

	/**
	 * .laxt@Cɐݒ肷邽߂namelԂ܂
	 * 
	 * @return .laxt@Cɐݒ肷邽߂namel 
	 */
	private String getNameForXml() {
		if (name == null || (name != null && name.equals(""))) {
			return "";
		}
		return " name=\"" + this.name + "\" ";
	}

	/**
	 * namelݒ肵܂
	 * 
	 * @param name namel
	 */
	public void setName(String name) {
		this.name = LetsAjaxUtil.checkNull(name);
		firePropertyChange(P_NAME, null, value);
	}

	/**
	 * ValuelԂ܂
	 * 
	 * @return value Valuel
	 */
	public String getValue() {
		return this.value;
	}

	/**
	 * .laxt@Cɐݒ肷邽߂ValuelԂ܂
	 * 
	 * @return .laxt@Cɐݒ肷邽߂Valuel
	 */
	private String getValueForXml() {
		if (value == null || (value != null && value.equals(""))) {
			return "";
		}
		return " value=\"" + this.value + "\"";
	}

	/**
	 * Valuelݒ肵܂
	 * 
	 * @param value Valuel
	 */
	public void setValue(String value) {
		this.value = LetsAjaxUtil.checkNull(value);
		firePropertyChange(P_VALUE, null, this.value);
	}

	/**
	 * lengthlԂ܂
	 * 
	 * @return length lengthl
	 */
	public String getLength() {
		return this.length;
	}

	/**
	 * .laxt@Cɐݒ肷邽߂lengthlԂ܂
	 * 
	 * @return .laxt@Cɐݒ肷邽߂lengthl
	 */
	private String getLengthForXml() {
		if (length == null || (length != null && length.equals(""))) {
			return "";
		}
		return " length=\"" + this.length + "\"";
	}

	/**
	 * lengthlݒ肵܂
	 * 
	 * @param length lengthl
	 */
	public void setLength(String length) {
		this.length = length;
		firePropertyChange(P_LENGTH, null, length);
	}

	/**
	 * sizelԂ܂
	 * 
	 * @return size sizel
	 */
	public String getSize() {
		return this.size;
	}

	/**
	 * .laxɐݒ肷sizeԂ܂
	 * 
	 * @return .laxɐݒ肷size
	 */
	private String getSizeForXml() {
		if (size == null || (size != null && size.equals(""))) {
			return "";
		}
		return " size=\"" + this.size + "\"";
	}

	/**
	 * eLXgtB[h̕ݒ肵܂B
	 * ܂AIuWFNgɍݒ肷邱Ƃɂ
	 * }EXɂ傫ύXɐ܂B
	 * 
	 * @param size
	 */
	public void setSize(String size) {
		this.size = size;
		
		if (getConstraint() != null) {
			// RRŐɍݒ肷邱Ƃɂă}EXł̑傫ύXsɂĂ
			getConstraint().width = Integer.parseInt(size);
			getConstraint().height = 20;
		}
		firePropertyChange(P_SIZE, null, size);
	}

	// ܂

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getPropertyDescriptors()
	 */
	public IPropertyDescriptor[] getPropertyDescriptors() {
		IPropertyDescriptor[] descriptors = new IPropertyDescriptor[] {
				new TextPropertyDescriptor(P_ID, "ID"),
				new TextPropertyDescriptor(P_VALUE, "VALUE"),
				new TextPropertyDescriptor(P_NAME, "NAME"),
				new TextPropertyDescriptor(P_SIZE, "SIZE"),
				new TextPropertyDescriptor(P_LENGTH, "LENGTH"),
				new TextPropertyDescriptor(P_CLASS_NAME, "CSSNX"),
				new ComboBoxPropertyDescriptor(P_EVENT, "Cxg", events),
				new TextPropertyDescriptor(P_DATASOURCE_ID, "DATASOURCEID") };
		return descriptors;

	}

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getPropertyValue(java.lang.Object)
	 */
	public Object getPropertyValue(Object id) {
		if (id.equals(P_ID)) {
			return super.id;
		} else if (id.equals(P_VALUE)) {
			return value;
		} else if (id.equals(P_NAME)) {
			return name;
		} else if (id.equals(P_SIZE)) {
			return size;
		} else if (id.equals(P_LENGTH)) {
			return length;
		} else if (id.equals(P_EVENT)) {
			return new Integer(this.eventId - 1);
		} else if (id.equals(P_DATASOURCE_ID)) {
			return dataSourceId;
		} else if (id.equals(P_CLASS_NAME)) {
			return getCssClassName();
		}
		
		return null;
	}

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#isPropertySet(java.lang.Object)
	 */
	public boolean isPropertySet(Object id) {
		if (id.equals(P_VALUE) || id.equals(P_NAME) || id.equals(P_SIZE)
				|| id.equals(P_LENGTH) || id.equals(P_EVENT)
				|| id.equals(P_DATASOURCE_ID) || id.equals(P_CLASS_NAME)) {
			return true;
		} else {
			return false;
		}
	}

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#setPropertyValue(java.lang.Object, java.lang.Object)
	 */
	public void setPropertyValue(Object id, Object value) {
		if (id.equals(P_VALUE)) {
			setValue((String) value);
		} else if (id.equals(P_NAME)) {
			setName((String) value);
		} else if (id.equals(P_SIZE)) {
			// lł΃vpeBɃZbg
			setSize(LetsAjaxUtil.getDigitValue(this.size, (String)value));
		} else if (id.equals(P_LENGTH)) {
//			 lł΃vpeBɃZbg
			setLength(LetsAjaxUtil.getDigitValue(this.length, (String)value));
		} else if (id.equals(P_EVENT)) {
			setEventId(((Integer) value).intValue() + 1);
		} else if (id.equals(P_DATASOURCE_ID)) {
			setDataSourceId((String) value);
		} else if (id.equals(P_CLASS_NAME)) {
			setCssClassName((String) value);
		}
	}

	/**
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getBodyComponentXml()
	 */
	@Override
	public String getBodyComponentXml() {
		return getNameForXml() + getValueForXml() + getLengthForXml()
				+ getSizeForXml() + getEventForXml() + getDataSourceIdForXml();
	}

	/**
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#setAttribute(org.jdom.Element)
	 */
	@Override
	public void setAttribute(Element element) {
		String id = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_ID);

		String positoinX = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_X);
		int x = 0;
		if (positoinX != null) {
			x = Integer
					.parseInt(element
							.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_X));
		}

		String positionY = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_Y);
		int y = 0;
		if (positionY != null) {
			y = Integer
					.parseInt(element
							.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_Y));
		}

		String size = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_SIZE);

		String length = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_LENGTH);
		String name = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_NAME);
		String value = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_VALUE);
		String event = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_EVENT);
		String dataSourceId = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_DATASOURCEID);
		
		String cssClass = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_CLASSNAME);

		setId(id);
		setType(LetsAjaxLayoutConstant.LETSAJAX_BODY_TEXTFIELD);
		setValue(value);
		setName(name);
		setSize(size);
		setLength(length);
		setDataSourceId(dataSourceId);
		setCssClassName(cssClass);
		
		setEventId(1);
		for (int i = 0; i < events.length; i++) {
			if (event != null && event.equals(events[i])) {
				setEventId(i + 1);
				break;
			}
		}

		setConstraint(new Rectangle(x, y, Integer.parseInt(size), 20));
	}

	/**
	 * f[^\[XIDԂ܂
	 * 
	 * @return dataSourceId f[^\[XID
	 */
	public String getDataSourceId() {
		return dataSourceId;
	}

	/**
	 * f[^\[XIDݒ肵܂
	 * 
	 * @param dataSourceId f[^\[XID
	 */
	public void setDataSourceId(String dataSourceId) {
		this.dataSourceId = LetsAjaxUtil.checkNull(dataSourceId);
		firePropertyChange(P_DATASOURCE_ID, null, this.dataSourceId);
	}

	/**
	 * .laxt@Cɐݒ肷f[^\[XIDԂ܂
	 * 
	 * @return .laxt@Cɐݒ肷f[^\[XID
	 */
	private String getDataSourceIdForXml() {
		if (this.dataSourceId == null
				|| (this.dataSourceId != null && this.dataSourceId.equals(""))) {
			return "";
		}
		return " dataSourceId=\"" + this.dataSourceId + "\"";
	}

	/**
	 * CxgIDԂ܂B
	 * 
	 * @return event CxgID
	 */
	public int getEventId() {
		return eventId;
	}

	/**
	 * CxgIDݒ肵܂
	 * 
	 * @param event CxgID
	 */
	public void setEventId(Integer eventId) {
		this.eventId = LetsAjaxUtil.checkNull(eventId);
		firePropertyChange(P_EVENT, null, this.eventId);
	}

	/**
	 * .laxt@Cɐݒ肷邽߂̃CxgIDԂ܂
	 * 
	 * @return .laxt@Cɐݒ肷邽߂̃CxgID
	 */
	private String getEventForXml() {
		return " event=\"" + events[eventId - 1] + "\"";
	}
}
