package jp.co.cybec.laxide.model.base;

import jp.co.cybec.laxide.util.LetsAjaxUtil;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.jdom.Element;

/**
 * eLXg̃fNX
 * 
 * @author tokumaru
 */
public class LetsAjaxTextModel extends BaseModel {

	public static final String P_VALUE = "_value";

	public static final String P_WIDTH = "_componentWidth";
	
	public static final int COMPONENT_WIDTH_LATE = 12;

	private String value = "TEXT";

	private String componentWidth = "-1";

	private String componentHeight = "20";

	/**
	 * ValuelԂ܂
	 * 
	 * @return Valuel
	 */
	public String getValue() {
		return this.value;
	}

	/**
	 * .laxt@Cɕۑ邽߂valuelԂ܂B
	 * 
	 * @return
	 */
	private String getValueForXml() {
		if (value == null || (value != null && value.equals(""))) {
			return "";
		}
		return " value=\"" + this.value + "\" ";
	}

	/**
	 * Valuelݒ肵܂
	 * 
	 * @param text
	 */
	public void setValue(String text) {
		this.value = LetsAjaxUtil.checkNull(text);
		getConstraint().width = -1;
		firePropertyChange(P_VALUE, null, this.value);
	}

	/**
	 * i̕Ԃ܂B
	 * 
	 * @return i̕
	 */
	public String getComponentWidth() {
		return this.componentWidth;
	}

	/**
	 * i̕ݒ肵܂B
	 * 
	 * @param width
	 *            i̕
	 */
	public void setComponentWidth(String width) {
		this.componentWidth = width;
	}

	/**
	 * .laxt@Cɕۑ邽߂̕i̕Ԃ܂B
	 * 
	 * @return i̕
	 */
	private String getComponetWidthForXml() {
		String result = "";

		if (componentWidth == null
				|| (componentWidth != null && componentWidth.equals(""))) {
			result = " componentWidth=\""
					+ Integer.toString(this.value.length() * 5) + "\"";
		}
		result = " componentWidth=\"" + this.componentWidth + "\" ";
		
		return result;
	}

	/**
	 * .laxt@Cɕۑ邽߂̕i̍Ԃ܂B
	 * 
	 * @return i̍
	 */
	private String getComponetHeightForXml() {
		if (componentHeight == null
				|| (componentHeight != null && componentHeight.equals(""))) {
			return " componentHeight=\"20\"";
		}
		return " componentHeight=\"" + this.componentHeight + "\" ";
	}

	/**
	 * i̍Ԃ܂B
	 * 
	 * @return i̍
	 */
	public String getComponetHeight() {
		return this.componentHeight;
	}

	/**
	 * i̍ݒ肵܂B
	 * 
	 * @param componentHeight
	 *            i̍
	 */
	public void setComponentHeight(String componentHeight) {
		this.componentHeight = componentHeight;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getPropertyDescriptors()
	 */
	public IPropertyDescriptor[] getPropertyDescriptors() {
		IPropertyDescriptor[] descriptors = new IPropertyDescriptor[] {
				new TextPropertyDescriptor(P_ID, "ID"),
				new TextPropertyDescriptor(P_VALUE, "eLXg") };
		return descriptors;

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getPropertyValue(java.lang.Object)
	 */
	public Object getPropertyValue(Object id) {
		if (id.equals(super.P_ID)) {
			return super.id;
		}
		if (id.equals(P_VALUE)) {
			return value;
		}

		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#isPropertySet(java.lang.Object)
	 */
	public boolean isPropertySet(Object id) {
		if (id.equals(P_VALUE)) {
			return true;
		} else {
			return false;
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#setPropertyValue(java.lang.Object,
	 *      java.lang.Object)
	 */
	public void setPropertyValue(Object id, Object value) {
		if (id.equals(P_VALUE)) {
			// eLXgύX
			setValue((String) value);
		}
	}

	/**
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getBodyComponentXml()
	 */
	@Override
	public String getBodyComponentXml() {
		StringBuilder builder = new StringBuilder();
		builder.append(getValueForXml());
		builder.append(this.getComponetWidthForXml());
		builder.append(this.getComponetHeightForXml());
		return builder.toString();

	}

	/**
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#setAttribute(org.jdom.Element)
	 */
	@Override
	public void setAttribute(Element element) {
		super.setAttribute(element);
		String value = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_VALUE);

		setType(LetsAjaxLayoutConstant.LETSAJAX_BODY_TEXT);

		this.setValue(value);
	}

}
