/**
 * vWFNg laxIde
 * NX YuiCalendarModel.java
 * 쐬: 2007/06/07
 * 
 */
package jp.co.cybec.laxide.model.extension;

import jp.co.cybec.laxide.model.base.BaseModel;
import jp.co.cybec.laxide.model.base.LetsAjaxLayoutConstant;

import org.jdom.Element;

/**
 * YahooUĨJ_NXp̃fNX t@CFYuiCalendarModel.java
 * 
 * @author nakamura 쐬F15:33:58
 * 
 */
public class YuiCalendarModel extends BaseModel {

	public static final String P_TARGET_ID = "_targetId";

	private String targetId = super.id;

	/**
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getBodyComponentXml()
	 */
	@Override
	public String getBodyComponentXml() {
		return getTargetForXml();
	}

	/**
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#setAttribute(org.jdom.Element)
	 */
	@Override
	public void setAttribute(Element element) {
		super.setAttribute(element);
		super.setType(LetsAjaxLayoutConstant.LETSAJAX_YUI_CALENDAR);

		String targetId = super.id;
		setTargetId(targetId);
	}

	private String getTargetForXml() {
		if (targetId == null || (targetId != null && targetId.equals(""))) {
			return "";
		}
		return " targetId=\"" + this.targetId + "\" ";
	}

	/**
	 * @return targetId
	 */
	public String getTargetId() {
		return targetId;
	}

	/**
	 * @param targetId
	 *            targetId ݒB
	 */
	public void setTargetId(String targetId) {
		this.targetId = targetId;
		firePropertyChange(P_TARGET_ID, null, targetId);
	}
}
