/**
 * vWFNg laxIde
 * NX YuiColorAnimateJSModel.java
 * 쐬: 2007/06/07
 * 
 */
package jp.co.cybec.laxide.model.js;

import jp.co.cybec.laxide.model.base.LetsAjaxLayoutConstant;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.views.properties.ColorPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.jdom.Element;

/**
 * YahooUĨJ[Aj[VpJavaScript̃f t@CFYuiColorAnimateJSModel.java
 * 
 * @author nakamura 쐬F10:24:12
 * 
 */
public class YuiColorAnimateJSModel extends JSBaseModel {

	public static final String P_TARGET_ID = "_targetId";

	public static final String P_COLOR_ID = "_color";

	private String targetId = "targetId";

	private String color = "#FFFFFF";

	private static final int HEIGHT = 80;

	private static final int WIDTH = 180;

	/** J[pbhRGBl */
	private int red, green, blue;

	public IPropertyDescriptor[] getPropertyDescriptors() {
		IPropertyDescriptor[] descriptors = new IPropertyDescriptor[] {
				new TextPropertyDescriptor(P_TARGET_ID, "^[QbgR|[lg"),
				new ColorPropertyDescriptor(P_COLOR_ID, "J[") };
		return descriptors;

	}

	public Object getPropertyValue(Object id) {
		if (id.equals(P_TARGET_ID)) {
			return this.targetId;
		} else if (id.equals(P_COLOR_ID)) {
			return new RGB(red, green, blue);
		}
		return null;
	}

	public boolean isPropertySet(Object id) {
		if (id.equals(P_TARGET_ID) || id.equals(P_COLOR_ID)) {
			return true;
		} else {
			return false;
		}
	}

	public void setPropertyValue(Object id, Object value) {
		if (id.equals(P_TARGET_ID)) {
			setTargetId((String) value);
		} else if (id.equals(P_COLOR_ID)) {
			setColor((RGB) value);
		}
	}

	public void setConstraint(Rectangle rect) {
		super.constraint = rect;
		if (super.constraint != null) {
			this.setX(Integer.toString(super.constraint.x));
			this.setY(Integer.toString(super.constraint.y));
			super.constraint.height = HEIGHT;
			super.constraint.width = WIDTH;
		}

		// ύX̒ʒm
		firePropertyChange(P_CONSTRAINT, null, constraint);
	}

	/**
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getBodyComponentXml()
	 */
	@Override
	public String getBodyComponentXml() {
		return getTargetForXml() + getColorForXml();
	}

	/**
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#setAttribute(org.jdom.Element)
	 */
	@Override
	public void setAttribute(Element element) {
		super.setAttribute(element);
		super.setType(LetsAjaxLayoutConstant.LETSAJAX_JS_YUI_COLOR_ANIMATE);

		String targetId = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_TARGETID);
		setTargetId(targetId);

		String color = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_BGCOLOR);
		int red = 0;
		int green = 0;
		int blue = 0;

		String redColor = color.substring(1, 3);
		if ((color.substring(1, 3) != null && !redColor.equals(""))
				&& this.color.length() >= 3) {
			red = Integer.parseInt(redColor, 16);
		}
		String greenColor = color.substring(3, 5);
		if ((greenColor != null && !greenColor.equals(""))
				&& this.color.length() >= 5) {
			green = Integer.parseInt(greenColor, 16);
		}
		String blueColor = color.substring(5);
		if ((blueColor != null && !blueColor.equals(""))
				&& this.color.length() == 7) {
			blue = Integer.parseInt(blueColor, 16);
		}
		setColor(new RGB(red, green, blue));

	}

	private String getTargetForXml() {
		if (targetId == null || (targetId != null && targetId.equals(""))) {
			return "";
		}
		return " targetId=\"" + this.targetId + "\" ";
	}

	/**
	 * @return targetId
	 */
	public String getTargetId() {
		return targetId;
	}

	/**
	 * @param targetId
	 *            targetId ݒB
	 */
	public void setTargetId(String targetId) {
		this.targetId = targetId;
		firePropertyChange(P_TARGET_ID, null, targetId);
	}

	/**
	 * @return color
	 */
	public String getColor() {
		return color;
	}

	/**
	 * @param color
	 *            color ݒB
	 */
	public void setColor(RGB rgb) {
		red = ((RGB) rgb).red;
		green = ((RGB) rgb).green;
		blue = ((RGB) rgb).blue;

		String redValue = Integer.toString(red, 16);
		if (redValue.length() < 2) {
			redValue = "0" + redValue;
		}
		String greenValue = Integer.toString(green, 16);
		if (greenValue.length() < 2) {
			greenValue = "0" + greenValue;
		}
		String blueValue = Integer.toString(blue, 16);
		if (blueValue.length() < 2) {
			blueValue = "0" + blueValue;
		}

		this.color = "#" + redValue + greenValue + blueValue;

		// J[pbh̕ύXEditPartɒʒm
		firePropertyChange(P_COLOR_ID, null, color);
	}

	private String getColorForXml() {
		if (this.color == null || (this.color != null && this.color.equals(""))) {
			return "";
		}
		return " bgColor=\"" + this.color + "\" ";
	}
}
