/**
 * vWFNg laxIde
 * NX LetsAjaxWizardUtility.java
 * 쐬: 2007/09/20
 * 
 */
package jp.co.cybec.laxide.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.co.cybec.laxGenerator.LaxFileManager;
import jp.co.cybec.laxGenerator.LayoutFileAnalyst;
import jp.co.cybec.laxide.file.template.JSTemplate;
import lax.LetsAjaxActivator;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

/**
 * HTMLJSECSSRs[萶肷NX t@CFLetsAjaxFileGenerateDelegate.java
 * 
 * @author nakamura 쐬F10:49:03
 * 
 */
public class LetsAjaxFileGenerateDelegate {
	/**
	 * HTML𐶐B
	 * 
	 * @param map
	 * @param layoutFileName
	 * @throws IOException
	 */
	public void generateHtml(Map map, final String fileName) {
		try {
			FileWriter file = new FileWriter(new File(fileName));
			String templateFileName = (String) map
					.get(LayoutFileAnalyst.TEMPLATE_CLASS);
			Class clazz = Class.forName("jp.co.cybec.laxide.file.template."
					+ templateFileName + "Template");
			Object obj = clazz.newInstance();

			Method method = clazz.getMethod("generate",
					new Class[] { Object.class });
			String html = (String) method.invoke(obj, map);

			file.write(html);
			file.flush();
			file.close();
		} catch (IOException e) {
			Plugin plugin = LetsAjaxActivator.getInstance();
			ILog log = plugin.getLog();
			log.log(new Status(IStatus.ERROR, LetsAjaxActivator.PLUGIN_ID, 0,
					"G[bZ[W", e));
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * JavaScriptt@C𐶐B
	 * 
	 * @param functionList
	 * @param fileName
	 */
	public void generateJS(List functionList, final String fileName) {
		try {
			FileWriter file = new FileWriter(new File(fileName));
			JSTemplate jsTemplate = new JSTemplate();
			file.write(jsTemplate.generate(functionList));
			file.flush();
			file.close();
		} catch (IOException e) {
			Plugin plugin = LetsAjaxActivator.getInstance();
			ILog log = plugin.getLog();
			log.log(new Status(IStatus.ERROR, LetsAjaxActivator.PLUGIN_ID, 0,
					"JS`o̓G[", e));
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * OJavaScriptt@Co̓fBNgɃRs[
	 * 
	 * @param map
	 */
	public void copyJsFiles(Map map, final String parentDir) {
		try {
			List<String> scriptNameList = (List) map
					.get(LaxFileManager.SCRIPTFILE_NAME_LIST);
			this.copyFile(scriptNameList, parentDir);
		} catch (IOException e) {
			Plugin plugin = LetsAjaxActivator.getInstance();
			ILog log = plugin.getLog();
			log.log(new Status(IStatus.ERROR, LetsAjaxActivator.PLUGIN_ID, 0,
					"OJSo̓G[", e));
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * OCSSt@Co̓fBNgɃRs[
	 * 
	 * @param map
	 */
	public void copyCssFiles(Map map, final String parentDir) {
		try {
			List<String> cssNameList = (List<String>) map
					.get(LaxFileManager.CSS_NAME_LIST);
			String templateFileName = (String) map
					.get(LayoutFileAnalyst.TEMPLATE_CLASS);
			// IFile file = pageGene.createNewFile();
			URL entry = LetsAjaxActivator.getInstance().getDefault()
					.getBundle().getEntry("/");
			// Eclipsẽo[W3.2艺̏ꍇ͂̕@
			// String fileName = Platform.resolve(entry).getPath() +
			// "otherLibs/"
			// + "/css/" + templateFileName + ".css";
			// Eclipsẽo[W3.2ȏ̏ꍇ͂̕@
			String fileName = FileLocator.resolve(entry).getPath()
					+ "otherLibs/" + "/css/" + templateFileName + ".css";

			File cssFile = new File(fileName);
			if (cssFile.exists()) {
				cssNameList.add("css/" + templateFileName + ".css");
			}

			List<String> imageFileList = (List<String>) map
					.get(LaxFileManager.IMAGE_FILE_NAME_LIST);

			cssNameList.addAll(imageFileList);
			this.copyFile(cssNameList, parentDir);
		} catch (IOException e) {
			Plugin plugin = LetsAjaxActivator.getInstance();
			ILog log = plugin.getLog();
			log.log(new Status(IStatus.ERROR, LetsAjaxActivator.PLUGIN_ID, 0,
					"OCSSo̓G[", e));
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * t@C̃Rs[B
	 * 
	 * @param nameList
	 * @throws IOException
	 */
	private void copyFile(List<String> nameList, final String generateDir)
			throws IOException {

		for (Iterator iter = nameList.iterator(); iter.hasNext();) {
			String name = (String) iter.next();
			URL entry = LetsAjaxActivator.getInstance().getDefault()
					.getBundle().getEntry("/");

			// Eclipsẽo[W3.2̏ꍇ͂̕@
			// String pluginDirectory = Platform.resolve(entry).getPath();
			String pluginDirectory = FileLocator.resolve(entry).getPath();
			File otherLib = new File(pluginDirectory + "otherLibs/" + name);

			if (otherLib.exists()) {
				File otherFile = new File(generateDir + "/" + name);

				otherFile.getParentFile().mkdir();
				FileInputStream reader = new FileInputStream(otherLib);
				FileOutputStream writer = new FileOutputStream(otherFile);
				int data;
				while ((data = reader.read()) != -1) {
					writer.write(data);
				}
				writer.flush();
				writer.close();
				reader.close();
			}
		}
	}

}
