/**
 * vWFNg laxIde
 * NX LetsAjaxNewProjcetWizard.java
 * 쐬: 2007/05/28
 * 
 */
package jp.co.cybec.laxide.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;

import jp.co.cybec.laxide.util.LetsAjaxWizardUtil;
import lax.LetsAjaxActivator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

/**
 * LAXpVKvWFNg쐬EBU[hNX.
 * <p>
 * t@CFLetsAjaxNewProjcetWizard.java
 * </p>
 * 
 * @author nakamura 쐬F10:52:21
 * 
 */
public class LetsAjaxNewProjcetWizard extends Wizard implements INewWizard {
	/** vWFNg쐬EBU[hy[W */
	private WizardNewProjectCreationPage pageCreateProject;

	/** vWFNg̃RtBOIuWFNg */
	private IConfigurationElement configElement;

	public LetsAjaxNewProjcetWizard() {
		setWindowTitle("LET'S AJAX VKvWFNg쐬EBU[h");
	}

	@Override
	public boolean performFinish() {
		boolean flag = false;
		// vWFNgtH_w肳Ă邩Aǂ𔻒肷B
		final IProject projectHandle = pageCreateProject.getProjectHandle();
		URI projectURI = (!pageCreateProject.useDefaults()) ? pageCreateProject
				.getLocationURI() : null;
		IWorkspace workspace = ResourcesPlugin.getWorkspace();

		final IProjectDescription desc = workspace
				.newProjectDescription(projectHandle.getName());

		// vWFNgڍ׏Zbg
		desc.setLocationURI(projectURI);

		// [NXy[Xւ̏sB
		WorkspaceModifyOperation op = new WorkspaceModifyOperation() {
			protected void execute(IProgressMonitor monitor)
					throws CoreException {
				createProject(desc, projectHandle, monitor);
			}
		};

		IWizardContainer container = getContainer();
		try {
			container.run(true, true, op);
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		// lC`[̐ݒ
		if (this.setNature(projectHandle)) {
			flag = true;
		}

		// ftHgVKLAXt@C̐
		if (this.createNewFile(projectHandle)) {
			flag = true;
		}

		return flag;
	}

	/**
	 * [NXy[XɃvWFNgtH_𐶐B
	 * 
	 * @param description
	 * @param projectHandle
	 * @param monitor
	 * @throws CoreException
	 * @throws OperationCanceledException
	 */
	private boolean createProject(IProjectDescription description,
			IProject proj, IProgressMonitor monitor) throws CoreException,
			OperationCanceledException {
		try {

			monitor.beginTask("", 2000);
			// vWFNgtH_̐
			proj.create(description, new SubProgressMonitor(monitor, 1000));

			if (monitor.isCanceled()) {
				throw new OperationCanceledException();
			}

			proj.open(IResource.BACKGROUND_REFRESH, new SubProgressMonitor(
					monitor, 1000));
			// vWFNgɕKvȃtH_𐶐B
			return this.createFolders(proj);

		} catch (Exception e) {
			Plugin plugin = LetsAjaxActivator.getInstance();
			ILog log = plugin.getLog();
			log.log(new Status(IStatus.ERROR, LetsAjaxActivator.PLUGIN_ID, 0,
					"LAXVKvWFNg쐬G[", e));
			e.printStackTrace();
			return false;
		}
	}

	/**
	 * LAXvWFNg̃tH_\쐬B
	 * 
	 * @param projectHandle
	 */
	private boolean createFolders(IProject projectHandle) {
		try {
			// tH_nh̍쐬
			IFolder folder = (IFolder) projectHandle.getFolder("html");
			// tH_쐬
			folder.create(false, true, null);

			// tH_nh̍쐬
			IFolder childFolder = (IFolder) projectHandle.getFolder("html/js");
			// tH_쐬
			childFolder.create(false, true, null);

			// tH_nh̍쐬
			IFolder childFolder2 = (IFolder) projectHandle
					.getFolder("html/css");
			// tH_쐬
			childFolder2.create(false, true, null);

		} catch (CoreException cex) {
			Plugin plugin = LetsAjaxActivator.getInstance();
			ILog log = plugin.getLog();
			log.log(new Status(IStatus.ERROR, LetsAjaxActivator.PLUGIN_ID, 0,
					"LAXVKvWFNgtH_쐬G[", cex));
			cex.printStackTrace();
			return false;
		}
		return true;
	}

	private boolean setNature(IProject projectHandle) {
		boolean flag = false;
		try {
			// -----------------
			// lC`[̐ݒ
			// -----------------

			// vWFNg̐߂API擾
			IProjectDescription description = projectHandle.getDescription();
			// ɐݒ肳ĂlC`[̃Xg擾
			String natures[] = description.getNatureIds();

			// ɃlC`[o^ĂꍇAňU폜
			for (int i = 0; i < natures.length; i++) {
				String[] newNatuers = new String[natures.length - 1];
				System.arraycopy(natures, 0, newNatuers, 0, 1);
				System.arraycopy(natures, i + 1, newNatuers, i,
						natures.length - 1 - 1);
				// ̃lC`[ݒu
				description.setNatureIds(newNatuers);
				// vWFNgɐݒ肷
				projectHandle.setDescription(description, null);
			}

			// VɃvWFNgp̃lC`[o^
			String[] newNatures = new String[natures.length + 1];
			System.arraycopy(natures, 0, newNatures, 0, natures.length);
			newNatures[natures.length] = LetsAjaxNature.NATURE_ID;
			// ̃lC`[ݒu
			description.setNatureIds(newNatures);
			// vWFNgɐݒ肷
			projectHandle.setDescription(description, null);

			// p[XyNeBu؂ւ
			BasicNewProjectResourceWizard.updatePerspective(configElement);

		} catch (CoreException cex) {
			Plugin plugin = LetsAjaxActivator.getInstance();
			ILog log = plugin.getLog();
			log.log(new Status(IStatus.ERROR, LetsAjaxActivator.PLUGIN_ID, 0,
					"LAXVKvWFNg쐬G[", cex));
			cex.printStackTrace();
			return false;
		}
		return flag;
	}

	/**
	 * vWFNg쐬Ƀt@C쐬B
	 * 
	 * @param projectHandle
	 * @return
	 */
	private boolean createNewFile(IProject projectHandle) {

		try {
			File file = new File(projectHandle.getLocation().toString()
					+ "/newLax.lax");
			file.createNewFile();
			InputStream stream = new FileInputStream(projectHandle
					.getLocation().toString()
					+ "/newLax.lax");

			IFile newFile = projectHandle.getFile("newLax.lax");
			newFile.create(stream, true, null);
			// ANeBuRg[̕ύX
			IWorkbenchPage page = PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow().getActivePage();
			// 쐬t@CGfB^[ŊJ
			IDE.openEditor(page, newFile, true);

			// 쐬t@Cɏ̃CAEgXMLݒ肷B
			LetsAjaxWizardUtil util = new LetsAjaxWizardUtil();
			util.initLaxDataToFile(file);

			return true;
		} catch (PartInitException e) {
			e.printStackTrace();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (CoreException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return false;
	}

	/**
	 * Creates a file resource handle for the file with the given workspace
	 * path. This method does not create the file resource; this is the
	 * responsibility of <code>createFile</code>.
	 * 
	 * @param filePath
	 *            the path of the file resource to create a handle for
	 * @return the new file resource handle
	 * @see #createFile
	 */
	protected IFile createFileHandle(IPath filePath) {

		return IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getFile(
				filePath);
	}

	/**
	 * g@\.
	 * <p>
	 * EclipseW̊g@\ł.
	 * </p>
	 * 
	 * @param config
	 * @param propertyName
	 * @param data
	 * @throws org.eclipse.core.runtime.CoreException
	 * @see {@link org.eclipse.core.runtime.IExecutableExtension#setInitializationData(IConfigurationElement, String, Object)}
	 */
	public void setInitializationData(IConfigurationElement config,
			String propertyName, Object data) throws CoreException {
		// p[XyNeBu؂ւŎgpRtBO擾Ă
		configElement = config;
	}

	/**
	 * .
	 * 
	 * @param workbench
	 * @param selection
	 * @see org.eclipse.ui.IWorkbenchWizard#init(IWorkbench,
	 *      IStructuredSelection)
	 */
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		// Ȃ
		// 񓯊sꍇȂǁAŃvOXj^\sĂ
		setNeedsProgressMonitor(true);
	}

	/**
	 * [NXy[XɃEBU[hIuWFNgݒ肵܂.
	 * 
	 * <p>
	 * EBU[h𐶐āAEclipsẽ[NXy[Xɏo͂܂B
	 * </p>
	 * 
	 * @see org.eclipse.jface.wizard.Wizard#addPages()
	 */
	public void addPages() {

		// EBU[hEy[W̍쐬
		pageCreateProject = new WizardNewProjectCreationPage("LET'S AJAX");
		// y[WE^Cg̐ݒ
		pageCreateProject.setTitle("vWFNg̓");
		// y[WE^Cg̉ɕ\
		pageCreateProject.setDescription("VK쐬LET'S AJAXvWFNg͂ĉ");
		// y[W̒ǉ
		addPage(pageCreateProject);
	}

	/**
	 * I{^픻.
	 * 
	 * <p>
	 * I{^ꂽꍇ̃of[V܂B
	 * </p>
	 * 
	 * @return boolean EBU[h͂Ăꍇ<code>true</code>AłȂꍇ<code>false</code>Ԃ܂
	 * @see org.eclipse.jface.wizard.Wizard#canFinish()
	 */
	public boolean canFinish() {

		// y[W̓͂Ă邩ǂ
		return pageCreateProject.isPageComplete();
	}
}
