/**
 * vWFNg laxIde
 * NX LetsAjaxWebAppGenerationWizard.java
 * 쐬: 2007/05/28
 * 
 */
package jp.co.cybec.laxide.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;

import jp.co.cybec.laxGenerator.LaxFileManager;
import lax.LetsAjaxActivator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/**
 * DhtmlJS𐶐EBU[hNX
 * <p>
 * t@CFLetsAjaxWebAppGenerationWizard.java
 * </p>
 * 
 * @author nakamura 쐬F11:02:16
 * 
 */
public class LetsAjaxWebAppGenerationWizard extends Wizard implements
		INewWizard {
	// INewWizard, IRunnableWithProgress {

	/**  */
	private IStructuredSelection selection;

	/** ǂݍ݌t@C擾EBU[hy[W */
	private LetsAjaxLoadWizardPage pageLoad;

	// /** WFl[gwEBU[hy[W */
	private LetsAjaxWebAppGenerationWizardPage1 pageGene;

	/** ftHgWFl[gt@C */
	public static final String DEFAULT_FILE_NAME = "test";

	private IWorkbenchWindow window;

	public LetsAjaxWebAppGenerationWizard() {
		super();
		setNeedsProgressMonitor(true);
		setWindowTitle("LAXt@CHTMLAJSt@C");

	}

	/**
	 * @see org.eclipse.jface.wizard.Wizard#addPage(org.eclipse.jface.wizard.IWizardPage)
	 */
	@Override
	public void addPages() {
		// y[W
		pageLoad = new LetsAjaxLoadWizardPage(LetsAjaxLoadWizardPage.PAGE_ID);
		// y[W^Cgݒ
		pageLoad.setTitle("HTMLAJSt@C");
		// y[Wݒ
		pageLoad.setDescription("LAXt@CHTMLAJSt@C𐶐܂B");
		// EBWFbgReiɊi[
		addPage(pageLoad);

		// y[W
		pageGene = new LetsAjaxWebAppGenerationWizardPage1(
				LetsAjaxWebAppGenerationWizardPage1.PAGE_ID, selection);
		// y[W^Cgݒ
		pageGene.setTitle("HTMLAJSt@C");
		// y[Wݒ
		pageGene.setDescription("LAXt@CHTMLAJSt@C𐶐܂B");
		// WFl[gt@C̃ftHg̐ݒ
		pageGene.setFileName("sampleGenerate");
		// EBWFbgReiɊi[
		addPage(pageGene);

	}

	/**
	 * @see org.eclipse.jface.wizard.Wizard#performCancel()
	 */
	@Override
	public boolean performCancel() {
		return true;
	}

	/**
	 * HTMLt@Co͏ɏBo͐⃌CAEgt@C̑I ̓EBU[h̒lgpB
	 * 
	 * @see org.eclipse.jface.wizard.Wizard#performFinish()
	 */
	@Override
	public boolean performFinish() {

		boolean isSuccess = false;
		try {
			// ǂݍ݌t@CpX擾
			pageGene.setFilePath(pageLoad.getFilePath());
			// t@CWFl[g
			IFile file = pageGene.createNewFile();

			// WFl[gʂNull̏ꍇ̓G[
			if (file == null) {
				return false;
			}
			String layoutFileName = this.pageLoad.getFilePath();
			String filePath = file.getLocation().toFile().getParent();
			String fileName = file.getLocation().toFile().getName() + ".html";
			String jsFileName = "js/" + file.getLocation().toFile().getName()
					+ ".js";
			String dataSourceFile = pageLoad.getDataSourceFilePath();

			IWorkbench workbench = PlatformUI.getWorkbench();
			IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
			Shell shell = window.getShell();
			// vOXo[g
			ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
			GenerateWithProgress generateThread = new GenerateWithProgress(
					layoutFileName, filePath, fileName, jsFileName,
					dataSourceFile);
			dialog.run(true, true, generateThread);
			return true;

		} catch (Exception e) {
			Plugin plugin = LetsAjaxActivator.getInstance();
			ILog log = plugin.getLog();
			log.log(new Status(IStatus.ERROR, LetsAjaxActivator.PLUGIN_ID, 0,
					"AvP[VG[", e));
			e.printStackTrace();
		}
		return isSuccess;
	}

	public void init(IWorkbench workbench, IStructuredSelection selection) {
		setNeedsProgressMonitor(true);
		this.window = workbench.getActiveWorkbenchWindow();
		this.selection = selection;
	}

	private class GenerateWithProgress implements IRunnableWithProgress {
		private String layoutFileName;

		private String filePath;

		private String fileName;

		private String jsFileName;

		private String dataSourceFile;

		public GenerateWithProgress(String layoutFileName, String filePath,
				String fileName, String jsFileName, String dataSourceFile) {
			this.layoutFileName = layoutFileName;
			this.fileName = fileName;
			this.filePath = filePath;
			this.jsFileName = jsFileName;
			this.dataSourceFile = dataSourceFile;
		}

		public void run(IProgressMonitor monitor)
				throws InvocationTargetException, InterruptedException {
			monitor.beginTask("HTML/JavaScript...", 10);
			try {
				monitor.subTask("LAXt@C");
				monitor.worked(1);

				LaxFileManager generator = new LaxFileManager(
						this.layoutFileName, this.fileName);
				Map map = generator.toAppFiles(this.dataSourceFile,
						LetsAjaxWizardsConstant.JS_DICTIONARY);

				monitor.subTask("LAXt@C͊...Bt@CJn");
				monitor.worked(3);
				LetsAjaxFileGenerateDelegate delegate = new LetsAjaxFileGenerateDelegate();

				delegate.generateHtml(map, filePath + "/" + fileName);
				delegate.generateJS((List) map.get(LaxFileManager.SCRIPT_LIST),
						filePath + "/" + jsFileName);
				monitor.subTask("t@C̃Rs[");
				monitor.worked(3);

				delegate.copyJsFiles(map, pageGene.createNewFile()
						.getLocation().toFile().getParent());
				delegate.copyCssFiles(map, pageGene.createNewFile()
						.getLocation().toFile().getParent());

				monitor.subTask("t@C");
				monitor.worked(1);
				if (monitor.isCanceled()) {
					throw new InterruptedException("Cancel has been requested.");
				}

			} catch (Exception e) {
				throw new InvocationTargetException(e);
			}
			monitor.done();
		}
	}

}
