/**
 * vWFNg laxIde
 * NX LetsAjaxWebAppGenerationWizardForAction.java
 * 쐬: 2007/05/28
 * 
 */
package jp.co.cybec.laxide.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;

import jp.co.cybec.laxGenerator.LaxFileManager;
import lax.LetsAjaxActivator;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/**
 * DhtmlJS𐶐EBU[hNX
 * <p>
 * t@CFLetsAjaxWebAppGenerationWizardForAction.java
 * </p>
 * 
 * @author nakamura 쐬F11:03:07
 * 
 */
public class LetsAjaxWebAppGenerationWizardForAction extends Wizard implements
		INewWizard {

	/**  */
	private IStructuredSelection selection;

	/** ǂݍ݌t@C擾EBU[hy[W */
	private LetsAjaxLoadWizardPage pageLoad;

	// // // /** WFl[gwEBU[hy[W */
	// private LetsAjaxWebAppGenerationWizardPage1 pageGene;

	/** WFl[gwEBU[hy[W */
	private LetsAjaxGenerateFileNameWizardPage pageGene;

	/** ftHgWFl[gt@C */
	public static final String DEFAULT_FILE_NAME = "test";

	// private IWorkbenchWindow window;

	public LetsAjaxWebAppGenerationWizardForAction() {
		super();
	}

	/**
	 * @see org.eclipse.jface.wizard.Wizard#addPage(org.eclipse.jface.wizard.IWizardPage)
	 */
	@Override
	public void addPages() {
		// y[W
		pageLoad = new LetsAjaxLoadWizardPage(LetsAjaxLoadWizardPage.PAGE_ID);
		// y[W^Cgݒ
		pageLoad.setTitle("HTMLAJSt@C");
		// y[Wݒ
		pageLoad.setDescription("LAXt@CHTMLAJSt@C𐶐܂B");
		// EBWFbgReiɊi[
		addPage(pageLoad);

		// y[W
		this.pageGene = new LetsAjaxGenerateFileNameWizardPage(
				LetsAjaxGenerateFileNameWizardPage.PAGE_ID);
		// y[W^Cgݒ
		this.pageGene.setTitle("t@Cw");
		// y[Wݒ
		this.pageGene.setDescription("LAXt@CHTMLAJSt@C𐶐܂B");
		// EBWFbgReiɊi[
		addPage(this.pageGene);
	}

	/**
	 * @see org.eclipse.jface.wizard.Wizard#performCancel()
	 */
	@Override
	public boolean performCancel() {
		return true;
	}

	/**
	 * HTMLt@Co͏ɏBo͐⃌CAEgt@C̑I ̓EBU[h̒lgpB
	 * 
	 * @see org.eclipse.jface.wizard.Wizard#performFinish()
	 */
	@Override
	public boolean performFinish() {
		boolean isSuccess = false;
		try {
			String projectFilePath = getRootPath(pageLoad.getFilePath());
			pageGene.setGenerateDir(projectFilePath);

			String layoutFileName = pageLoad.getFilePath();
			String filePath = pageGene.getGenerateDir();
			String fileName = pageGene.getHtmlFileName() + ".html";
			String jsFileName = "js/" + pageGene.getHtmlFileName() + ".js";
			String dataSourceFile = pageLoad.getDataSourceFilePath();

			IWorkbench workbench = PlatformUI.getWorkbench();
			IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
			Shell shell = window.getShell();
			// vOXo[g
			ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
			GenerateWithProgress generateThread = new GenerateWithProgress(
					layoutFileName, filePath, fileName, jsFileName,
					dataSourceFile);
			dialog.run(true, true, generateThread);
			return true;

		} catch (Exception e) {
			Plugin plugin = LetsAjaxActivator.getInstance();
			ILog log = plugin.getLog();
			log.log(new Status(IStatus.ERROR, LetsAjaxActivator.PLUGIN_ID, 0,
					"AvP[VG[", e));
			e.printStackTrace();
		}
		return isSuccess;
	}

	private String getRootPath(String filePath) {
		int index = filePath.lastIndexOf("\\");
		if (index == -1) {
			index = filePath.lastIndexOf("/");
			if (index == -1) {
				index = 0;
			}
		}
		return filePath.substring(0, index);
	}

	public void init(IWorkbench workbench, IStructuredSelection selection) {
		System.out.println("INIT WIZARD 1");
		setNeedsProgressMonitor(true);
		// this.window = workbench.getActiveWorkbenchWindow();
		this.selection = selection;
		System.out.println("INIT WIZARD 2");
	}

	private class GenerateWithProgress implements IRunnableWithProgress {
		private String layoutFileName;

		private String filePath;

		private String fileName;

		private String jsFileName;

		private String dataSourceFile;

		public GenerateWithProgress(String layoutFileName, String filePath,
				String fileName, String jsFileName, String dataSourceFile) {
			this.layoutFileName = layoutFileName;
			this.fileName = fileName;
			this.filePath = filePath;
			this.jsFileName = jsFileName;
			this.dataSourceFile = dataSourceFile;
		}

		public void run(IProgressMonitor monitor)
				throws InvocationTargetException, InterruptedException {
			monitor.beginTask("HTML/JavaScript...", 10);
			try {
				monitor.subTask("LAXt@C");
				monitor.worked(1);

				LaxFileManager generator = new LaxFileManager(
						this.layoutFileName, this.fileName);
				Map map = generator.toAppFiles(this.dataSourceFile,
						LetsAjaxWizardsConstant.JS_DICTIONARY);

				monitor.subTask("LAXt@C͊...Bt@CJn");
				monitor.worked(3);
				LetsAjaxFileGenerateDelegate delegate = new LetsAjaxFileGenerateDelegate();
				delegate.generateHtml(map, filePath + "/html/" + fileName);
				delegate.generateJS((List) map.get(LaxFileManager.SCRIPT_LIST),
						filePath + "/html/" + jsFileName);
				monitor.subTask("t@C̃Rs[");
				monitor.worked(3);

				delegate.copyJsFiles(map, pageGene.getGenerateDir() + "/html");
				delegate.copyCssFiles(map, pageGene.getGenerateDir() + "/html");

				monitor.subTask("t@C");
				monitor.worked(3);
				if (monitor.isCanceled()) {
					throw new InterruptedException("Cancel has been requested.");
				}

			} catch (Exception e) {
				throw new InvocationTargetException(e);
			}

			monitor.done();
		}
	}

}
