package jp.co.lax.sample.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import jp.co.lax.sample.service.dao.TaskBoardDao;

import org.apache.log4j.Logger;

public class TaskBoardManager {
	private List taskList = new ArrayList();

	private Logger log = Logger.getLogger(TaskBoardManager.class);

	public List findAll() {
		TaskBoardDao dao = new TaskBoardDao();
		this.taskList = dao.findTaskList();
		return taskList;
	}

	public TaskPaper findByPrimaryKey(final String taskId) {
		TaskBoardDao dao = new TaskBoardDao();
		log.info("TASK BOARD:" + taskId);
		TaskPaper paper = dao.findByPrimaryKey(Long.parseLong(taskId));
		log.info("TASK BOARD ID:" + paper.getId());
		log.info("TASK TITLE:" + paper.getTitle());
		return paper;
	}
    public List findByConditions(final String taskId,final String title, final String author){
    	return null;
    }
	
	public TaskPaper getTaskPaper(int index) {
		return (TaskPaper) this.taskList.get(index);
	}

	public void deleteAllTask() {
		TaskBoardDao dao = new TaskBoardDao();
		dao.deleteAllTask();
	}

	public void remove(final String taskId) {
		TaskBoardDao dao = new TaskBoardDao();
		dao.deleteTaskById(Long.parseLong(taskId));
	}

	public void add(final String title, final String author, final String status) {
		TaskBoardDao dao = new TaskBoardDao();
		dao.addTask(title, author, Long.parseLong(status));
	}

	public void update(final String taskId, final String title,
			final String author, final String status) {
		TaskBoardDao dao = new TaskBoardDao();
		dao.updateTask(Long.parseLong(taskId), title, author, Long
				.parseLong(status));
	}

	public HashMap getMapData() {
		HashMap map = new HashMap();
		map.put("taskName", "TEST TEST TEST");
		map.put("taskTitle", "TEST TITLE.");
		return map;
	}
	
	public String getAuthorHistory(){
		return "hogehoge";
	}

}
