package jp.co.lax.sample.service.dao;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;

import jp.co.lax.sample.service.util.PropertyLoader;

import org.apache.log4j.Logger;

public abstract class BaseDao {
	protected static String DB_URL = "db.url";

	protected static String DB_DRIVER = "db.driver";

	protected static String DB_USER_NAME = "db.userId";

	protected static String DB_PASSWORD = "db.password";

	protected Connection connection;

	private Logger log = Logger.getLogger(BaseDao.class);

	protected void initConnection() throws IOException {
		// vpeBt@Cڑ擾
		log.info("SET DB INFO");
		// ConnectionIuWFNg擾B
		if (this.connection == null) {
			Map map = PropertyLoader.loadSystemProperties();
			String url = (String) map.get(DB_URL);
			String className = (String) map.get(DB_DRIVER);
			String userName = (String) map.get(DB_USER_NAME);
			String password = (String) map.get(DB_PASSWORD);

			try {

				Class.forName(className);
				this.connection = DriverManager.getConnection(url, userName,
						password);
				log.info("CONNECT DB");
			} catch (SQLException e) {

				e.printStackTrace();
			} catch (ClassNotFoundException e) {

				e.printStackTrace();
			}
		}

	}
}
