<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: admin_mainFilebrowseWidgetContainer.php 2142 2009-07-18 10:58:27Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getCurrentWidgetContainerPath() . '/admin_mainBrowseBaseWidgetContainer.php');

class admin_mainFilebrowseWidgetContainer extends admin_mainBrowseBaseWidgetContainer
{
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'filebrowse.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$path = $request->trimValueOf('path');		// 現在のパス
		if (empty($path)) $path = $this->gEnv->getResourcePath();// デフォルトはリソースディレクトリ
		
		// ファイル一覧を作成
		$this->createFileList($path);
		
		$this->tmpl->addVar('_widget', 'root_url', $this->gEnv->getRootUrl());
		//$this->tmpl->addVar('_widget', 'url', $this->gEnv->getScriptsUrl() . self::FILE_BROWSER_PATH);
		$this->tmpl->addVar('_widget', 'path', $path);// 現在のディレクトリ
	}
	/**
	 * ファイル一覧を作成
	 *
	 * @param string $path	ディレクトリパス
	 * @return なし
	 */
	function createFileList($path)
	{
		//$fileList = array();
		if (is_dir($path)){
			// 親ディレクトリを追加
			$file = '..';
			$row = array(
				'filename'    => $this->convertToDispString($file),			// ファイル名
				'size'     => $size,			// ファイルサイズ
				'selected' => $selected														// 選択中かどうか
			);
			$this->tmpl->addVars('file_list', $row);
			$this->tmpl->parseTemplate('file_list', 'a');
					
			$dir = dir($path);
			while (($file = $dir->read()) !== false){
				$filePath = $path . '/' . $file;
				// カレントディレクトリかどうかチェック
				if ($file != '.' && $file != '..'){
					//if (!$fileOnly || ($fileOnly && is_file($filePath))) $fileList[] = $file;
					$row = array(
						'filename'    => $this->convertToDispString($file),			// ファイル名
						'size'     => $size,			// ファイルサイズ
						'selected' => $selected														// 選択中かどうか
					);
					$this->tmpl->addVars('file_list', $row);
					$this->tmpl->parseTemplate('file_list', 'a');
				}
			}
			$dir->close();
		}
		//sort($fileList);		// ファイル名をソート
	}
}
?>
