<?php
/**
 * index.php用コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2009 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id: reg_userLoginWidgetContainer.php 2030 2009-07-02 02:59:00Z fishbone $
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getIncludePath() . '/common/userInfo.php');		// ユーザ情報クラス
require_once($gEnvManager->getCurrentWidgetDbPath() .	'/reg_userDb.php');

class reg_userLoginWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $sysDb;		// システムDBオブジェクト
	const REGIST_USER_COMPLETED_FORM = 'regist_user_completed';		// メールフォーム
	const DEFAULT_PASSWORD = '********';	// 設定済みを示すパスワード
	
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		$this->db = new reg_userDb();
		$this->sysDb = $this->gInstance->getSytemDbObject();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{
		return 'login.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		$paramObj = $this->getWidgetParamObj();
		if (!empty($paramObj)){
			$this->authType	= $paramObj->authType;			// 承認タイプ
		}
		if (empty($this->authType)){
			return;			// 承認タイプが設定されていないときは終了
		}
				
		$act = $request->trimValueOf('act');
		// ユーザ自動認証のときのみ処理を実行
		if ($this->authType != 'auto') return;
		
		if ($act == 'user_maillogin'){		// メールからのログイン画面の表示
			$account = $request->trimValueOf('account');
			$pwd = $request->trimValueOf('pwd');
			
			// ハッシュキー作成
			$postTicket = md5(time() . $this->gAccess->getAccessLogSerialNo());
			$request->setSessionValue(M3_SESSION_POST_TICKET, $postTicket);		// セッションに保存
			
			$this->tmpl->addVar("_widget", "ticket", $postTicket);				// 画面に書き出し
			$this->tmpl->addVar("_widget", "user_account", $account);
			$this->tmpl->addVar("_widget", "user_password", $pwd);
		} else if ($act == 'user_login'){			// 会員ログインのとき
			// アカウント、パスワード取得
			$account = $request->trimValueOf('user_account');
			$password = $request->trimValueOf('password');
			$postTicket = $request->trimValueOf('ticket');		// POST確認用
			
			$isErr = true;	// エラー発生状況
			if (!empty($postTicket) && $postTicket == $request->getSessionValue(M3_SESSION_POST_TICKET)){		// 正常なPOST値のとき
				// ユーザ認証
				if ($this->gAccess->userLoginByAccount($account, $password, false/*アクセス権はチェックしない*/)){
					// 未承認ユーザから一般ユーザへ変更
					$userId = $this->gEnv->getCurrentUserId();
					if ($userId != 0){
						if (!$this->sysDb->isAuthenticatedUser($userId)){		// 未承認のときのみ承認作業を行う
							$ret = $this->sysDb->makeNormalLoginUser($userId);// 一般ログインユーザに設定
							if ($ret){
								$fromAddress = '';			// 管理者宛メールアドレス
								if (empty($fromAddress)) $fromAddress = $this->gEnv->getSiteEmail();// 送信元が取得できないときは、システムのデフォルトメールアドレスを使用
								$toAddress = $fromAddress;			// eメール(ログインアカウント)
								$mailParam = array();
								$mailParam['ACCOUNT'] = $account;
								$ret = $this->gMail->sendFormMail(1, $this->gEnv->getCurrentWidgetId(), $toAddress, $fromAddress, '', '', self::REGIST_USER_COMPLETED_FORM, $mailParam);// 自動送信
								$message = 'ログイン完了しました。ユーザが承認されました。';
								$this->setGuidanceMsg($message);
								$isErr = false;				// 正常終了
							}
						} else {	// 承認済みのとき
							$message = 'ログイン完了しました。このユーザは承認済みです。';
							$this->setGuidanceMsg($message);
							$isErr = false;				// 正常終了
						}
					}
				}
			}
			if ($isErr){		// エラー発生のとき
				// ログイン状態を削除
				$this->gAccess->userLogout();
			
				$message = 'ログインに失敗しました。';
				$this->setUserErrorMsg($message);
			} else {
				$this->tmpl->addVar("_widget", "user_account", $account);
				$this->tmpl->addVar("_widget", "user_password", self::DEFAULT_PASSWORD);
				
				$this->tmpl->addVar("_widget", "account_disabled", 'disabled');
				$this->tmpl->addVar("_widget", "password_disabled", 'disabled');
				$this->tmpl->addVar("_widget", "login_disabled", 'disabled');// 送信ボタン
			}
		}
	}
}
?>
