/*
 * Decompiled with CFR 0.152.
 */
package org.manjyu.rss;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.manjyu.rss.ManjyuRssParserHandler;
import org.manjyu.rss.vo.ManjyuRssChannel;
import org.manjyu.rss.vo.ManjyuRssItem;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class ManjyuRssParser {
    protected abstract void processChannel(ManjyuRssChannel var1) throws IOException;

    protected abstract void processItem(ManjyuRssItem var1) throws IOException;

    public void parse(InputStream inStream) throws IOException {
        ManjyuRssParserHandler handler = new ManjyuRssParserHandler(this);
        try {
            XMLReader reader = null;
            try {
                reader = XMLReaderFactory.createXMLReader();
            }
            catch (SAXException exCreateXMLReader) {
                Logger.getLogger("org.manjyu.rss").fine("Fail to get XMLReader instance: " + exCreateXMLReader.toString());
                SAXResult result = new SAXResult(handler);
                result.setHandler(handler);
                TransformerFactory tf = TransformerFactory.newInstance();
                try {
                    Transformer transformer = tf.newTransformer();
                    transformer.transform(new StreamSource(inStream), result);
                    return;
                }
                catch (TransformerException e2) {
                    throw new IOException("Fail to parse XML: " + e2.toString(), e2);
                }
            }
            try {
                reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (SAXNotRecognizedException exAvoidExternalDtd) {
                Logger.getLogger("org.manjyu.rss").finest("Fail to avoid reading external DTD defs: " + exAvoidExternalDtd.toString());
            }
            reader.setContentHandler(handler);
            reader.parse(new InputSource(inStream));
            return;
        }
        catch (SAXException ex) {
            throw new IOException("Error occured processing XML parse: " + ex.toString(), ex);
        }
    }
}

