/*******************************************************************************
 * ManjyuRss
 * Copyright (C) 2012 Toshiki IGA
 * 
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *******************************************************************************/
/*******************************************************************************
 * Copyright (c) 2012 Toshiki IGA and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *      Toshiki IGA - initial API and implementation
 *******************************************************************************/
/*******************************************************************************
 * Copyright 2012 Toshiki IGA and others.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/
package org.manjyu.rss.util;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

/**
 * Date Utils of ManjyuRss
 *
 * @author Toshiki Iga
 */
public class ManjyuRssDateUtil {
	public static String date2Rfc822String(final Date date) {
		final SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
		return sdf.format(date);
	}

	public static Date rfc822String2Date(final String rfc822string) throws IOException {
		try {
			final SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
			return sdf.parse(rfc822string);
		} catch (ParseException e) {
			try {
				// FIXME
				final SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
				return sdf.parse(rfc822string);
			} catch (ParseException e1) {
				throw new IOException("Cannot recognized RFC822 date format: [" + rfc822string + "]", e1);
			}
		}
	}

	public static Date w3cdtfString2Date(String w3cdtfString) throws IOException {
		w3cdtfString = w3cdtfString.replace('T', '_');

		// Trim time zone ':'
		if (w3cdtfString.length() > 24 && w3cdtfString.charAt(24) == ':') {
			w3cdtfString = w3cdtfString.substring(0, 24) + w3cdtfString.substring(25, w3cdtfString.length());
		}
		if (w3cdtfString.length() > 22 && w3cdtfString.charAt(22) == ':') {
			w3cdtfString = w3cdtfString.substring(0, 22) + w3cdtfString.substring(23, w3cdtfString.length());
		}
		if (w3cdtfString.length() > 19 && w3cdtfString.charAt(19) == ':') {
			w3cdtfString = w3cdtfString.substring(0, 19) + w3cdtfString.substring(20, w3cdtfString.length());
		}

		try {
			final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SZ", Locale.US);
			return sdf.parse(w3cdtfString);
		} catch (ParseException e) {
			try {
				final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ssZ", Locale.US);
				return sdf.parse(w3cdtfString);
			} catch (ParseException e1) {
				try {
					final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH:mmZ", Locale.US);
					return sdf.parse(w3cdtfString);
				} catch (ParseException e2) {
					try {
						final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
						return sdf.parse(w3cdtfString);
					} catch (ParseException e3) {
						try {
							final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM", Locale.US);
							return sdf.parse(w3cdtfString);
						} catch (ParseException e4) {
							try {
								final SimpleDateFormat sdf = new SimpleDateFormat("yyyy", Locale.US);
								return sdf.parse(w3cdtfString);
							} catch (ParseException e5) {
								throw new IOException("Cannot recognized W3CDTF date format: [" + w3cdtfString + "]",
										e1);
							}
						}
					}
				}
			}
		}
	}
}
