/*******************************************************************************
 * ManjyuRss
 * Copyright (C) 2012 Toshiki IGA
 * 
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *******************************************************************************/
/*******************************************************************************
 * Copyright (c) 2012 Toshiki IGA and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *      Toshiki IGA - initial API and implementation
 *******************************************************************************/
/*******************************************************************************
 * Copyright 2012 Toshiki IGA and others.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/
package org.manjyu.rss.vo;

import java.util.ArrayList;
import java.util.List;

import org.xml.sax.Attributes;

import blanco.gettersetter.BlancoGetterSetter;

/**
 * Attributes implementation to use with SAX API.
 * 
 * @author Toshiki Iga
 */
public class AbstractManjyuRssAttributes implements Attributes {
	@BlancoGetterSetter(setter = false)
	protected List<ManjyuRssAttribute> attrList = new ArrayList<ManjyuRssAttribute>();

	@Override
	public int getLength() {
		return attrList.size();
	}

	@Override
	public String getURI(int index) {
		final ManjyuRssAttribute attribute = getAttr(index);
		if (attribute == null) {
			return null;
		}

		return attribute.getUri();
	}

	@Override
	public String getLocalName(int index) {
		final ManjyuRssAttribute attribute = getAttr(index);
		if (attribute == null) {
			return null;
		}

		return attribute.getLocalName();
	}

	@Override
	public String getQName(int index) {
		final ManjyuRssAttribute attribute = getAttr(index);
		if (attribute == null) {
			return null;
		}

		final String qName = null2Blank(attribute.getQName());
		if (qName.length() == 0) {
			return getLocalName(index);
		}

		return attribute.getQName();
	}

	@Override
	public String getType(int index) {
		final ManjyuRssAttribute attribute = getAttr(index);
		if (attribute == null) {
			return null;
		}

		return attribute.getType();
	}

	@Override
	public String getValue(int index) {
		final ManjyuRssAttribute attribute = getAttr(index);
		if (attribute == null) {
			return null;
		}

		return attribute.getValue();
	}

	@Override
	public int getIndex(final String uri, final String localName) {
		final int attrSize = attrList.size();
		for (int index = 0; index < attrSize; index++) {
			final ManjyuRssAttribute attrLook = attrList.get(index);
			if (null2Blank(attrLook.getUri()).equals(uri) && null2Blank(attrLook.getLocalName()).equals(localName)) {
				return index;
			}
		}

		// Not found
		return -1;
	}

	@Override
	public int getIndex(final String qName) {
		final int attrSize = attrList.size();
		for (int index = 0; index < attrSize; index++) {
			final ManjyuRssAttribute attrLook = attrList.get(index);
			if (null2Blank(attrLook.getQName()).equals(qName)) {
				return index;
			}
		}

		// Not found
		return -1;
	}

	@Override
	public String getType(final String uri, final String localName) {
		final ManjyuRssAttribute attrFound = findByUriLocalName(uri, localName);
		if (attrFound == null) {
			// Not found
			return null;
		}

		return attrFound.getType();
	}

	@Override
	public String getType(final String qName) {
		final ManjyuRssAttribute attrFound = findByQName(qName);
		if (attrFound == null) {
			// Not found
			return null;
		}

		return attrFound.getType();
	}

	@Override
	public String getValue(final String uri, final String localName) {
		final ManjyuRssAttribute attrFound = findByUriLocalName(uri, localName);
		if (attrFound == null) {
			// Not found
			return null;
		}

		return attrFound.getValue();
	}

	@Override
	public String getValue(final String qName) {
		final ManjyuRssAttribute attrFound = findByQName(qName);
		if (attrFound == null) {
			// Not found
			return null;
		}

		return attrFound.getValue();
	}

	private ManjyuRssAttribute getAttr(int index) {
		if (index >= attrList.size()) {
			return null;
		}

		return attrList.get(index);
	}

	private ManjyuRssAttribute findByUriLocalName(final String uri, final String localName) {
		final int attrSize = attrList.size();
		for (int index = 0; index < attrSize; index++) {
			final ManjyuRssAttribute attrLook = attrList.get(index);
			if (null2Blank(attrLook.getUri()).equals(uri) && null2Blank(attrLook.getLocalName()).equals(localName)) {
				return attrLook;
			}
		}

		// Not found
		return null;
	}

	private ManjyuRssAttribute findByQName(final String qName) {
		final int attrSize = attrList.size();
		for (int index = 0; index < attrSize; index++) {
			final ManjyuRssAttribute attrLook = attrList.get(index);
			if (null2Blank(attrLook.getUri()).equals(qName)) {
				return attrLook;
			}
		}

		// Not found
		return null;
	}

	private static final String null2Blank(final String value) {
		if (value == null) {
			return "";
		}

		return value;
	}
}
